/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hy.common.Help;
import org.hy.common.TablePartitionRID;
import org.hy.microservice.common.state.StateInfo;
import org.hy.microservice.common.state.Transition;

public class StateMachine {
    private static final String $Split = "->";
    private final TablePartitionRID<String, Transition> transitions = new TablePartitionRID();
    private final Transition[] transitionList;
    private final String[] startStates;
    private final String[] endStates;
    private final Map<String, StateInfo> stateInfos;

    public StateMachine(Transition[] i_Transitions) {
        if (Help.isNull((Object[])i_Transitions)) {
            throw new NullPointerException("Transitions is null");
        }
        this.transitionList = i_Transitions;
        HashSet<String> v_ToStates = new HashSet<String>();
        for (Transition v_Item : i_Transitions) {
            if (this.getTargetTransition(v_Item.getFromState(), v_Item.getAction()) != null) {
                throw new RuntimeException(v_Item.getFromState() + $Split + v_Item.getAction() + " is exists.");
            }
            if (this.checkStateFromTo(v_Item.getFromState(), v_Item.getToState())) {
                throw new RuntimeException(v_Item.getFromState() + $Split + this.getAction(v_Item.getFromState(), v_Item.getToState()) + $Split + v_Item.getToState() + " is exists.");
            }
            this.transitions.putRow((Object)v_Item.getFromState(), v_Item.getAction(), (Object)v_Item);
            v_ToStates.add(v_Item.getToState());
        }
        Set v_StartStates = this.findStartStates(v_ToStates);
        Set v_EndStates = this.findEndStates(v_ToStates);
        this.checkStartEnd(v_StartStates, v_EndStates);
        this.stateInfos = this.calcStatesLevel(v_StartStates, v_EndStates);
        this.startStates = v_StartStates.toArray(new String[0]);
        this.endStates = v_EndStates.toArray(new String[0]);
        v_ToStates.clear();
        v_StartStates.clear();
        v_EndStates.clear();
        v_ToStates = null;
        v_StartStates = null;
        v_EndStates = null;
    }

    private Map<String, StateInfo> calcStatesLevel(Set<String> i_StartStates, Set<String> i_EndStates) {
        HashMap<String, StateInfo> v_States = new HashMap<String, StateInfo>();
        if (!Help.isNull(i_EndStates)) {
            for (String v_EndState : i_EndStates) {
                v_States.put(v_EndState, new StateInfo(StateInfo.$EndLevel, Integer.valueOf(0)));
            }
        }
        if (!Help.isNull(i_StartStates)) {
            for (String v_StartState : i_StartStates) {
                this.calcStatesLevelFor(v_States, v_StartState, StateInfo.$StartLevel.intValue());
            }
        }
        return v_States;
    }

    private void calcStatesLevelFor(Map<String, StateInfo> io_States, String i_FromState, int i_FromLevel) {
        Map v_Transitions = (Map)this.transitions.get((Object)i_FromState);
        if (!Help.isNull((Map)v_Transitions)) {
            io_States.put(i_FromState, new StateInfo(Integer.valueOf(i_FromLevel), Integer.valueOf(v_Transitions.size())));
            ArrayList<String> v_AddStates = new ArrayList<String>();
            int v_Level = i_FromLevel + 1;
            for (Transition v_ToState : v_Transitions.values()) {
                StateInfo v_Old;
                if (i_FromState.equals(v_ToState.getToState()) || (v_Old = io_States.get(v_ToState.getToState())) != null) continue;
                io_States.put(v_ToState.getToState(), new StateInfo(Integer.valueOf(v_Level), Integer.valueOf(1)));
                v_AddStates.add(v_ToState.getToState());
            }
            if (!Help.isNull(v_AddStates)) {
                for (String i_AddState : v_AddStates) {
                    this.calcStatesLevelFor(io_States, i_AddState, v_Level);
                }
            }
            v_AddStates.clear();
            v_AddStates = null;
        }
    }

    private void checkStartEnd(Set<String> i_StartStates, Set<String> i_EndStates) {
        if (!Help.isNull(i_StartStates)) {
            for (String i_StartState : i_StartStates) {
                if (!i_EndStates.contains(i_StartState)) continue;
                throw new RuntimeException("StartState[" + i_StartState + "] is EndState again.");
            }
        }
        if (!Help.isNull(i_EndStates)) {
            for (String i_EndState : i_EndStates) {
                if (!i_StartStates.contains(i_EndState)) continue;
                throw new RuntimeException("EndState[" + i_EndState + "] is StartState again.");
            }
        }
    }

    private Set<String> findStartStates(Set<String> i_ToStates) {
        HashSet<String> v_StartStates = new HashSet<String>();
        if (!Help.isNull(i_ToStates)) {
            for (Transition v_Item : this.transitionList) {
                if (i_ToStates.contains(v_Item.getFromState())) continue;
                v_StartStates.add(v_Item.getFromState());
            }
        }
        return v_StartStates;
    }

    private Set<String> findEndStates(Set<String> i_ToStates) {
        HashSet<String> v_EndStates = new HashSet<String>();
        if (!Help.isNull(i_ToStates)) {
            for (String v_ToState : i_ToStates) {
                if (this.transitions.containsKey((Object)v_ToState)) continue;
                v_EndStates.add(v_ToState);
            }
        }
        return v_EndStates;
    }

    public Set<String> allowActions(String i_FromState) {
        Map v_Actions = (Map)this.transitions.get((Object)i_FromState);
        if (Help.isNull((Map)v_Actions)) {
            return null;
        }
        return v_Actions.keySet();
    }

    public Transition getTargetTransition(String i_FromState, String i_Action) {
        return (Transition)this.transitions.getRow((Object)i_FromState, i_Action);
    }

    public String getTargetState(String i_FromState, String i_Action) {
        Transition v_Transition = this.getTargetTransition(i_FromState, i_Action);
        if (v_Transition == null) {
            return null;
        }
        return v_Transition.getToState();
    }

    public boolean checkTransition(String i_FromState, String i_Action, String i_ToState) {
        Transition v_Transition = this.getTargetTransition(i_FromState, i_Action);
        if (v_Transition == null) {
            return false;
        }
        return v_Transition.getToState().equals(i_ToState);
    }

    public boolean checkAction(String i_FromState, String i_Action) {
        Transition v_Transition = this.getTargetTransition(i_FromState, i_Action);
        return v_Transition != null;
    }

    public String getAction(String i_FromState, String i_ToState) {
        Map v_Actions = (Map)this.transitions.get((Object)i_FromState);
        if (Help.isNull((Map)v_Actions)) {
            return null;
        }
        String v_Action = null;
        for (Transition v_Item : v_Actions.values()) {
            if (!v_Item.getToState().equals(i_ToState)) continue;
            if (v_Action != null) {
                return null;
            }
            v_Action = v_Item.getAction();
        }
        return v_Action;
    }

    public boolean checkStateFromTo(String i_FromState, String i_ToState) {
        return this.getAction(i_FromState, i_ToState) != null;
    }

    public Transition[] getTransitions() {
        return this.transitionList;
    }

    public String[] getStartStates() {
        return this.startStates;
    }

    public String[] getEndStates() {
        return this.endStates;
    }

    public StateInfo getStateInfo(String i_State) {
        return (StateInfo)this.stateInfos.get(i_State);
    }
}

