/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.heartbeat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.app.Param;
import org.hy.common.redis.IRedis;
import org.hy.common.xml.XJava;
import org.hy.common.xml.annotation.Xjava;
import org.hy.microservice.common.heartbeat.Heartbeat;
import org.hy.microservice.common.heartbeat.IHeartbeatCache;

@Xjava
public class HeartbeatCache
implements IHeartbeatCache {
    private static final String $RedisXID = "RedisOperation_MS_Common";
    private static final String $RTable = "Heartbeat";
    @Xjava(ref="MS_Common_ServiceName")
    private Param redisDatabaseName;
    @Xjava(ref="MS_Common_Heartbeat_RedisDelExpire")
    private Param redisDelExpire;

    @Override
    public boolean save(Heartbeat io_Heartbeat) {
        IRedis v_Redis = (IRedis)XJava.getObject((String)$RedisXID);
        io_Heartbeat.setUpdateTime(v_Redis.getNowTime());
        if (io_Heartbeat.getUpdateTime() == null) {
            io_Heartbeat.setUpdateTime(new Date());
        } else {
            io_Heartbeat.setUpdateTime(new Date(io_Heartbeat.getUpdateTime().getTime() + 28800000L));
        }
        Date v_InvalidTime = io_Heartbeat.getInvalidTime();
        if (v_InvalidTime != null) {
            v_Redis.insert("msModbus", $RTable, io_Heartbeat.getEdgeIP(), "invalidTime", io_Heartbeat.getInvalidTime().getFull());
            io_Heartbeat.setInvalidTime(null);
        }
        if (v_Redis.save(this.redisDatabaseName.getValue(), $RTable, this.redisDatabaseName.getValue() + io_Heartbeat.getEdgeIP(), (Object)io_Heartbeat) >= 1L) {
            io_Heartbeat.setInvalidTime(v_InvalidTime);
            return true;
        }
        io_Heartbeat.setInvalidTime(v_InvalidTime);
        return false;
    }

    @Override
    public List<Heartbeat> queryByValids(int i_Second) {
        IRedis v_Redis = (IRedis)XJava.getObject((String)$RedisXID);
        Date v_RedisNowTime = v_Redis.getNowTime();
        if (v_RedisNowTime == null) {
            return null;
        }
        v_RedisNowTime = new Date(v_RedisNowTime.getTime() + 28800000L);
        List v_Heartbeats = v_Redis.getRowsList(this.redisDatabaseName.getValue(), $RTable, Heartbeat.class);
        if (!Help.isNull((List)v_Heartbeats)) {
            for (int x = v_Heartbeats.size() - 1; x >= 0; --x) {
                Heartbeat v_Item = (Heartbeat)v_Heartbeats.get(x);
                if (v_Item.getIsValid() != 1) {
                    v_Heartbeats.remove(x);
                    continue;
                }
                if (v_RedisNowTime.differ(v_Item.getUpdateTime()) >= (long)(i_Second * -1000)) {
                    v_Heartbeats.remove(x);
                    continue;
                }
                if (v_RedisNowTime.differ(new Date(v_Item.getOsTime())) < (long)(i_Second * -1000)) continue;
                v_Heartbeats.remove(x);
            }
            if (Help.isNull((List)v_Heartbeats)) {
                return v_Heartbeats;
            }
            Help.toSort((List)v_Heartbeats, (String[])new String[]{"hostIP", "edgeStartTime DESC"});
            HashMap<String, Integer> v_DistinctHostIP = new HashMap<String, Integer>();
            for (int x = v_Heartbeats.size() - 1; x >= 0; --x) {
                Heartbeat v_Item = (Heartbeat)v_Heartbeats.get(x);
                Integer v_ListIndex = (Integer)v_DistinctHostIP.get(v_Item.getHostIP());
                if (v_ListIndex == null) {
                    v_DistinctHostIP.put(v_Item.getHostIP(), v_ListIndex);
                    continue;
                }
                v_Heartbeats.remove(x);
            }
            v_DistinctHostIP.clear();
            v_DistinctHostIP = null;
            Help.toSort((List)v_Heartbeats, (String[])new String[]{"edgeStartTime", "edgeIP"});
        }
        return v_Heartbeats;
    }

    @Override
    public void delEdgeIP(String i_EdgeIP) {
        IRedis v_Redis = (IRedis)XJava.getObject((String)$RedisXID);
        v_Redis.delete(this.redisDatabaseName.getValue(), $RTable, this.redisDatabaseName.getValue() + i_EdgeIP);
    }

    @Override
    public void delExpire() {
        this.delExpire(this.redisDelExpire.getValueInt());
    }

    @Override
    public void delExpire(int i_Day) {
        IRedis v_Redis = (IRedis)XJava.getObject((String)$RedisXID);
        Map v_AllDatas = v_Redis.getRows(this.redisDatabaseName.getValue(), $RTable, Heartbeat.class);
        if (Help.isNull((Map)v_AllDatas)) {
            return;
        }
        Date v_RedisNowTime = v_Redis.getNowTime();
        if (v_RedisNowTime == null) {
            return;
        }
        long v_MaxExpireTime = i_Day * 24 * 60 * 60 * 1000;
        for (Heartbeat v_Item : v_AllDatas.values()) {
            if (v_RedisNowTime.differ(v_Item.getUpdateTime()) <= v_MaxExpireTime) continue;
            this.delEdgeIP(v_Item.getEdgeIP());
        }
    }
}

