/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.openapi;

import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.engine.EngineFileType;
import cn.smallbun.screw.core.engine.EngineTemplateType;
import cn.smallbun.screw.core.execute.DocumentationExecute;
import cn.smallbun.screw.core.process.ProcessConfig;
import com.alibaba.druid.pool.DruidDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.hy.common.Help;
import org.hy.common.xml.XJava;

public class DBDocument {
    public static void makeDatabaseDoc(String i_DataSourceXID, String i_Version) {
        DBDocument.makeDatabaseDoc(i_DataSourceXID, i_Version, null);
    }

    public static void makeDatabaseDoc(String i_DataSourceXID, String i_Version, String i_TablePrefix) {
        String v_SaveDir = Help.getClassHomePath() + ".." + Help.getSysPathSeparator() + ".." + Help.getSysPathSeparator() + "doc";
        String v_SaveShortName = "OpenApi.\u6570\u636e\u5e93\u8bbe\u8ba1";
        DBDocument.makeDatabaseDoc(i_DataSourceXID, i_Version, i_TablePrefix, v_SaveDir, v_SaveShortName);
    }

    public static void makeDatabaseDoc(String i_DataSourceXID, String i_Version, String i_TablePrefix, String i_SaveDir, String i_SaveShortName) {
        DBDocument.makeDatabaseDoc(i_DataSourceXID, i_Version, i_TablePrefix, EngineFileType.HTML, i_SaveDir, i_SaveShortName);
        DBDocument.makeDatabaseDoc(i_DataSourceXID, i_Version, i_TablePrefix, EngineFileType.WORD, i_SaveDir, i_SaveShortName);
        DBDocument.makeDatabaseDoc(i_DataSourceXID, i_Version, i_TablePrefix, EngineFileType.MD, i_SaveDir, i_SaveShortName);
    }

    public static void makeDatabaseDoc(String i_DataSourceXID, String i_Version, String i_TablePrefix, EngineFileType i_SaveType, String i_SaveDir, String i_SaveShortName) {
        DruidDataSource v_DB = (DruidDataSource)XJava.getObject((String)i_DataSourceXID);
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(v_DB.getDriverClassName());
        hikariConfig.setJdbcUrl(v_DB.getUrl());
        hikariConfig.setUsername(v_DB.getUsername());
        hikariConfig.setPassword(v_DB.getPassword());
        hikariConfig.addDataSourceProperty("useInformationSchema", (Object)"true");
        hikariConfig.setMinimumIdle(1);
        hikariConfig.setMaximumPoolSize(5);
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        EngineConfig engineConfig = EngineConfig.builder().fileOutputDir(i_SaveDir).openOutputDir(true).fileType(i_SaveType).produceType(EngineTemplateType.freemarker).fileName(i_SaveShortName).build();
        ArrayList<String> ignoreTableName = new ArrayList<String>();
        ignoreTableName.add("test_user");
        ignoreTableName.add("test_group");
        ArrayList<String> ignorePrefix = new ArrayList<String>();
        ignorePrefix.add("TUpgrade");
        ArrayList<String> ignoreSuffix = new ArrayList<String>();
        ignoreSuffix.add("_test");
        ArrayList<String> v_TablePrefixs = new ArrayList<String>();
        if (!Help.isNull((String)i_TablePrefix)) {
            v_TablePrefixs.add(i_TablePrefix);
        }
        ProcessConfig processConfig = ProcessConfig.builder().designatedTableName(new ArrayList()).designatedTablePrefix(v_TablePrefixs).designatedTableSuffix(new ArrayList()).ignoreTableName(ignoreTableName).ignoreTablePrefix(ignorePrefix).ignoreTableSuffix(ignoreSuffix).build();
        Configuration config = Configuration.builder().version(i_Version).description("\u6570\u636e\u5e93\u8bbe\u8ba1").dataSource((DataSource)dataSource).engineConfig(engineConfig).produceConfig(processConfig).build();
        new DocumentationExecute(config).execute();
    }
}

