/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TimeGroupTotal;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.event.XRequestListener;
import org.hy.common.xml.log.Logger;
import org.hy.common.xml.plugins.AppInterfaces;
import org.hy.common.xml.plugins.AppMessage;
import org.hy.common.xml.plugins.XSQLFilter;
import org.hy.microservice.common.BaseResponse;
import org.hy.microservice.common.BaseViewMode;
import org.hy.microservice.common.LogHttpServletRequestWrapper;
import org.hy.microservice.common.LogHttpServletResponseWrapper;
import org.hy.microservice.common.ProjectStartBase;
import org.hy.microservice.common.ipSafe.IIPSafeConfigService;
import org.hy.microservice.common.ipSafe.IPSafeConfig;
import org.hy.microservice.common.operationLog.IOperationLogService;
import org.hy.microservice.common.operationLog.OperationLog;

@WebFilter(filterName="logFilter", urlPatterns={"/*"}, initParams={@WebInitParam(name="exclusions", value="*.js,*.gif,*.jpg,*.png,*.css,*.ico,*.swf"), @WebInitParam(name="cachesize", value="1000"), @WebInitParam(name="timeout", value="60")})
public class LogFilter
extends XSQLFilter
implements XRequestListener {
    private static final Logger $Logger = new Logger(LogFilter.class);
    private static final Map<String, TimeGroupTotal> $APITotalMinute = new HashMap<String, TimeGroupTotal>();
    private static final Map<String, TimeGroupTotal> $APITotalMinute10 = new HashMap<String, TimeGroupTotal>();
    public static String $CharacterEncoding = "UTF-8";
    private IIPSafeConfigService ipSafeConfigService = (IIPSafeConfigService)XJava.getObject((String)"IPSafeConfigService");
    private IOperationLogService operationLogService = (IOperationLogService)XJava.getObject((String)"OperationLogService");
    private long apiUseMaxCountMinute = Long.valueOf(XJava.getParam((String)"MS_Common_ApiUseMaxCountMinute").getValue());
    private long apiUseMaxCountMinute10 = Long.valueOf(XJava.getParam((String)"MS_Common_ApiUseMaxCountMinute10").getValue());
    private String systemCode = XJava.getParam((String)"MS_Common_ServiceName").getValue();

    public LogFilter() {
        AppInterfaces.setListener((XRequestListener)this);
    }

    private synchronized boolean allowUseAPIMinute(String i_APIUrl) {
        TimeGroupTotal v_APITimeTotal = $APITotalMinute.get(i_APIUrl);
        Date v_Now = Date.getNowTime();
        if (v_APITimeTotal == null) {
            v_APITimeTotal = new TimeGroupTotal(1);
            v_APITimeTotal.setMaxSize(60);
            $APITotalMinute.put(i_APIUrl, v_APITimeTotal);
        } else {
            Long v_TimeCount = v_APITimeTotal.get(v_Now);
            if (v_TimeCount != null && v_TimeCount > this.apiUseMaxCountMinute) {
                return false;
            }
        }
        v_APITimeTotal.put(v_Now);
        return true;
    }

    private synchronized boolean allowUseAPIMinute10(String i_APIUrl) {
        TimeGroupTotal v_APITimeTotal = $APITotalMinute10.get(i_APIUrl);
        Date v_Now = Date.getNowTime();
        if (v_APITimeTotal == null) {
            v_APITimeTotal = new TimeGroupTotal(15);
            v_APITimeTotal.setMaxSize(8);
            $APITotalMinute10.put(i_APIUrl, v_APITimeTotal);
        } else {
            Long v_TimeCount = v_APITimeTotal.get(v_Now);
            if (v_TimeCount != null && v_TimeCount > this.apiUseMaxCountMinute10) {
                return false;
            }
        }
        v_APITimeTotal.put(v_Now);
        return true;
    }

    private boolean haveWhiteList() {
        Map v_IPMap = (Map)this.ipSafeConfigService.queryAll().get((Object)"whitelist");
        return !Help.isNull((Map)v_IPMap);
    }

    private boolean isbackWhiteList(String i_IPType, OperationLog io_OLog) {
        Map v_IPMap = (Map)this.ipSafeConfigService.queryAll().get((Object)i_IPType);
        if (Help.isNull((Map)v_IPMap)) {
            return false;
        }
        ArrayList<Object> v_IPs = new ArrayList<Object>();
        String[] v_IPArr = io_OLog.getUserIP().split("\\.");
        v_IPs.add(io_OLog.getUserIP());
        if (v_IPArr.length >= 4) {
            v_IPs.add(v_IPArr[0] + "." + v_IPArr[1] + "." + v_IPArr[2] + ".");
            v_IPs.add(v_IPArr[0] + "." + v_IPArr[1] + ".");
            v_IPs.add(v_IPArr[0] + ".");
        }
        Object v_FindKey = "";
        IPSafeConfig v_IPSafeConfig = null;
        for (String string : v_IPs) {
            v_FindKey = string + "@" + io_OLog.getModuleCode() + "@" + io_OLog.getUrl();
            v_IPSafeConfig = (IPSafeConfig)((Object)v_IPMap.get(v_FindKey));
            if (v_IPSafeConfig != null) {
                this.ipSafeConfigService.putIPSafeHit(io_OLog.getIpSafeKey(), i_IPType);
                return true;
            }
            v_FindKey = string + "@" + io_OLog.getModuleCode();
            v_IPSafeConfig = (IPSafeConfig)((Object)v_IPMap.get(v_FindKey));
            if (v_IPSafeConfig != null) {
                this.ipSafeConfigService.putIPSafeHit(io_OLog.getIpSafeKey(), i_IPType);
                return true;
            }
            v_FindKey = string;
            v_IPSafeConfig = (IPSafeConfig)((Object)v_IPMap.get(v_FindKey));
            if (v_IPSafeConfig == null) continue;
            this.ipSafeConfigService.putIPSafeHit(io_OLog.getIpSafeKey(), i_IPType);
            return true;
        }
        return false;
    }

    private OperationLog backWhiteCheck(OperationLog io_OLog) {
        String v_IPSafeHit = this.ipSafeConfigService.getIPSafeHit(io_OLog.getIpSafeKey());
        if ("blacklist".equals(v_IPSafeHit) || this.isbackWhiteList("blacklist", io_OLog)) {
            io_OLog.setAttackType("blacklist");
            io_OLog.setUrlResponse("{\"code\": \"-891\", \"message\": \"blacklist\"}");
            io_OLog.setResultCode("-891");
            io_OLog.setResponseTime(Date.getNowTime().getTime());
            io_OLog.setTimeLen(io_OLog.getResponseTime() - io_OLog.getRequestTime());
        } else if (this.haveWhiteList()) {
            if ("whitelist".equals(v_IPSafeHit) || this.isbackWhiteList("whitelist", io_OLog)) {
                io_OLog.setAttackType("whitelist");
            } else {
                io_OLog.setAttackType("Not on the whitelist");
                io_OLog.setUrlResponse("{\"code\": \"-892\", \"message\": \"Not on the whitelist\"}");
                io_OLog.setResultCode("-892");
                io_OLog.setResponseTime(Date.getNowTime().getTime());
                io_OLog.setTimeLen(io_OLog.getResponseTime() - io_OLog.getRequestTime());
            }
        }
        return io_OLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest i_ServletRequest, ServletResponse i_ServletResponse, FilterChain i_FilterChain) throws IOException, ServletException {
        String v_Url = ((HttpServletRequest)i_ServletRequest).getServletPath();
        String[] v_Urls = v_Url.split("/");
        if (StringHelp.isContains((String)v_Url, (String[])new String[]{"analyse", "."}) || v_Urls.length < 3) {
            i_ServletResponse.setCharacterEncoding($CharacterEncoding);
            i_FilterChain.doFilter(i_ServletRequest, i_ServletResponse);
            return;
        }
        if (ProjectStartBase.$RequestMappingMethods.getRow((Object)v_Urls[1], v_Url) == null) {
            i_FilterChain.doFilter(i_ServletRequest, i_ServletResponse);
            return;
        }
        LogHttpServletRequestWrapper v_Request = new LogHttpServletRequestWrapper((HttpServletRequest)i_ServletRequest);
        OperationLog v_OLog = new OperationLog();
        try {
            if (!Help.isNull((String)v_Request.getBodyString())) {
                XJSON v_XJson = new XJSON();
                BaseViewMode v_BMode = (BaseViewMode)((Object)v_XJson.toJava(v_Request.getBodyString(), BaseViewMode.class));
                v_OLog.setUserID(Help.NVL((String)v_BMode.getCreateUserID(), (String)v_BMode.getUserID()));
            } else {
                v_OLog.setUserID("");
            }
            v_OLog.setCreateTime(new Date());
            v_OLog.setId(StringHelp.getUUID());
            v_OLog.setUrl(v_Url);
            v_OLog.setUrlRequest(v_Request.getQueryString());
            v_OLog.setUrlRequestBody(v_Request.getBodyString());
            v_OLog.setUserIP(this.getIpAddress((HttpServletRequest)v_Request));
            v_OLog.setSystemCode(this.systemCode);
            v_OLog.setModuleCode(v_Urls[1]);
            this.backWhiteCheck(v_OLog);
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        ServletOutputStream v_Output = null;
        LogHttpServletResponseWrapper v_Response = new LogHttpServletResponseWrapper((HttpServletResponse)i_ServletResponse);
        if (!Help.isNull((String)v_OLog.getUrlResponse())) {
            i_ServletResponse.setCharacterEncoding($CharacterEncoding);
            i_ServletResponse.setContentType("application/json");
            v_Output = i_ServletResponse.getOutputStream();
            v_Output.write(v_OLog.getUrlResponse().getBytes());
            this.operationLogService.insert(v_OLog);
            return;
        }
        if (!this.allowUseAPIMinute(v_OLog.getUrl())) {
            v_OLog.setUrlResponse("\u8bbf\u95ee\u91cf\u8fbe\u5230\u4e0a\u9650");
            v_OLog.setAttackType("ApiUseMaxCountMinute");
            i_ServletResponse.setCharacterEncoding($CharacterEncoding);
            i_ServletResponse.setContentType("application/json");
            v_Output = i_ServletResponse.getOutputStream();
            v_Output.write(v_OLog.getUrlResponse().getBytes());
            this.operationLogService.insert(v_OLog);
            return;
        }
        if (!this.allowUseAPIMinute10(v_OLog.getUrl())) {
            v_OLog.setUrlResponse("\u8bbf\u95ee\u91cf\u8fbe\u523010\u5206\u949f\u4e0a\u9650");
            v_OLog.setAttackType("ApiUseMaxCountMinute10");
            i_ServletResponse.setCharacterEncoding($CharacterEncoding);
            i_ServletResponse.setContentType("application/json");
            v_Output = i_ServletResponse.getOutputStream();
            v_Output.write(v_OLog.getUrlResponse().getBytes());
            this.operationLogService.insert(v_OLog);
            return;
        }
        this.operationLogService.insert(v_OLog);
        super.doFilter((ServletRequest)v_Request, (ServletResponse)v_Response, i_FilterChain);
        try {
            byte[] v_ResponseBody = v_Response.getResponseData();
            v_OLog.setUrlResponse(new String(v_ResponseBody, $CharacterEncoding));
            v_OLog.setResponseTime(Date.getNowTime().getTime());
            v_OLog.setTimeLen(v_OLog.getResponseTime() - v_OLog.getRequestTime());
            if (!Help.isNull((String)v_OLog.getUrlResponse())) {
                try {
                    XJSON v_XJson = new XJSON();
                    BaseResponse v_BResp = (BaseResponse)((Object)v_XJson.toJava(v_OLog.getUrlResponse(), BaseResponse.class));
                    v_OLog.setResultCode(v_BResp.getCode());
                }
                catch (Exception exce) {
                    v_OLog.setResultCode("200");
                }
                if (v_OLog.getUrlResponse().length() >= 4000) {
                    v_OLog.setUrlResponse(v_OLog.getUrlResponse().substring(0, 3999));
                }
            }
            this.operationLogService.update(v_OLog);
            v_Output = i_ServletResponse.getOutputStream();
            v_Output.write(v_ResponseBody);
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        finally {
            if (v_Output != null) {
                v_Output.flush();
                v_Output.close();
            }
            v_Output = null;
        }
    }

    public Return<Object> before(HttpServletRequest i_Request, HttpServletResponse i_Response, AppMessage<?> io_RequestData, String i_Message) {
        Return v_Ret = new Return(true);
        OperationLog v_OLog = new OperationLog();
        String v_UserID = Help.NVL((String)i_Request.getParameter("userID"), (String)i_Request.getParameter("createUserID"));
        v_OLog.setCreateTime(new Date());
        v_OLog.setId(StringHelp.getUUID());
        v_OLog.setUrl("/app/" + io_RequestData.getSid());
        v_OLog.setUrlRequest(i_Request.getQueryString());
        v_OLog.setUrlRequestBody(i_Message);
        v_OLog.setUserIP(this.getIpAddress(i_Request));
        v_OLog.setSystemCode(this.systemCode);
        v_OLog.setModuleCode("/app");
        v_OLog.setUserID(Help.NVL((String)v_UserID, (String)Help.NVL((String)io_RequestData.getSession())));
        this.backWhiteCheck(v_OLog);
        if (!Help.isNull((String)v_OLog.getUrlResponse())) {
            v_Ret.set(false).setParamStr(v_OLog.getUrlResponse());
        } else if (!this.allowUseAPIMinute(v_OLog.getUrl())) {
            v_OLog.setUrlResponse("\u8bbf\u95ee\u91cf\u8fbe\u5230\u4e0a\u9650");
            v_OLog.setAttackType("ApiUseMaxCountMinute");
            v_Ret.set(false).setParamStr(v_OLog.getUrlResponse());
        } else if (!this.allowUseAPIMinute10(v_OLog.getUrl())) {
            v_OLog.setUrlResponse("\u8bbf\u95ee\u91cf\u8fbe\u523010\u5206\u949f\u4e0a\u9650");
            v_OLog.setAttackType("ApiUseMaxCountMinute10");
            v_Ret.set(false).setParamStr(v_OLog.getUrlResponse());
        }
        this.operationLogService.insert(v_OLog);
        return v_Ret.setParamObj((Object)v_OLog);
    }

    public void succeed(AppMessage<?> i_RequestData, AppMessage<?> i_ResponseData, Object i_Other) {
        OperationLog v_OLog = (OperationLog)((Object)i_Other);
        if (i_ResponseData != null) {
            try {
                v_OLog.setUrlResponse(i_ResponseData.toString());
            }
            catch (Exception exce) {
                v_OLog.setUrlResponse(exce.toString());
                $Logger.warn((Throwable)exce);
            }
        } else {
            v_OLog.setUrlResponse("");
        }
        v_OLog.setResponseTime(Date.getNowTime().getTime());
        v_OLog.setTimeLen(v_OLog.getResponseTime() - v_OLog.getRequestTime());
        v_OLog.setResultCode("200");
        this.operationLogService.update(v_OLog);
    }

    public void fail(AppMessage<?> i_RequestData, Exception i_Exception, Object i_Other) {
        OperationLog v_OLog = (OperationLog)((Object)i_Other);
        if (i_Exception != null) {
            v_OLog.setUrlResponse(i_Exception.toString());
        } else {
            v_OLog.setUrlResponse("");
        }
        v_OLog.setResponseTime(Date.getNowTime().getTime());
        v_OLog.setTimeLen(v_OLog.getResponseTime() - v_OLog.getRequestTime());
        v_OLog.setResultCode(i_RequestData.getRc());
        this.operationLogService.update(v_OLog);
    }

    private String getIpAddress(HttpServletRequest i_Request) {
        String ip = i_Request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknow".equalsIgnoreCase(ip)) {
            ip = i_Request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = i_Request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = i_Request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }
}

