/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.user;

import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.app.Param;
import org.hy.common.license.AppKey;
import org.hy.common.license.Signaturer;
import org.hy.common.xml.XHttp;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.annotation.Xjava;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.user.GetLoginUserRequest;
import org.hy.microservice.common.user.TokenInfo;
import org.hy.microservice.common.user.TokenResponse;
import org.hy.microservice.common.user.UserSSO;

@Xjava
public class UserService {
    private static final Logger $Logger = Logger.getLogger(UserService.class);
    public static final String $SessionID = "$XSSO$";
    public static final String $USID = "USID";
    public static final String $SID = "SID";
    protected static TokenInfo $Token = null;
    protected static long $TokenTime = 0L;
    protected static int $TokenExpire = 0;
    @Xjava(ref="XHTTP_MS_Common_GetLoginUser")
    protected XHttp xhGetLoginUser;
    @Xjava(ref="XHTTP_MS_Common_GetAccessToken")
    protected XHttp xhGetAccessToken;
    @Xjava(ref="XHTTP_MS_Common_SetLoginUser")
    protected XHttp xhSetLoginUser;
    @Xjava(ref="MS_Common_SessionTimeOut")
    protected Param sessionTimeOut;

    public long getMaxExpireTimeLen() {
        return Long.parseLong(this.sessionTimeOut.getValue());
    }

    public String sessionGetID(HttpSession i_Session) {
        return $SID + i_Session.getId();
    }

    public UserSSO sessionGetUser(HttpSession i_Session) {
        return (UserSSO)((Object)i_Session.getAttribute($SessionID));
    }

    public void sessionRemove(HttpSession i_Session) {
        i_Session.removeAttribute($SessionID);
        i_Session.invalidate();
    }

    public UserSSO getUser(String i_Token) {
        HashMap<String, String> v_ReqParams = new HashMap<String, String>();
        v_ReqParams.put("token", i_Token);
        try {
            GetLoginUserRequest v_Data;
            XJSON v_XJson = new XJSON();
            v_XJson.setReturnNVL(false);
            Return v_Ret = this.xhGetLoginUser.request(v_ReqParams);
            if (v_Ret != null && v_Ret.booleanValue() && !Help.isNull((String)v_Ret.getParamStr()) && (v_Data = (GetLoginUserRequest)((Object)v_XJson.toJava(v_Ret.getParamStr(), GetLoginUserRequest.class))) != null && "200".equals(v_Data.getCode()) && v_Data.getData() != null) {
                return v_Data.getData().getData();
            }
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        return null;
    }

    public synchronized String getAccessToken(AppKey i_AppKey, UserSSO i_UserSSO) {
        long v_Timestamp = Date.getNowTime().getTime();
        if ($TokenTime + (long)($TokenExpire * 1000) > v_Timestamp) {
            return $Token.getAccessToken();
        }
        TokenInfo v_Token = this.getCode(i_AppKey);
        if (v_Token != null) {
            $TokenTime = Date.getNowTime().getTime();
            $TokenExpire = v_Token.getExpire() - 10;
            $Token = v_Token;
            String v_Code = v_Token.getCode();
            v_Token.setCode(null);
            this.loginUser(v_Code, i_AppKey, i_UserSSO);
            return v_Token.getAccessToken();
        }
        return null;
    }

    public TokenInfo getCode(AppKey i_AppKey) {
        $Logger.debug("\u83b7\u53d6Token Starting...");
        try {
            XJSON v_XJson;
            TokenResponse v_Data;
            long v_Timestamp = Date.getNowTime().getTime();
            Signaturer v_Sign = new Signaturer(i_AppKey.getPrivateKey());
            String v_Signature = v_Sign.sign("appKey" + i_AppKey.getAppKey() + "timestamp" + v_Timestamp);
            HashMap<String, Object> v_ReqParams = new HashMap<String, Object>();
            v_ReqParams.put("appKey", i_AppKey.getAppKey());
            v_ReqParams.put("timestamp", v_Timestamp);
            v_ReqParams.put("signature", URLEncoder.encode(v_Signature, "UTF-8"));
            Return v_Ret = this.xhGetAccessToken.request(v_ReqParams);
            if (v_Ret != null && v_Ret.booleanValue() && !Help.isNull((String)v_Ret.getParamStr()) && (v_Data = (TokenResponse)((Object)(v_XJson = new XJSON()).toJava(v_Ret.getParamStr(), TokenResponse.class))) != null) {
                if ("200".equals(v_Data.getCode()) && v_Data.getData() != null && v_Data.getData().getData() != null) {
                    TokenInfo v_Token = v_Data.getData().getData();
                    $Logger.info("\u83b7\u53d6Token\uff1a" + v_Data.getCode() + " : " + v_Token.getAccessToken() + " ,\u8fc7\u671f\u65f6\u957f\uff1a" + v_Token.getExpire());
                    return v_Token;
                }
                $Logger.error("\u83b7\u53d6Token\u5f02\u5e38\uff1a" + v_Data.getCode() + " - " + v_Data.getMessage());
            }
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        return null;
    }

    public TokenInfo loginUser(String i_Code, AppKey i_AppKey, UserSSO i_UserSSO) {
        i_UserSSO.setAppKey(i_AppKey.getAppKey());
        HashMap<String, String> v_ReqParams = new HashMap<String, String>();
        v_ReqParams.put("code", i_Code);
        try {
            TokenResponse v_Data;
            XJSON v_XJson = new XJSON();
            v_XJson.setReturnNVL(false);
            Return v_Ret = this.xhSetLoginUser.request(v_ReqParams, v_XJson.toJson((Object)i_UserSSO).toJSONString());
            if (v_Ret != null && v_Ret.booleanValue() && !Help.isNull((String)v_Ret.getParamStr()) && (v_Data = (TokenResponse)((Object)v_XJson.toJava(v_Ret.getParamStr(), TokenResponse.class))) != null) {
                if ("200".equals(v_Data.getCode())) {
                    return v_Data.getData().getData();
                }
                return null;
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return null;
    }
}

