/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.rocketMQ;

import java.util.Map;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.hy.common.xml.XJava;
import org.hy.common.xml.annotation.Xjava;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.rocketMQ.MessageEntity;
import org.hy.microservice.common.rocketMQ.RedisMessageService;

@Xjava
public class MessageRetryService {
    private Logger logger = new Logger(MessageRetryService.class);
    @Xjava
    private RedisMessageService redisMessageService;

    public void retrySendFailedMessages() {
        this.logger.debug("\u5f00\u59cb\u91cd\u8bd5\u53d1\u9001\u5931\u8d25\u7684\u6d88\u606f...");
        Map failedMessageIds = this.redisMessageService.getSendFailedMessageIds();
        if (failedMessageIds == null || failedMessageIds.isEmpty()) {
            this.logger.debug("\u6ca1\u6709\u9700\u8981\u91cd\u8bd5\u7684\u53d1\u9001\u5931\u8d25\u6d88\u606f");
            return;
        }
        for (Map.Entry entry : failedMessageIds.entrySet()) {
            String messageId = (String)entry.getKey();
            MessageEntity message = (MessageEntity)entry.getValue();
            if (message == null || !message.canRetry()) {
                if (message == null || message.canRetry()) continue;
                this.logger.debug("\u6d88\u606f\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u4e0d\u518d\u91cd\u8bd5: " + messageId);
                continue;
            }
            try {
                String destination = message.getTopic() + ":" + message.getTag();
                RocketMQTemplate rocketMQTemplate = (RocketMQTemplate)XJava.getObject((String)"MS_MQ_TEMPLATE");
                SendResult result = rocketMQTemplate.syncSend(destination, (Object)message.getContent());
                if (result != null) {
                    this.redisMessageService.deleteSendFailedMessage(messageId);
                    this.logger.debug("\u6d88\u606f\u53d1\u9001\u91cd\u8bd5\u6210\u529f: " + messageId + ", \u91cd\u8bd5\u6b21\u6570: " + message.getRetryCount());
                    continue;
                }
                message.incrementRetryCount();
                this.redisMessageService.updateSendFailedMessage(message);
                this.logger.debug("\u6d88\u606f\u53d1\u9001\u91cd\u8bd5\u5931\u8d25: " + messageId + ", \u91cd\u8bd5\u6b21\u6570: " + message.getRetryCount());
            }
            catch (Exception e) {
                message.incrementRetryCount();
                this.redisMessageService.updateSendFailedMessage(message);
                this.logger.error("\u6d88\u606f\u53d1\u9001\u91cd\u8bd5\u5f02\u5e38: " + messageId + ", \u539f\u56e0: " + e.getMessage());
            }
        }
    }

    public void retryConsumeFailedMessages() {
        this.logger.debug("\u5f00\u59cb\u91cd\u8bd5\u8bd5\u6d88\u8d39\u5931\u8d25\u7684\u6d88\u606f...");
        Map failedMessageIds = this.redisMessageService.getConsumeFailedMessageIds();
        if (failedMessageIds == null || failedMessageIds.isEmpty()) {
            this.logger.debug("\u6ca1\u6709\u9700\u8981\u91cd\u8bd5\u7684\u6d88\u8d39\u5931\u8d25\u6d88\u606f");
            return;
        }
        for (Map.Entry entry : failedMessageIds.entrySet()) {
            String messageId = (String)entry.getKey();
            MessageEntity message = (MessageEntity)entry.getValue();
            if (message == null || !message.canRetry()) {
                if (message == null || message.canRetry()) continue;
                this.logger.debug("\u6d88\u606f\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u4e0d\u518d\u91cd\u8bd5: " + messageId);
                continue;
            }
            try {
                this.processMessage(message.getContent());
                this.redisMessageService.deleteConsumeFailedMessage(messageId);
                this.logger.debug("\u6d88\u606f\u6d88\u8d39\u91cd\u8bd5\u6210\u529f: " + messageId + ", \u91cd\u8bd5\u6b21\u6570: " + message.getRetryCount());
            }
            catch (Exception e) {
                message.incrementRetryCount();
                this.redisMessageService.updateConsumeFailedMessage(message);
                this.logger.error("\u6d88\u606f\u6d88\u8d39\u91cd\u8bd5\u5931\u8d25: " + messageId + ", \u539f\u56e0: " + e.getMessage());
            }
        }
    }

    private void processMessage(String message) throws Exception {
        this.logger.debug("\u91cd\u65b0\u5904\u7406\u6d88\u606f: " + message);
    }
}

