/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.webSocket;

import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.hy.common.Help;
import org.hy.common.callflow.event.websocket.WSPullData;
import org.hy.common.callflow.event.websocket.WSPullExecuter;
import org.hy.common.xml.log.Logger;

@ClientEndpoint
public class WebSocketPullExecuter
implements WSPullExecuter {
    private static Logger $Logger = Logger.getLogger(WebSocketPullExecuter.class);
    private WSPullData data;

    public boolean init(WSPullData i_WSPullData) {
        this.data = i_WSPullData;
        if (this.data == null) {
            $Logger.error("\u8fde\u63a5\u8fdc\u7a0bWebSocket\u914d\u7f6e\u4e3a\u7a7a");
            return false;
        }
        if (Help.isNull((String)this.data.getWsURL())) {
            $Logger.error("\u8fde\u63a5\u8fdc\u7a0bWebSocket\u5730\u5740\u4e3a\u7a7a");
            return false;
        }
        try {
            WebSocketContainer v_Container = ContainerProvider.getWebSocketContainer();
            URI v_URI = URI.create(this.data.getWsURL());
            v_Container.connectToServer((Object)this, v_URI);
            return true;
        }
        catch (Exception error) {
            $Logger.error("\u8fde\u63a5\u8fdc\u7a0bWebSocket[" + this.data.getWsURL() + "]\u670d\u52a1\u5931\u8d25: " + error.getMessage(), (Throwable)error);
            return true;
        }
    }

    @OnOpen
    public void onOpen(Session i_Session) {
        $Logger.info("\u6210\u529f\u8fde\u63a5\u8fdc\u7a0bWebSocket[" + this.data.getWsURL() + "]");
    }

    @OnMessage
    public void onMessage(String i_Message) {
        this.onMessage(this.data, i_Message);
    }

    @OnClose
    public void onClose(Session i_Session, CloseReason i_CloseReason) {
        $Logger.info("\u5173\u95ed\u8fdc\u7a0bWebSocket[" + this.data.getWsURL() + "]\uff0c\u539f\u56e0\uff1a" + i_CloseReason.getReasonPhrase());
    }

    @OnError
    public void onError(Session i_Session, Throwable i_Throwable) {
        $Logger.error("\u8fdc\u7a0bWebSocket\u901a\u4fe1\u9519\u8bef[" + this.data.getWsURL() + "]: " + i_Throwable.getMessage(), i_Throwable);
    }
}

