/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.webSocket;

import org.hy.common.Help;

public class WebSocketConfig {
    private String protocol;
    private String host;
    private String url;
    private String serviceType;
    private String userID;

    public String getProtocol() {
        return this.protocol;
    }

    public WebSocketConfig setProtocol(String i_Protocol) {
        this.protocol = i_Protocol;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public WebSocketConfig setHost(String i_Host) {
        this.host = i_Host;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public WebSocketConfig setUrl(String i_Url) {
        this.url = i_Url;
        return this;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public WebSocketConfig setServiceType(String i_ServiceType) {
        this.serviceType = i_ServiceType;
        return this;
    }

    public String getUserID() {
        return this.userID;
    }

    public WebSocketConfig setUserID(String i_UserID) {
        this.userID = i_UserID;
        return this;
    }

    public String toWebSocketURL() {
        StringBuilder v_Buffer = new StringBuilder();
        v_Buffer.append(Help.NVL((String)this.getProtocol(), (String)"ws").toLowerCase());
        v_Buffer.append("://");
        v_Buffer.append(Help.NVL((String)this.getHost(), (String)"127.0.0.1"));
        if (Help.isNull((String)this.getUrl())) {
            v_Buffer.append("/msCommon/report");
        } else if (this.getUrl().startsWith("/")) {
            v_Buffer.append(this.getUrl());
        } else {
            v_Buffer.append("/").append(this.getUrl());
        }
        if (!Help.NVL((String)this.getUrl(), (String)"").endsWith("/")) {
            v_Buffer.append("/");
        }
        v_Buffer.append(Help.NVL((String)this.getServiceType(), (String)"Default"));
        v_Buffer.append("/");
        v_Buffer.append(Help.NVL((String)this.getUserID(), (String)"ms"));
        return v_Buffer.toString();
    }

    public String toString() {
        return this.toWebSocketURL();
    }
}

