/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.rocketMQ;

import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.hy.common.StringHelp;
import org.hy.common.xml.XJava;
import org.hy.common.xml.annotation.Xjava;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.rocketMQ.MessageEntity;
import org.hy.microservice.common.rocketMQ.RedisMessageService;

@Xjava
public class RocketMQProducer {
    private Logger logger = new Logger(RocketMQProducer.class);
    @Xjava
    private RedisMessageService redisMessageService;

    public SendResult sendMessage(String topic, String tag, String content) {
        String messageId = StringHelp.getUUID9n();
        MessageEntity message = new MessageEntity(messageId, topic, tag, content);
        String destination = topic + ":" + tag;
        try {
            RocketMQTemplate rocketMQTemplate = (RocketMQTemplate)XJava.getObject((String)"MS_MQ_TEMPLATE");
            SendResult result = rocketMQTemplate.syncSend(destination, (Object)content);
            if (result == null || result.getSendStatus() == null) {
                throw new Exception("\u6d88\u606f\u53d1\u9001\u72b6\u6001\u672a\u77e5");
            }
            this.redisMessageService.saveSendFailedMessage(message);
            this.logger.debug("\u6d88\u606f\u53d1\u9001\u6210\u529f: " + messageId);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5b58\u5165Redis: " + messageId + ", \u539f\u56e0: " + e.getMessage());
            this.redisMessageService.saveSendFailedMessage(message);
            return null;
        }
    }

    public void sendAsyncMessage(String topic, String tag, String content) {
        final String messageId = StringHelp.getUUID9n();
        final MessageEntity message = new MessageEntity(messageId, topic, tag, content);
        String destination = topic + ":" + tag;
        RocketMQTemplate rocketMQTemplate = (RocketMQTemplate)XJava.getObject((String)"MS_MQ_TEMPLATE");
        try {
            rocketMQTemplate.asyncSend(destination, (Object)content, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    RocketMQProducer.this.logger.debug("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u6210\u529f: " + messageId);
                }

                public void onException(Throwable e) {
                    RocketMQProducer.this.logger.error("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5b58\u5165Redis: " + messageId + ", \u539f\u56e0: " + e.getMessage());
                    RocketMQProducer.this.redisMessageService.saveSendFailedMessage(message);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u5b58\u5165Redis: " + messageId + ", \u539f\u56e0: " + e.getMessage());
            this.redisMessageService.saveSendFailedMessage(message);
        }
    }
}

