/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.rocketMQ;

import java.util.Map;
import org.hy.common.xml.XJava;
import org.hy.common.xml.annotation.Xjava;
import org.hy.microservice.common.cache.CacheFactory;
import org.hy.microservice.common.cache.ICache;
import org.hy.microservice.common.rocketMQ.MessageEntity;

@Xjava
public class RedisMessageService {
    private static final String SEND_FAIL_KEY = "rocketmq:send:fail:";
    private static final String CONSUME_FAIL_KEY = "rocketmq:consume:fail:";
    private static final String $RTable = "TRocketProducerConfig";
    private static final String $RDataSource = "rocketMQ_DB";
    private ICache<MessageEntity> redisCache;

    public RedisMessageService() {
        boolean v_UseRemote = "\u542f\u7528".equals(XJava.getParam((String)"MS_Common_IsHeartbeat").getValue());
        this.redisCache = CacheFactory.newInstanceOf(v_UseRemote, MessageEntity.class);
    }

    public void saveSendFailedMessage(MessageEntity message) {
        String key = SEND_FAIL_KEY + message.getId();
        this.redisCache.save($RDataSource, $RTable, key, message);
    }

    public void saveConsumeFailedMessage(MessageEntity message) {
        String key = CONSUME_FAIL_KEY + message.getId();
        this.redisCache.save($RDataSource, $RTable, key, message);
    }

    public Map<String, MessageEntity> getSendFailedMessageIds() {
        return this.redisCache.getRowsMap($RDataSource, $RTable);
    }

    public Map<String, MessageEntity> getSendFailedMessageIds1() {
        return this.redisCache.getRowsMap($RDataSource, $RTable);
    }

    public Map<String, MessageEntity> getConsumeFailedMessageIds() {
        return this.redisCache.getRowsMap($RDataSource, $RTable);
    }

    public MessageEntity getSendFailedMessage(String id) {
        return this.redisCache.get($RDataSource, $RTable, id);
    }

    public MessageEntity getConsumeFailedMessage(String id) {
        return this.redisCache.get($RDataSource, $RTable, id);
    }

    public void deleteSendFailedMessage(String id) {
        this.redisCache.del($RDataSource, $RTable, id);
    }

    public void deleteConsumeFailedMessage(String id) {
        this.redisCache.del($RDataSource, $RTable, id);
    }

    public void updateSendFailedMessage(MessageEntity message) {
        this.saveSendFailedMessage(message);
    }

    public void updateConsumeFailedMessage(MessageEntity message) {
        this.saveConsumeFailedMessage(message);
    }
}

