/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class LogHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private ServletOutputStream out = new WapperedOutputStream(this.buffer);
    private PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, Charset.forName("UTF-8")));

    public LogHttpServletResponseWrapper(HttpServletResponse i_Response) throws IOException {
        super(i_Response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void reset() {
        this.buffer.reset();
    }

    public byte[] getResponseData() throws IOException {
        this.flushBuffer();
        return this.buffer.toByteArray();
    }

    private class WapperedOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bos = null;

        public WapperedOutputStream(ByteArrayOutputStream stream) throws IOException {
            this.bos = stream;
        }

        public void write(int b) throws IOException {
            this.bos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.bos.write(b, 0, b.length);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener listener) {
        }
    }
}

