/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.mybatis;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.mybatis.DynamicDataSource;
import org.hy.microservice.common.mybatis.SourceData;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DynamicDataSourceAspect {
    private static final Logger $Logger = new Logger(DynamicDataSourceAspect.class);

    @Pointcut(value="@annotation(org.hy.microservice.common.mybatis.SourceData)")
    public void dataSourcePointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="dataSourcePointCut()")
    public Object around(ProceedingJoinPoint i_Point) throws Throwable {
        MethodSignature v_Signature = (MethodSignature)i_Point.getSignature();
        Method v_Method = v_Signature.getMethod();
        SourceData v_SourceData = v_Method.getAnnotation(SourceData.class);
        if (v_SourceData == null) {
            $Logger.debug("\u9ed8\u8ba4\u6570\u636e\u6e90\uff1aDSG_MS_Common");
            DynamicDataSource.setDataSource((String)"DSG_MS_Common");
        } else if (DynamicDataSource.exists((String)v_SourceData.value())) {
            $Logger.debug("\u5207\u6362\u6570\u636e\u6e90\uff1a" + v_SourceData.value());
            DynamicDataSource.setDataSource((String)v_SourceData.value());
        } else {
            String v_Error = "\u65e0\u6548\u6570\u636e\u6e90\uff1a" + v_SourceData.value() + " of " + v_Method.toString();
            $Logger.error(v_Error);
            throw new RuntimeException(v_Error);
        }
        try {
            Object object = i_Point.proceed();
            return object;
        }
        finally {
            DynamicDataSource.clearDataSource();
        }
    }
}

