/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;
import org.hy.common.xml.plugins.XSQLFilter;
import org.hy.microservice.common.BaseResponse;
import org.hy.microservice.common.BaseViewMode;
import org.hy.microservice.common.LogHttpServletRequestWrapper;
import org.hy.microservice.common.LogHttpServletResponseWrapper;
import org.hy.microservice.common.ipSafe.IIPSafeConfigService;
import org.hy.microservice.common.ipSafe.IPSafeConfig;
import org.hy.microservice.common.operationLog.IOperationLogDAO;
import org.hy.microservice.common.operationLog.OperationLog;

@WebFilter(filterName="logFilter", urlPatterns={"/*"}, initParams={@WebInitParam(name="exclusions", value="*.js,*.gif,*.jpg,*.png,*.css,*.ico,*.swf"), @WebInitParam(name="cachesize", value="1000"), @WebInitParam(name="timeout", value="60")})
public class LogFilter
extends XSQLFilter {
    private static final Logger $Logger = new Logger(LogFilter.class);

    private boolean haveWhiteList() {
        IIPSafeConfigService v_IPSafeConfigService = (IIPSafeConfigService)XJava.getObject((String)"IPSafeConfigService");
        Map v_IPMap = (Map)v_IPSafeConfigService.queryAll().get((Object)"whitelist");
        return !Help.isNull((Map)v_IPMap);
    }

    private boolean isbackWhiteList(String i_IPType, String i_IP) {
        IIPSafeConfigService v_IPSafeConfigService = (IIPSafeConfigService)XJava.getObject((String)"IPSafeConfigService");
        Map v_IPMap = (Map)v_IPSafeConfigService.queryAll().get((Object)i_IPType);
        if (Help.isNull((Map)v_IPMap)) {
            return false;
        }
        IPSafeConfig v_IPSafeConfig = (IPSafeConfig)v_IPMap.get(i_IP);
        if (v_IPSafeConfig != null) {
            return true;
        }
        String[] v_IPArr = i_IP.split("\\.");
        if (v_IPArr.length >= 4) {
            String v_IP = v_IPArr[0] + "." + v_IPArr[1] + "." + v_IPArr[2] + ".";
            v_IPSafeConfig = (IPSafeConfig)v_IPMap.get(v_IP);
            if (v_IPSafeConfig != null) {
                return true;
            }
            v_IP = v_IPArr[0] + "." + v_IPArr[1] + ".";
            v_IPSafeConfig = (IPSafeConfig)v_IPMap.get(v_IP);
            if (v_IPSafeConfig != null) {
                return true;
            }
            v_IP = v_IPArr[0] + ".";
            v_IPSafeConfig = (IPSafeConfig)v_IPMap.get(v_IP);
            if (v_IPSafeConfig != null) {
                return true;
            }
        }
        return false;
    }

    private OperationLog backWhiteCheck(OperationLog io_OLog) {
        if (this.isbackWhiteList("blacklist", io_OLog.getUserIP())) {
            io_OLog.setAttackType("blacklist");
            io_OLog.setUrlResponse("{\"code\": \"-891\", \"message\": \"blacklist\"}");
            io_OLog.setResultCode("-891");
            io_OLog.setResponseTime(Long.valueOf(Date.getNowTime().getTime()));
            io_OLog.setTimeLen(Long.valueOf(io_OLog.getResponseTime() - io_OLog.getRequestTime()));
        } else if (this.haveWhiteList()) {
            if (this.isbackWhiteList("whitelist", io_OLog.getUserIP())) {
                io_OLog.setAttackType("whitelist");
            } else {
                io_OLog.setAttackType("not whitelist");
                io_OLog.setUrlResponse("{\"code\": \"-892\", \"message\": \"not whitelist\"}");
                io_OLog.setResultCode("-892");
                io_OLog.setResponseTime(Long.valueOf(Date.getNowTime().getTime()));
                io_OLog.setTimeLen(Long.valueOf(io_OLog.getResponseTime() - io_OLog.getRequestTime()));
            }
        }
        return io_OLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest i_ServletRequest, ServletResponse i_ServletResponse, FilterChain i_FilterChain) throws IOException, ServletException {
        String v_Url = ((HttpServletRequest)i_ServletRequest).getServletPath();
        String[] v_Urls = v_Url.split("/");
        if (StringHelp.isContains((String)v_Url, (String[])new String[]{"analyse", "."}) || v_Urls.length < 3) {
            i_FilterChain.doFilter(i_ServletRequest, i_ServletResponse);
            return;
        }
        LogHttpServletRequestWrapper v_Request = new LogHttpServletRequestWrapper((HttpServletRequest)i_ServletRequest);
        OperationLog v_OLog = new OperationLog();
        IOperationLogDAO v_OLogDAO = (IOperationLogDAO)XJava.getObject((String)"OperationLogDAO");
        try {
            if (!Help.isNull((String)v_Request.getBodyString())) {
                XJSON v_XJson = new XJSON();
                BaseViewMode v_BMode = (BaseViewMode)v_XJson.toJava(v_Request.getBodyString(), BaseViewMode.class);
                v_OLog.setUserID(Help.NVL((String)v_BMode.getCreateUserID(), (String)v_BMode.getUserID()));
            } else {
                v_OLog.setUserID("");
            }
            v_OLog.setCreateTime(new Date());
            v_OLog.setId(StringHelp.getUUID());
            v_OLog.setUrl(v_Url);
            v_OLog.setUrlRequest(v_Request.getQueryString());
            v_OLog.setUrlRequestBody(v_Request.getBodyString());
            v_OLog.setUserIP(this.getIpAddress((HttpServletRequest)v_Request));
            v_OLog.setSystemCode(XJava.getParam((String)"MS_Common_ServiceName").getValue());
            v_OLog.setModuleCode(v_Urls[1]);
            v_OLogDAO.insert(this.backWhiteCheck(v_OLog));
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        ServletOutputStream v_Output = null;
        LogHttpServletResponseWrapper v_Response = new LogHttpServletResponseWrapper((HttpServletResponse)i_ServletResponse);
        if (!Help.isNull((String)v_OLog.getUrlResponse())) {
            i_ServletResponse.setCharacterEncoding("UTF-8");
            i_ServletResponse.setContentType("application/json");
            v_Output = i_ServletResponse.getOutputStream();
            v_Output.write(v_OLog.getUrlResponse().getBytes());
            return;
        }
        super.doFilter((ServletRequest)v_Request, (ServletResponse)v_Response, i_FilterChain);
        try {
            byte[] v_ResponseBody = v_Response.getResponseData();
            v_OLog.setUrlResponse(new String(v_ResponseBody));
            v_OLog.setResponseTime(Long.valueOf(Date.getNowTime().getTime()));
            v_OLog.setTimeLen(Long.valueOf(v_OLog.getResponseTime() - v_OLog.getRequestTime()));
            if (!Help.isNull((String)v_OLog.getUrlResponse())) {
                XJSON v_XJson = new XJSON();
                BaseResponse v_BResp = (BaseResponse)v_XJson.toJava(v_OLog.getUrlResponse(), BaseResponse.class);
                v_OLog.setResultCode(v_BResp.getCode());
                if (v_OLog.getUrlResponse().length() >= 4000) {
                    v_OLog.setUrlResponse(v_OLog.getUrlResponse().substring(0, 3999));
                }
            }
            v_OLogDAO.update(v_OLog);
            v_Output = i_ServletResponse.getOutputStream();
            v_Output.write(v_ResponseBody);
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        finally {
            if (v_Output != null) {
                v_Output.flush();
                v_Output.close();
            }
            v_Output = null;
        }
    }

    private String getIpAddress(HttpServletRequest i_Request) {
        String ip = i_Request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknow".equalsIgnoreCase(ip)) {
            ip = i_Request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = i_Request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = i_Request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }
}

