/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.ipSafe;

import java.util.List;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.app.Param;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.BaseController;
import org.hy.microservice.common.BaseResp;
import org.hy.microservice.common.BaseResponse;
import org.hy.microservice.common.ipSafe.IIPSafeConfigService;
import org.hy.microservice.common.ipSafe.IPSafeConfig;
import org.hy.microservice.common.operationLog.OperationLogController;
import org.hy.microservice.common.user.UserSSO;
import org.hy.microservice.common.user.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ipSafeConfig"}, name="\u8bbf\u95ee\u5b89\u5168")
public class IPSafeConfigController
extends BaseController {
    private static final Logger $Logger = new Logger(OperationLogController.class);
    @Autowired
    @Qualifier(value="IPSafeConfigService")
    private IIPSafeConfigService ipSafeConfigService;
    @Autowired
    @Qualifier(value="UserService")
    private UserService userService;
    @Autowired
    @Qualifier(value="MS_Common_IsCheckToken")
    private Param isCheckToken;

    @RequestMapping(name="\u67e5\u8be2\u5b89\u5168\u914d\u7f6e", value={"queryIPSafeConfig"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public BaseResponse<IPSafeConfig> queryIPSafeConfig(@RequestParam(value="token", required=false) String i_Token, @RequestBody IPSafeConfig i_IPSafeConfig) {
        BaseResponse<IPSafeConfig> v_RetResp = new BaseResponse<IPSafeConfig>();
        int v_Count = 0;
        if (i_IPSafeConfig == null) {
            return ((BaseResponse)v_RetResp.setCode("-1")).setMessage("\u672a\u6536\u5230\u4efb\u4f55\u53c2\u6570");
        }
        try {
            $Logger.info("queryIPSafeConfig Start: " + i_Token + ":" + i_IPSafeConfig.toString());
            if (Help.isNull((String)i_IPSafeConfig.getUserID())) {
                BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-2")).setMessage("\u7528\u6237\u7f16\u53f7\u4e3a\u7a7a");
                return baseResp;
            }
            if (Help.isNull((String)i_IPSafeConfig.getIpType())) {
                BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-3")).setMessage("IP\u7c7b\u578b\u4e3a\u7a7a");
                return baseResp;
            }
            if (!StringHelp.isContains((String)i_IPSafeConfig.getIpType(), (String[])new String[]{"blacklist", "whitelist"})) {
                BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-4")).setMessage("\u975e\u6cd5IP\u7c7b\u578b");
                return baseResp;
            }
            if (this.isCheckToken != null && Boolean.parseBoolean(this.isCheckToken.getValue())) {
                if (Help.isNull((String)i_Token)) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-901")).setMessage("\u975e\u6cd5\u8bbf\u95ee");
                    return baseResp;
                }
                UserSSO v_User = this.userService.getUser(i_Token);
                if (v_User == null) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-901")).setMessage("\u975e\u6cd5\u8bbf\u95ee");
                    return baseResp;
                }
            }
            List<IPSafeConfig> v_DataList = this.ipSafeConfigService.queryByIPType(i_IPSafeConfig);
            v_Count = v_DataList.size();
            BaseResponse<IPSafeConfig> baseResponse = v_RetResp.setData(v_DataList);
            return baseResponse;
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
            BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-999")).setMessage("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return baseResp;
        }
        finally {
            $Logger.info("queryIPSafeConfig End: " + i_Token + ":" + i_IPSafeConfig.toString() + " \u8fd4\u56de: " + v_Count);
        }
    }

    @RequestMapping(name="\u4fdd\u5b58\u5b89\u5168\u914d\u7f6e", value={"saveIPSafeConfig"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public BaseResponse<IPSafeConfig> saveIPSafeConfig(@RequestParam(value="token", required=false) String i_Token, @RequestBody IPSafeConfig i_IPSafeConfig) {
        BaseResponse<IPSafeConfig> v_RetResp = new BaseResponse<IPSafeConfig>();
        if (i_IPSafeConfig == null) {
            return ((BaseResponse)v_RetResp.setCode("-1")).setMessage("\u672a\u6536\u5230\u4efb\u4f55\u53c2\u6570");
        }
        try {
            $Logger.info("saveIPSafeConfig Start: " + i_Token + ":" + i_IPSafeConfig.toString());
            if (Help.isNull((String)i_IPSafeConfig.getUserID())) {
                BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-2")).setMessage("\u7528\u6237\u7f16\u53f7\u4e3a\u7a7a");
                return baseResp;
            }
            if (Help.isNull((String)i_IPSafeConfig.getId())) {
                if (Help.isNull((String)i_IPSafeConfig.getIpType())) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-3")).setMessage("IP\u7c7b\u578b\u4e3a\u7a7a");
                    return baseResp;
                }
                if (!StringHelp.isContains((String)i_IPSafeConfig.getIpType(), (String[])new String[]{"blacklist", "whitelist"})) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-4")).setMessage("\u975e\u6cd5IP\u7c7b\u578b");
                    return baseResp;
                }
                if (Help.isNull((String)i_IPSafeConfig.getIp())) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-5")).setMessage("IP\u4e3a\u7a7a");
                    return baseResp;
                }
                if (this.ipSafeConfigService.queryAll().getRow((Object)i_IPSafeConfig.getIpType(), i_IPSafeConfig.getIp()) != null) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-6")).setMessage("\u76f8\u540c\u5b89\u5168\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
                    return baseResp;
                }
            } else {
                if (Help.isNull((String)i_IPSafeConfig.getIpType()) && Help.isNull((String)i_IPSafeConfig.getIp()) && Help.isNull((String)i_IPSafeConfig.getComment()) && Help.isNull((Object)i_IPSafeConfig.getIsDel())) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-7")).setMessage("\u6ca1\u6709\u8981\u66f4\u65b0\u7684\u5185\u5bb9");
                    return baseResp;
                }
                IPSafeConfig v_OldConfig = this.ipSafeConfigService.queryByID(i_IPSafeConfig);
                if (v_OldConfig == null) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-102")).setMessage("\u66f4\u65b0\u4e3b\u952e\u4e0d\u5b58\u5728");
                    return baseResp;
                }
                if (i_IPSafeConfig.getIsDel() == null || i_IPSafeConfig.getIsDel() == 0) {
                    if (!Help.isNull((String)i_IPSafeConfig.getIpType()) && !Help.isNull((String)i_IPSafeConfig.getIp())) {
                        if (this.ipSafeConfigService.queryAll().getRow((Object)i_IPSafeConfig.getIpType(), i_IPSafeConfig.getIp()) != null) {
                            BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-6")).setMessage("\u76f8\u540c\u5b89\u5168\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
                            return baseResp;
                        }
                    } else if (!Help.isNull((String)i_IPSafeConfig.getIp())) {
                        if (this.ipSafeConfigService.queryAll().getRow((Object)v_OldConfig.getIpType(), i_IPSafeConfig.getIp()) != null) {
                            BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-6")).setMessage("\u76f8\u540c\u5b89\u5168\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
                            return baseResp;
                        }
                    } else if (!Help.isNull((String)i_IPSafeConfig.getIpType()) && this.ipSafeConfigService.queryAll().getRow((Object)i_IPSafeConfig.getIpType(), v_OldConfig.getIp()) != null) {
                        BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-6")).setMessage("\u76f8\u540c\u5b89\u5168\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
                        return baseResp;
                    }
                }
            }
            if (Help.isNull((String)i_IPSafeConfig.getUserID()) && Help.isNull((String)i_IPSafeConfig.getCreateUserID())) {
                BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-101")).setMessage("\u64cd\u4f5c\u7528\u6237\u7f16\u53f7\u4e3a\u7a7a");
                return baseResp;
            }
            if (this.isCheckToken != null && Boolean.parseBoolean(this.isCheckToken.getValue())) {
                if (Help.isNull((String)i_Token)) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-901")).setMessage("\u975e\u6cd5\u8bbf\u95ee");
                    return baseResp;
                }
                UserSSO v_User = this.userService.getUser(i_Token);
                if (v_User == null) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-901")).setMessage("\u975e\u6cd5\u8bbf\u95ee");
                    return baseResp;
                }
                if (!v_User.getUserId().equals(i_IPSafeConfig.getUserID())) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-902")).setMessage("\u64cd\u4f5c\u7528\u6237\u4e0e\u767b\u5f55\u7528\u6237\u4e0d\u4e00\u81f4");
                    return baseResp;
                }
            }
            IPSafeConfig v_SaveRet = null;
            v_SaveRet = Help.isNull((String)i_IPSafeConfig.getId()) ? this.ipSafeConfigService.insert(i_IPSafeConfig) : this.ipSafeConfigService.update(i_IPSafeConfig);
            if (v_SaveRet != null) {
                $Logger.info("\u7528\u6237\uff08" + v_SaveRet.getCreateUserID() + "\uff09\u521b\u5efa" + v_SaveRet.toString() + "\uff0c\u6210\u529f");
                BaseResponse<IPSafeConfig> baseResponse = v_RetResp.setData(v_SaveRet);
                return baseResponse;
            }
            $Logger.error("\u7528\u6237\uff08" + Help.NVL((String)i_IPSafeConfig.getCreateUserID(), (String)i_IPSafeConfig.getUserID()) + "\uff09\u521b\u5efa" + i_IPSafeConfig.toString() + "\uff0c\u5f02\u5e38");
            BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-998")).setMessage("\u7cfb\u7edf\u5f02\u5e38");
            return baseResp;
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
            BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-999")).setMessage("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return baseResp;
        }
        finally {
            $Logger.info("saveIPSafeConfig End: " + i_Token + ":" + i_IPSafeConfig.toString());
        }
    }

    @RequestMapping(name="\u5237\u65b0\u5b89\u5168\u914d\u7f6e", value={"refurbishIPSafeConfig"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public BaseResponse<IPSafeConfig> refurbishIPSafeConfig(@RequestParam(value="token", required=false) String i_Token, @RequestBody IPSafeConfig i_IPSafeConfig) {
        BaseResponse<IPSafeConfig> v_RetResp = new BaseResponse<IPSafeConfig>();
        int v_Count = 0;
        if (i_IPSafeConfig == null) {
            return ((BaseResponse)v_RetResp.setCode("-1")).setMessage("\u672a\u6536\u5230\u4efb\u4f55\u53c2\u6570");
        }
        try {
            $Logger.info("refurbishIPSafeConfig Start: " + i_Token + ":" + i_IPSafeConfig.toString());
            if (Help.isNull((String)i_IPSafeConfig.getUserID())) {
                BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-2")).setMessage("\u7528\u6237\u7f16\u53f7\u4e3a\u7a7a");
                return baseResp;
            }
            if (this.isCheckToken != null && Boolean.parseBoolean(this.isCheckToken.getValue())) {
                if (Help.isNull((String)i_Token)) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-901")).setMessage("\u975e\u6cd5\u8bbf\u95ee");
                    return baseResp;
                }
                UserSSO v_User = this.userService.getUser(i_Token);
                if (v_User == null) {
                    BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-901")).setMessage("\u975e\u6cd5\u8bbf\u95ee");
                    return baseResp;
                }
            }
            this.ipSafeConfigService.cacheIPSafesRefurbish();
            BaseResponse<IPSafeConfig> baseResponse = v_RetResp.setData(i_IPSafeConfig);
            return baseResponse;
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
            BaseResp baseResp = ((BaseResponse)v_RetResp.setCode("-999")).setMessage("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return baseResp;
        }
        finally {
            $Logger.info("refurbishIPSafeConfig End: " + i_Token + ":" + i_IPSafeConfig.toString() + " \u8fd4\u56de: " + v_Count);
        }
    }
}

