/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.license;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import org.hy.common.license.base64.Base64Factory;

public final class SignProvider {
    public static boolean verify(String i_PublicKey, String i_PlainText, String i_Sign) {
        return SignProvider.verify(i_PublicKey.getBytes(), i_PlainText, i_Sign.getBytes());
    }

    public static boolean verify(byte[] i_PublicKey, String i_PlainText, byte[] i_Sign) {
        try {
            X509EncodedKeySpec v_X509Encoded = new X509EncodedKeySpec(Base64Factory.getIntance().decode(i_PublicKey));
            KeyFactory v_KeyFactory = KeyFactory.getInstance("RSA");
            PublicKey v_PublicKey = v_KeyFactory.generatePublic(v_X509Encoded);
            byte[] v_Sign = Base64Factory.getIntance().decode(i_Sign);
            Signature v_Signature = Signature.getInstance("MD5withRSA");
            v_Signature.initVerify(v_PublicKey);
            v_Signature.update(i_PlainText.getBytes());
            if (v_Signature.verify(v_Sign)) {
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private SignProvider() {
    }
}

