/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.license;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import org.hy.common.ByteHelp;
import org.hy.common.license.VBBase64;

public class StrConv {
    private static ByteArrayOutputStream baos;
    private static DataOutputStream dos;
    private static StringBuffer dst;

    private StrConv() {
    }

    public static byte[] vbFromUnicode(String i_Text) {
        return ByteHelp.toByte((String)i_Text, (String)"GBK");
    }

    public static String vbUnicode(int[] i_Datas) throws UnsupportedEncodingException {
        return ByteHelp.byteToString((byte[])VBBase64.intToByteArray(i_Datas), (String)"GBK");
    }

    public static byte[] stringToByteArray(String val) {
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            dos.writeUTF(val);
            byte[] raw = baos.toByteArray();
            byte[] result = new byte[raw.length - 2];
            System.arraycopy(raw, 2, result, 0, raw.length - 2);
            raw = null;
            raw = new byte[]{};
            dos.close();
            baos.close();
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String convCp1251ToUnicode(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch > '\u00bf') {
                ch = (char)(ch + 848);
            }
            if (ch == '\u00a8') {
                ch = '\u0401';
            }
            if (ch == '\u00b8') {
                ch = '\u0451';
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static final String convUnicodeToCp1251(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\u0401') {
                ch = '\u00a8';
            }
            if (ch == '\u0451') {
                ch = '\u00b8';
            }
            if (ch > '\u0409') {
                ch = (char)(ch - 848);
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static final String toBase64(String source) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        int len = source.length();
        char[] out = new char[(len + 2) / 3 << 2];
        int i = 0;
        int index = 0;
        while (i < len) {
            boolean trip = false;
            boolean quad = false;
            int val = (0xFF & source.charAt(i)) << 8;
            if (i + 1 < len) {
                val |= 0xFF & source.charAt(i + 1);
                trip = true;
            }
            val <<= 8;
            if (i + 2 < len) {
                val |= 0xFF & source.charAt(i + 2);
                quad = true;
            }
            out[index + 3] = alphabet.charAt(quad ? val & 0x3F : 64);
            out[index + 2] = alphabet.charAt(trip ? (val >>= 6) & 0x3F : 64);
            out[index + 1] = alphabet.charAt((val >>= 6) & 0x3F);
            out[index + 0] = alphabet.charAt((val >>= 6) & 0x3F);
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static final String toBase64(byte[] source, int len) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        if (len < 0) {
            len = source.length;
        }
        char[] out = new char[(len + 2) / 3 << 2];
        int i = 0;
        int index = 0;
        while (i < len) {
            boolean trip = false;
            boolean quad = false;
            int val = (0xFF & source[i]) << 8;
            if (i + 1 < len) {
                val |= 0xFF & source[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < len) {
                val |= 0xFF & source[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet.charAt(quad ? val & 0x3F : 64);
            out[index + 2] = alphabet.charAt(trip ? (val >>= 6) & 0x3F : 64);
            out[index + 1] = alphabet.charAt((val >>= 6) & 0x3F);
            out[index + 0] = alphabet.charAt((val >>= 6) & 0x3F);
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static StringBuffer toUTFSb(StringBuffer str) {
        int srcLen = str.length();
        StringBuffer outbuf = new StringBuffer(srcLen);
        char c = '\u0000';
        for (int i = 0; i < srcLen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                outbuf.append(c);
            }
            if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                outbuf.append((char)(0xC0 | 0x1F & c >> 6));
                outbuf.append((char)(0x80 | 0x3F & c));
            }
            if (c < '\u0800' || c > '\uffff') continue;
            outbuf.append((char)(0xE0 | 0xF & c >> 12));
            outbuf.append((char)(0x80 | 0x3F & c >> 6));
            outbuf.append((char)(0x80 | 0x3F & c));
        }
        return outbuf;
    }

    public static byte[] fromBase64(String s) {
        return StrConv.baosFromBase64(s).toByteArray();
    }

    public static String sFromBase64(String s) {
        return StrConv.baosFromBase64(s).toString();
    }

    private static ByteArrayOutputStream baosFromBase64(String s) {
        int padding = 0;
        int ibuf = 1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        for (int i = 0; i < s.length(); ++i) {
            char nextChar = s.charAt(i);
            int base64 = -1;
            if (nextChar > '@' && nextChar < '[') {
                base64 = nextChar - 65;
            } else if (nextChar > '`' && nextChar < '{') {
                base64 = nextChar + 26 - 97;
            } else if (nextChar > '/' && nextChar < ':') {
                base64 = nextChar + 52 - 48;
            } else if (nextChar == '+') {
                base64 = 62;
            } else if (nextChar == '/') {
                base64 = 63;
            } else if (nextChar == '=') {
                base64 = 0;
                ++padding;
            } else if (nextChar == '<') break;
            if (base64 >= 0) {
                ibuf = (ibuf << 6) + base64;
            }
            if (ibuf < 0x1000000) continue;
            baos.write(ibuf >> 16 & 0xFF);
            if (padding < 2) {
                baos.write(ibuf >> 8 & 0xFF);
            }
            if (padding == 0) {
                baos.write(ibuf & 0xFF);
            }
            ibuf = 1;
        }
        try {
            baos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos;
    }

    public static String unicodeToUTF(String src) {
        return StrConv.toUTFSb(new StringBuffer(src)).toString();
    }

    public static String toLowerCase(String src) {
        dst = new StringBuffer(0);
        dst.append(src);
        int len = dst.length();
        for (int i = 0; i < len; ++i) {
            char c = dst.charAt(i);
            if (c > '@' && c < '[') {
                c = (char)(c + 32);
            }
            if (c > '\u040f' && c < '\u0430') {
                c = (char)(c + 32);
            }
            dst.setCharAt(i, c);
        }
        return dst.toString();
    }

    static {
        dst = new StringBuffer(0);
    }
}

