/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.license;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import org.hy.common.license.base64.Base64Factory;

public final class KeyStore {
    private byte[] privateKey;
    private byte[] publicKey;

    public static final KeyStore generater() {
        return KeyStore.generater("hy.common.license");
    }

    public static final KeyStore generater(String i_Seed) {
        KeyStore v_Key = null;
        try {
            KeyPairGenerator v_Keygen = KeyPairGenerator.getInstance("RSA");
            SecureRandom v_SecureRandom = new SecureRandom();
            v_SecureRandom.setSeed(i_Seed.getBytes());
            v_Keygen.initialize(1024, v_SecureRandom);
            KeyPair v_Keys = v_Keygen.genKeyPair();
            v_Key = new KeyStore();
            v_Key.publicKey = Base64Factory.getIntance().encode(v_Keys.getPublic().getEncoded());
            v_Key.privateKey = Base64Factory.getIntance().encode(v_Keys.getPrivate().getEncoded());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v_Key;
    }

    public void setPrivateKey(String i_PrivateKey) {
        this.privateKey = i_PrivateKey.getBytes();
    }

    public void setPublicKey(String i_PublicKey) {
        this.publicKey = i_PublicKey.getBytes();
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKeyString() {
        return new String(this.privateKey);
    }

    public String getPublicKeyString() {
        return new String(this.publicKey);
    }
}

