/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.license;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hy.common.Help;
import org.hy.common.file.FileHelp;
import org.hy.common.license.Hash;
import org.hy.common.license.base64.Base64Factory;
import org.hy.common.xml.log.Logger;

public class FileFingerprint {
    private static final Logger $Logger = Logger.getLogger(FileFingerprint.class);
    private FileHelp fileHelp;
    private Hash hash;

    public FileFingerprint() {
        this(new Hash(2, 2, null, false));
    }

    public FileFingerprint(Hash i_Hash) {
        if (i_Hash == null) {
            throw new NullPointerException("Hash is null ,for FileFingerprint.");
        }
        this.hash = i_Hash;
        this.fileHelp = new FileHelp();
    }

    public String calcFingerprint(File i_Folder) {
        return this.calcFingerprint(i_Folder, 0);
    }

    private String calcFingerprint(File i_Folder, int i_Level) {
        StringBuilder v_Fingerprint = new StringBuilder();
        if (i_Folder == null) {
            return "";
        }
        if (!i_Folder.exists()) {
            return "";
        }
        if (!i_Folder.isDirectory()) {
            if (!i_Folder.isFile()) {
                return "";
            }
            String v_Content = "";
            try {
                byte[] v_ContentByte = this.fileHelp.getContentByte(i_Folder);
                if (!Help.isNull((byte[])v_ContentByte)) {
                    v_Content = new String(Base64Factory.getIntance().encode(v_ContentByte), "UTF-8");
                }
            }
            catch (IOException e) {
                v_Content = "";
                $Logger.error((Throwable)e);
            }
            if (v_Content != null && !"".equals(v_Content)) {
                return this.hash.encrypt(v_Content);
            }
            return "";
        }
        Object[] v_FilesArr = i_Folder.listFiles();
        if (Help.isNull((Object[])v_FilesArr)) {
            return "";
        }
        List<Object> v_Files = Arrays.asList(v_FilesArr);
        Help.toSort(v_Files, (String[])new String[]{"name"});
        for (File file : v_Files) {
            String v_Content = "";
            if (file.isFile()) {
                try {
                    byte[] v_ContentByte = this.fileHelp.getContentByte(file);
                    if (!Help.isNull((byte[])v_ContentByte)) {
                        v_Content = new String(Base64Factory.getIntance().encode(v_ContentByte), "UTF-8");
                    }
                }
                catch (IOException e) {
                    v_Content = "";
                    $Logger.error((Throwable)e);
                }
                if (v_Content == null || "".equals(v_Content)) continue;
                v_Content = this.hash.encrypt(v_Content);
                v_Fingerprint.append(v_Content);
                continue;
            }
            if (!file.isDirectory() || (v_Content = this.calcFingerprint(file, i_Level + 1)) == null || "".equals(v_Content)) continue;
            v_Fingerprint.append(v_Content);
        }
        if (!Help.isNull((String)v_Fingerprint.toString())) {
            if (i_Level == 0) {
                return this.hash.encrypt(v_Fingerprint.toString());
            }
            return v_Fingerprint.toString();
        }
        return "";
    }

    public String calcFingerprint(File i_Folder, String i_ExcludeFiles) {
        return this.calcFingerprint(i_Folder, i_ExcludeFiles, null);
    }

    public String calcFingerprint(File i_Folder, String i_ExcludeFiles, String i_ExcludeFolders) {
        return this.calcFingerprint(i_Folder, i_ExcludeFiles, null, 0);
    }

    private String calcFingerprint(File i_Folder, String i_ExcludeFiles, String i_ExcludeFolders, int i_Level) {
        StringBuilder v_Fingerprint = new StringBuilder();
        if (i_Folder == null) {
            return "";
        }
        if (!i_Folder.exists()) {
            return "";
        }
        String v_ExcludeFiles = Help.NVL((String)i_ExcludeFiles).toLowerCase();
        String v_ExcludeFolders = Help.NVL((String)i_ExcludeFolders).toLowerCase();
        if (!i_Folder.isDirectory()) {
            if (!i_Folder.isFile()) {
                return "";
            }
            if (!Help.isNull((String)v_ExcludeFiles) && v_ExcludeFiles.indexOf("|" + i_Folder.getName().toLowerCase() + "|") >= 0) {
                return "";
            }
            String v_Content = "";
            try {
                byte[] v_ContentByte = this.fileHelp.getContentByte(i_Folder);
                if (!Help.isNull((byte[])v_ContentByte)) {
                    v_Content = new String(Base64Factory.getIntance().encode(v_ContentByte), "UTF-8");
                }
            }
            catch (IOException e) {
                v_Content = "";
                $Logger.error((Throwable)e);
            }
            if (v_Content != null && !"".equals(v_Content)) {
                return this.hash.encrypt(v_Content);
            }
            return "";
        }
        Object[] v_FilesArr = i_Folder.listFiles();
        if (Help.isNull((Object[])v_FilesArr)) {
            return "";
        }
        List<Object> v_Files = Arrays.asList(v_FilesArr);
        Help.toSort(v_Files, (String[])new String[]{"name"});
        for (File file : v_Files) {
            String v_Content = "";
            if (file.isFile()) {
                if (!Help.isNull((String)v_ExcludeFiles) && v_ExcludeFiles.indexOf("|" + file.getName().toLowerCase() + "|") >= 0) continue;
                try {
                    byte[] v_ContentByte = this.fileHelp.getContentByte(file);
                    if (!Help.isNull((byte[])v_ContentByte)) {
                        v_Content = new String(Base64Factory.getIntance().encode(v_ContentByte), "UTF-8");
                    }
                }
                catch (IOException e) {
                    v_Content = "";
                    $Logger.error((Throwable)e);
                }
                if (v_Content == null || "".equals(v_Content)) continue;
                v_Content = this.hash.encrypt(v_Content);
                v_Fingerprint.append(v_Content);
                continue;
            }
            if (!file.isDirectory() || !Help.isNull((String)v_ExcludeFolders) && v_ExcludeFolders.indexOf("|" + file.getName().toLowerCase() + "|") >= 0 || (v_Content = this.calcFingerprint(file, v_ExcludeFiles, v_ExcludeFolders, i_Level + 1)) == null || "".equals(v_Content)) continue;
            v_Fingerprint.append(v_Content);
        }
        if (!Help.isNull((String)v_Fingerprint.toString())) {
            if (i_Level == 0) {
                return this.hash.encrypt(v_Fingerprint.toString());
            }
            return v_Fingerprint.toString();
        }
        return "";
    }
}

