/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.license;

import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.license.LicenseRegister;
import org.hy.common.license.SignProvider;
import org.hy.common.license.Symmetric;
import org.hy.common.license.base64.Base64Factory;
import org.hy.common.xml.SerializableDef;

public class License
extends SerializableDef {
    private static final long serialVersionUID = 8798746455323239535L;
    private String runTime;
    private String time;
    private String format;
    private String licenseCode;
    private String onLineCount;
    private String maxCount;

    public String getRunTime() {
        return this.runTime;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    public String getOnLineCount() {
        return this.onLineCount;
    }

    public void setOnLineCount(String onLineCount) {
        this.onLineCount = onLineCount;
    }

    public String getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(String maxCount) {
        this.maxCount = maxCount;
    }

    public boolean verify() {
        for (int i = 0; i < this.gatPropertySize(); ++i) {
            Object v_Value = this.gatPropertyValue(i);
            if (v_Value != null && !Help.isNull((String)v_Value.toString())) continue;
            return false;
        }
        return true;
    }

    public static int verifyLicense(License io_License, String i_PublicKey, Integer i_OnLineCount, Integer i_MaxCount) {
        if (!io_License.verify()) {
            return -1;
        }
        try {
            Integer v_MaxCount;
            String v_Register = LicenseRegister.makeRegister();
            String v_PublicKey = io_License.getLicenseCode().split("#")[0];
            String v_Sign = io_License.getLicenseCode().split("#")[1];
            if (!i_PublicKey.equals(v_PublicKey)) {
                return -2;
            }
            io_License.setLicenseCode(null);
            String v_MachineID = v_Register + io_License.toString();
            Symmetric v_Symmetric = new Symmetric(v_Register);
            boolean v_Verify = SignProvider.verify(v_PublicKey, v_MachineID, v_Sign);
            if (!v_Verify) {
                return -2;
            }
            Date v_NowTime = new Date();
            Date v_RunTime = new Date(new String(Base64Factory.getIntance().decode(io_License.getRunTime())));
            if (v_RunTime == null || v_NowTime.differ(v_RunTime) <= 0L) {
                return -3;
            }
            Date v_Time = new Date(new String(Base64Factory.getIntance().decode(io_License.getTime())));
            if (v_Time == null || v_NowTime.differ(v_Time) >= 0L) {
                return -4;
            }
            Integer v_OnLineCount = Integer.parseInt(v_Symmetric.decrypt(io_License.getOnLineCount()));
            if (v_OnLineCount != null && v_OnLineCount > 0) {
                if (i_OnLineCount == null) {
                    return -5;
                }
                if (i_OnLineCount > v_OnLineCount) {
                    return -5;
                }
            }
            if ((v_MaxCount = Integer.valueOf(Integer.parseInt(v_Symmetric.decrypt(io_License.getMaxCount())))) != null && v_MaxCount > 0) {
                if (i_MaxCount == null) {
                    return -6;
                }
                if (i_MaxCount > v_MaxCount) {
                    return -6;
                }
            }
            io_License.setTime(v_Time.getFull());
            return 0;
        }
        catch (Exception exception) {
            return -99;
        }
    }
}

