/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.timeout;

import java.util.concurrent.TimeoutException;
import org.hy.common.callflow.timeout.TimeoutRunnable;

public class TimeoutConfig<R> {
    private long timeout;
    private Thread executeThread;
    private Exception executeException;
    private R executeResult;
    private TimeoutRunnable<R> runnable;

    public TimeoutConfig(long i_Timeout) {
        this.timeout = i_Timeout;
    }

    public TimeoutConfig<R> future(TimeoutRunnable<R> i_Runnable) {
        this.runnable = i_Runnable;
        return this;
    }

    public R execute() {
        if (this.executeAsync()) {
            return this.get();
        }
        return null;
    }

    public boolean executeAsync() {
        if (this.runnable == null) {
            this.executeException = new NullPointerException("TimeoutRunnable is null.");
            this.executeResult = null;
            return false;
        }
        try {
            this.executeException = null;
            this.executeResult = null;
            this.executeThread = new Thread(() -> {
                try {
                    this.executeResult = this.runnable.run();
                }
                catch (InterruptedException exce) {
                    this.executeException = new TimeoutException("Timeout " + this.timeout + " millisecond.");
                }
                catch (Exception exce) {
                    this.executeException = exce;
                }
            });
            this.executeThread.start();
        }
        catch (Exception exce) {
            this.executeException = exce;
        }
        return true;
    }

    public R get() {
        try {
            if (this.timeout > 0L) {
                this.executeThread.join(this.timeout, 0);
            } else {
                this.executeThread.join();
            }
            this.executeThread.interrupt();
            Thread.interrupted();
        }
        catch (InterruptedException exce) {
            this.executeException = exce;
        }
        if (this.executeResult != null) {
            this.executeException = null;
            this.executeThread = null;
            return this.executeResult;
        }
        if (this.executeException != null) {
            if (!(this.executeException instanceof TimeoutException)) {
                if (this.executeException.getCause() instanceof TimeoutException) {
                    this.executeException = (TimeoutException)this.executeException.getCause();
                } else if (this.executeException instanceof InterruptedException) {
                    this.executeException = new TimeoutException("Timeout " + this.timeout + " millisecond.");
                } else if (this.executeException.getCause() instanceof InterruptedException) {
                    this.executeException = new TimeoutException("Timeout " + this.timeout + " millisecond.");
                }
            }
            this.executeThread = null;
            return null;
        }
        this.executeException = new TimeoutException("Timeout " + this.timeout + " millisecond.");
        this.executeThread = null;
        return null;
    }

    public boolean isTimeout() {
        if (this.executeException == null) {
            return false;
        }
        return this.executeException instanceof TimeoutException;
    }

    public boolean isError() {
        return this.executeException != null;
    }

    public boolean isSucceed() {
        return this.executeResult != null;
    }

    public Exception getException() {
        return this.executeException;
    }

    public R getResult() {
        return this.executeResult;
    }

    public boolean cancel() {
        if (this.executeThread != null) {
            this.executeThread.interrupt();
            return true;
        }
        return false;
    }
}

