/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.safe;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.callflow.node.ZipConfig;
import org.hy.common.file.FileHelp;
import org.hy.common.license.Hash;
import org.hy.common.xml.log.Logger;

public class EncryptFileConfig
extends ZipConfig
implements NodeConfigBase {
    private static final Logger $Logger = new Logger(EncryptFileConfig.class);
    private String passwordType;

    public EncryptFileConfig() {
        this(0L, 0L);
    }

    public EncryptFileConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setCallMethod("createEncryptFile");
        this.setPasswordType("MD5V4");
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getFile())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].file is null.");
            return false;
        }
        if (Help.isNull((String)this.getDir())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].dir is null.");
            return false;
        }
        return true;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPasswordType(String i_PasswordType) {
        this.passwordType = Help.isNull((String)i_PasswordType) ? "MD5V4" : ("MD5V4".equalsIgnoreCase(i_PasswordType) || "FAST".equalsIgnoreCase(i_PasswordType) ? i_PasswordType : "MD5V4");
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String getElementType() {
        return ElementType.EncryptFile.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.EncryptFile.getXmlName();
    }

    public Map<String, String> createEncryptFile(Object i_File, String i_Dir, String i_Name, String i_Password) {
        if (Help.isNull((String)i_Dir)) {
            throw new RuntimeException("Dir is null");
        }
        File v_Dir = new File((String)(i_Dir.endsWith(Help.getSysPathSeparator()) ? i_Dir : i_Dir + Help.getSysPathSeparator()));
        if (!v_Dir.exists()) {
            v_Dir.mkdirs();
        }
        File v_EnFile = null;
        v_EnFile = Help.isNull((String)i_Name) ? new File(v_Dir.getPath() + StringHelp.getUUID9n()) : new File(v_Dir.getPath() + i_Name);
        if (v_EnFile.exists()) {
            if (!this.getOverwrite().booleanValue()) {
                throw new RuntimeException("File[" + v_EnFile.getPath() + "] was exists.");
            }
            v_EnFile.delete();
            $Logger.info("Old file[" + v_EnFile.getPath() + "] was delete.");
        }
        FileHelp v_FHelp = new FileHelp();
        StringBuilder v_Msg = new StringBuilder();
        String v_Password = i_Password;
        try {
            if (i_File == null) {
                throw new RuntimeException("File is null.");
            }
            if (i_File instanceof String) {
                String v_FileString = i_File.toString();
                if (Help.isNull((String)v_FileString)) {
                    throw new RuntimeException("File is null.");
                }
                File v_File = new File(v_FileString);
                v_Msg.append(v_File.getPath()).append(" Encrypt to ").append(v_EnFile.getPath());
                if (Help.isNull((String)v_Password)) {
                    v_Password = "FAST".equals(v_Password) ? StringHelp.getUUID9n() : this.makePassword(v_File);
                }
                v_FHelp.createZip4j(v_EnFile, v_File, v_Password);
                if (this.getDoneDelete().booleanValue()) {
                    v_File.delete();
                }
            } else if (i_File instanceof File) {
                v_File = (File)i_File;
                v_Msg.append(((File)v_File).getPath()).append(" Encrypt to ").append(v_EnFile.getPath());
                if (Help.isNull((String)v_Password)) {
                    v_Password = "FAST".equals(v_Password) ? StringHelp.getUUID9n() : this.makePassword((File)v_File);
                }
                v_FHelp.createZip4j(v_EnFile, (File)v_File, v_Password);
                if (this.getDoneDelete().booleanValue()) {
                    ((File)v_File).delete();
                }
            } else if (i_File instanceof InputStream) {
                v_File = (InputStream)i_File;
                v_Msg.append("InputStream Encrypt to ").append(v_EnFile.getPath());
                if (Help.isNull((String)v_Password)) {
                    byte[] v_Content = v_FHelp.getContentByte((InputStream)v_File);
                    v_Password = "FAST".equals(v_Password) ? StringHelp.getUUID9n() : this.makePassword(new ByteArrayInputStream(v_Content));
                    v_File = new ByteArrayInputStream(v_Content);
                }
                v_FHelp.createZip4j(v_EnFile, (InputStream)v_File, v_Password);
                ((InputStream)v_File).close();
            } else {
                throw new RuntimeException("File[" + v_EnFile.getPath() + "] parameter type is error.");
            }
            v_Msg.append(" is Succeed.");
            $Logger.info(v_Msg.toString());
            HashMap<String, String> v_Ret = new HashMap<String, String>();
            v_Ret.put("doneFile", v_EnFile.getPath());
            v_Ret.put("donePassword", v_Password);
            return v_Ret;
        }
        catch (RuntimeException exce) {
            $Logger.error((Object)exce, v_Msg.toString(), new Object[0]);
            throw exce;
        }
        catch (Exception exce) {
            $Logger.error((Object)exce, v_Msg.toString(), new Object[0]);
            throw new RuntimeException(exce.getMessage(), exce);
        }
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        super.toXmlContent(io_Xml, i_Level, i_Level1, i_LevelN, i_SuperTreeID, i_TreeID);
        if (!Help.isNull((String)this.passwordType)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("passwordType", this.passwordType));
        }
    }

    private String makePassword(File i_File) throws IOException {
        FileHelp v_FHelp = new FileHelp();
        String v_Content = v_FHelp.getContent(i_File);
        Hash v_MD5 = new Hash();
        return v_MD5.encrypt(v_Content);
    }

    private String makePassword(InputStream io_File) throws IOException {
        FileHelp v_FHelp = new FileHelp();
        String v_Content = v_FHelp.getContent(io_File);
        Hash v_MD5 = new Hash();
        return v_MD5.encrypt(v_Content);
    }

    @Override
    public Object newMy() {
        return new EncryptFileConfig();
    }

    @Override
    public Object cloneMyOnly() {
        EncryptFileConfig v_Clone = new EncryptFileConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.passwordType = this.passwordType;
        v_Clone.setOverwrite(this.getOverwrite());
        v_Clone.setDoneDelete(this.getDoneDelete());
        v_Clone.setIgnoreError(this.getIgnoreError());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone EncryptFileConfig xid is null.");
        }
        EncryptFileConfig v_Clone = (EncryptFileConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.passwordType = this.passwordType;
        v_Clone.setOverwrite(this.getOverwrite());
        v_Clone.setDoneDelete(this.getDoneDelete());
        v_Clone.setIgnoreError(this.getIgnoreError());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone EncryptFileConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        EncryptFileConfig v_Clone = new EncryptFileConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

