/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.safe;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.callflow.node.UnzipConfig;
import org.hy.common.file.FileHelp;
import org.hy.common.xml.log.Logger;

public class DecryptFileConfig
extends UnzipConfig
implements NodeConfigBase {
    private static final Logger $Logger = new Logger(DecryptFileConfig.class);

    public DecryptFileConfig() {
        this(0L, 0L);
    }

    public DecryptFileConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setCallMethod("decryptFile");
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getFile())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].file is null.");
            return false;
        }
        if (Help.isNull((String)this.getPassword())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].password is null.");
            return false;
        }
        return true;
    }

    @Override
    public String getElementType() {
        return ElementType.DecryptFile.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.DecryptFile.getXmlName();
    }

    public String decryptFile(String i_File, String i_Dir, String i_Password) {
        if (Help.isNull((String)i_Password)) {
            throw new RuntimeException("Password is null");
        }
        if (Help.isNull((String)i_File)) {
            throw new RuntimeException("File is null");
        }
        File v_File = new File(i_File);
        if (!v_File.exists()) {
            throw new RuntimeException("File[" + i_File + "] is not exists.");
        }
        String v_UnzipDir = i_Dir;
        if (Help.isNull((String)v_UnzipDir)) {
            v_UnzipDir = v_File.getParent();
        }
        try {
            FileHelp v_FHelp = new FileHelp();
            v_FHelp.UnCompressZip4j(i_File, v_UnzipDir, i_Password);
            if (this.getDoneDelete().booleanValue()) {
                v_File.delete();
            }
            return i_Dir;
        }
        catch (Exception exce) {
            $Logger.error((Object)exce, i_File + " Decrypt to " + i_Dir, new Object[0]);
            throw new RuntimeException(exce.getMessage(), exce);
        }
    }

    @Override
    public Object newMy() {
        return new DecryptFileConfig();
    }

    @Override
    public Object cloneMyOnly() {
        DecryptFileConfig v_Clone = new DecryptFileConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.setDoneDelete(this.getDoneDelete());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone DecryptFileConfig xid is null.");
        }
        DecryptFileConfig v_Clone = (DecryptFileConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.setDoneDelete(this.getDoneDelete());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone DecryptFileConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        DecryptFileConfig v_Clone = new DecryptFileConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

