/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.route;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.forloop.ForConfig;
import org.hy.common.callflow.route.RouteConfig;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class SelfLoop
extends ExecuteElement {
    private static final Logger $Logger = new Logger(SelfLoop.class);
    private RouteItem owner;
    private String refXID;

    public SelfLoop(RouteItem i_Owner, String i_RefXID) {
        super(0L, 0L);
        if (Help.isNull((String)i_RefXID)) {
            throw new NullPointerException("SelfLoop's refXID is null.");
        }
        if (CallFlow.isSystemXID(i_RefXID)) {
            throw new IllegalArgumentException("SelfLoop's refXID[" + i_RefXID + "] is SystemXID.");
        }
        this.owner = i_Owner;
        this.refXID = ValueHelp.standardValueID(i_RefXID);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        return true;
    }

    public RouteItem gatOwner() {
        return this.owner;
    }

    @Override
    public String getElementType() {
        return ElementType.SelfLoop.getValue();
    }

    public String getRefXID() {
        return ":" + this.refXID;
    }

    public String gatRefXID() {
        return this.refXID;
    }

    protected ExecuteElement gatExecuteElement() {
        ExecuteElement v_ExecObject = (ExecuteElement)XJava.getObject((String)this.refXID);
        if (v_ExecObject == null) {
            throw new RuntimeException("SelfLoop.RefXID[" + this.refXID + "] is not find.");
        }
        return v_ExecObject;
    }

    @Override
    public List<IExecute> gatPrevious() {
        return this.gatExecuteElement().gatPrevious();
    }

    @Override
    public RouteConfig getRoute() {
        return null;
    }

    public RouteConfig gatRoute() {
        return this.gatExecuteElement().getRoute();
    }

    @Override
    public Collection<String> getTreeIDs() {
        return this.gatExecuteElement().getTreeIDs();
    }

    @Override
    public String getTreeID(String i_SuperTreeID) {
        ExecuteElement v_ExecObject = this.gatExecuteElement();
        String v_TreeID = v_ExecObject.getTreeID(i_SuperTreeID);
        if (Help.isNull((String)v_TreeID)) {
            if (v_ExecObject.getTreeIDs().size() == 1) {
                v_TreeID = v_ExecObject.getTreeIDs().iterator().next();
            } else {
                for (String v_TreeIDItem : v_ExecObject.getTreeIDs()) {
                    if (!i_SuperTreeID.startsWith(v_TreeIDItem)) continue;
                    v_TreeID = v_TreeIDItem;
                    return v_TreeID;
                }
                v_TreeID = v_ExecObject.getTreeIDs().iterator().next();
            }
        }
        return v_TreeID;
    }

    @Override
    public String getTreeSuperID(String i_TreeID) {
        return this.gatExecuteElement().getTreeSuperID(i_TreeID);
    }

    @Override
    public Integer getTreeLevel(String i_TreeID) {
        return this.gatExecuteElement().getTreeLevel(i_TreeID);
    }

    @Override
    public Integer getTreeNo(String i_TreeID) {
        return this.gatExecuteElement().getTreeNo(i_TreeID);
    }

    @Override
    public String getMaxTreeID() {
        return this.gatExecuteElement().getMaxTreeID();
    }

    @Override
    public String getMinTreeID() {
        return this.gatExecuteElement().getMinTreeID();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        ForConfig v_For;
        ExecuteElement v_ExecObject = (ExecuteElement)XJava.getObject((String)this.refXID);
        if (v_ExecObject == null) {
            ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.refXID, this.toString(io_Context));
            v_Result.setException(new RuntimeException("SelfLoop.RefXID[" + this.refXID + "] is not find."));
            return v_Result;
        }
        if (v_ExecObject instanceof ForConfig && !(v_For = (ForConfig)v_ExecObject).hasNext(io_Context)) {
            ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.refXID, this.toString(io_Context));
            return v_Result.setResult(false);
        }
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        String v_SuperTreeID = this.getTreeSuperID(v_TreeID);
        return v_ExecObject.execute(v_SuperTreeID, io_Context);
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        throw new RuntimeException("Not allowed to call SelfLoop.toXml().");
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        ExecuteElement v_ExecObject = null;
        try {
            v_ExecObject = this.gatExecuteElement();
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        if (v_ExecObject == null) {
            v_Builder.append("SelfLoop ").append(":").append(this.refXID);
        } else if (v_ExecObject instanceof ForConfig) {
            v_Builder.append("For End ").append(":").append(this.refXID);
        } else {
            v_Builder.append("SelfLoop ").append(":").append(this.refXID);
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("SelfLoop ").append(":").append(this.refXID);
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        throw new RuntimeException("Not allowed to call SelfLoop.newMy().");
    }

    @Override
    public Object cloneMyOnly() {
        throw new RuntimeException("Not allowed to call SelfLoop.cloneMyOnly().");
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        throw new RuntimeException("Not allowed to call SelfLoop.clone().");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new RuntimeException("Not allowed to call SelfLoop.clone().");
    }
}

