/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.file.FileHelp;
import org.hy.common.xml.log.Logger;

public class ZipConfig
extends NodeConfig
implements NodeConfigBase {
    private static final Logger $Logger = new Logger(ZipConfig.class);
    public static final String $Key_DoneFile = "doneFile";
    public static final String $Key_DonePwd = "donePassword";
    private NodeParam file;
    private NodeParam dir;
    private NodeParam name;
    private NodeParam password;
    private Boolean overwrite;
    private Boolean doneDelete;
    private Boolean ignoreError;

    public ZipConfig() {
        this(0L, 0L);
    }

    public ZipConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setCallMethod("createZip");
        this.file = new NodeParam();
        this.file.setValueClass(Object.class.getName());
        this.setCallParam(this.file);
        this.dir = new NodeParam();
        this.dir.setValueClass(String.class.getName());
        this.setCallParam(this.dir);
        this.name = new NodeParam();
        this.name.setValueClass(String.class.getName());
        this.setCallParam(this.name);
        this.password = new NodeParam();
        this.password.setValueClass(String.class.getName());
        this.setCallParam(this.password);
        this.overwrite = true;
        this.doneDelete = false;
        this.ignoreError = false;
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getFile())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].file is null.");
            return false;
        }
        if (Help.isNull((String)this.getDir())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].dir is null.");
            return false;
        }
        return true;
    }

    public String getFile() {
        return this.file.getValue();
    }

    public void setFile(String i_File) {
        this.file.setValue(i_File);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getDir() {
        return this.dir.getValue();
    }

    public void setDir(String i_Dir) {
        this.dir.setValue(i_Dir);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getName() {
        return this.name.getValue();
    }

    public void setName(String i_Name) {
        this.name.setValue(i_Name);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPassword() {
        return this.password.getValue();
    }

    public void setPassword(String i_Password) {
        this.password.setValue(i_Password);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(Boolean i_Overwrite) {
        this.overwrite = i_Overwrite == null ? true : i_Overwrite;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getDoneDelete() {
        return this.doneDelete;
    }

    public void setDoneDelete(Boolean i_DoneDelete) {
        this.doneDelete = i_DoneDelete == null ? false : i_DoneDelete;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(Boolean i_IgnoreError) {
        this.ignoreError = i_IgnoreError;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public void setXJavaID(String i_Xid) {
        super.setXJavaID(i_Xid);
        this.setCallXID(this.getXid());
    }

    @Override
    public String getElementType() {
        return ElementType.Zip.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.Zip.getXmlName();
    }

    @Override
    public boolean xmlShowRetFalseIsError() {
        return false;
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        return io_ExecuteObject == null ? this : io_ExecuteObject;
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        return io_Params;
    }

    public Map<String, String> createZip(Object i_File, String i_ZipDir, String i_ZipName, String i_Password) {
        if (Help.isNull((String)i_ZipDir)) {
            throw new RuntimeException("Dir is null");
        }
        File v_ZipDir = new File((String)(i_ZipDir.endsWith(Help.getSysPathSeparator()) ? i_ZipDir : i_ZipDir + Help.getSysPathSeparator()));
        if (!v_ZipDir.exists()) {
            v_ZipDir.mkdirs();
        }
        File v_ZipFile = null;
        v_ZipFile = Help.isNull((String)i_ZipName) ? new File(v_ZipDir.getPath() + StringHelp.getUUID9n() + ".zip") : new File(v_ZipDir.getPath() + i_ZipName);
        if (v_ZipFile.exists()) {
            if (!this.overwrite.booleanValue()) {
                throw new RuntimeException("Zip[" + v_ZipFile.getPath() + "] was exists.");
            }
            v_ZipFile.delete();
            $Logger.info("Old Zip file[" + v_ZipFile.getPath() + "] was delete.");
        }
        FileHelp v_FHelp = new FileHelp();
        StringBuilder v_Msg = new StringBuilder();
        try {
            if (i_File == null) {
                throw new RuntimeException("File is null.");
            }
            if (i_File instanceof String) {
                String v_FileString = i_File.toString();
                if (Help.isNull((String)v_FileString)) {
                    throw new RuntimeException("File is null.");
                }
                String[] v_Files = v_FileString.split(";");
                if (v_Files.length <= 1) {
                    File v_File = new File(v_FileString);
                    v_Msg.append(v_File.getPath()).append(" Zip to ").append(v_ZipFile.getPath());
                    v_FHelp.createZip4j(v_ZipFile, v_File, i_Password);
                    if (this.doneDelete.booleanValue()) {
                        v_File.delete();
                    }
                } else {
                    ArrayList<File> v_FileList = new ArrayList<File>();
                    for (String v_Item : v_Files) {
                        File v_File = new File(v_Item);
                        v_FileList.add(v_File);
                        v_Msg.append(v_File.getPath()).append(";");
                    }
                    v_Msg.append(" Zip to ").append(v_ZipFile.getPath());
                    v_FHelp.createZip4j(v_ZipFile, v_FileList, i_Password);
                    if (this.doneDelete.booleanValue()) {
                        for (File v_Item : v_FileList) {
                            v_Item.delete();
                        }
                    }
                }
            } else if (i_File instanceof File) {
                v_File = (File)i_File;
                v_Msg.append(((File)v_File).getPath()).append(" Zip to ").append(v_ZipFile.getPath());
                v_FHelp.createZip4j(v_ZipFile, (File)v_File, i_Password);
                if (this.doneDelete.booleanValue()) {
                    ((File)v_File).delete();
                }
            } else if (i_File instanceof InputStream) {
                v_File = (InputStream)i_File;
                v_Msg.append("InputStream Zip to ").append(v_ZipFile.getPath());
                v_FHelp.createZip4j(v_ZipFile, (InputStream)v_File, i_Password);
                ((InputStream)v_File).close();
            } else {
                throw new RuntimeException("File[" + v_ZipFile.getPath() + "] parameter type is error.");
            }
            v_Msg.append(" is Succeed.");
            $Logger.info(v_Msg.toString());
            HashMap<String, String> v_Ret = new HashMap<String, String>();
            v_Ret.put($Key_DoneFile, v_ZipFile.getPath());
            v_Ret.put($Key_DonePwd, i_Password);
            return v_Ret;
        }
        catch (RuntimeException exce) {
            $Logger.error((Object)exce, v_Msg.toString(), new Object[0]);
            throw exce;
        }
        catch (Exception exce) {
            $Logger.error((Object)exce, v_Msg.toString(), new Object[0]);
            throw new RuntimeException(exce.getMessage(), exce);
        }
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (!Help.isNull((String)this.file.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("file", this.file.getValue()));
        }
        if (!Help.isNull((String)this.dir.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("dir", this.dir.getValue()));
        }
        if (!Help.isNull((String)this.name.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("name", this.name.getValue()));
        }
        if (this.overwrite != null && !this.overwrite.booleanValue()) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("overwrite", this.overwrite));
        }
        if (this.doneDelete != null && this.doneDelete.booleanValue()) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("doneDelete", this.doneDelete));
        }
        if (this.ignoreError != null && this.ignoreError.booleanValue()) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("ignoreError", this.ignoreError));
        }
        if (!Help.isNull((String)this.password.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("password", this.password.getValue()));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.file.getValue())) {
            v_Builder.append(this.file.getValue());
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" to ");
        if (!Help.isNull((String)this.dir.getValue())) {
            v_Builder.append(this.dir.getValue()).append(Help.getSysPathSeparator());
            if (!Help.isNull((String)this.name.getValue())) {
                v_Builder.append(this.name.getValue());
            }
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.file.getValue())) {
            v_Builder.append(this.file.getValue());
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" to ");
        if (!Help.isNull((String)this.dir.getValue())) {
            v_Builder.append(this.dir.getValue()).append(Help.getSysPathSeparator());
            if (!Help.isNull((String)this.name.getValue())) {
                v_Builder.append(this.name.getValue());
            }
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new ZipConfig();
    }

    @Override
    public Object cloneMyOnly() {
        ZipConfig v_Clone = new ZipConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.overwrite = this.overwrite;
        v_Clone.doneDelete = this.doneDelete;
        v_Clone.ignoreError = this.ignoreError;
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ZipConfig xid is null.");
        }
        ZipConfig v_Clone = (ZipConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.overwrite = this.overwrite;
        v_Clone.doneDelete = this.doneDelete;
        v_Clone.ignoreError = this.ignoreError;
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ZipConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        ZipConfig v_Clone = new ZipConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

