/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.file.FileHelp;
import org.hy.common.xml.log.Logger;

public class UnzipConfig
extends NodeConfig
implements NodeConfigBase {
    private static final Logger $Logger = new Logger(UnzipConfig.class);
    private NodeParam file;
    private NodeParam dir;
    private NodeParam password;
    private Boolean doneDelete;

    public UnzipConfig() {
        this(0L, 0L);
    }

    public UnzipConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setCallMethod("unzip");
        this.file = new NodeParam();
        this.file.setValueClass(String.class.getName());
        this.setCallParam(this.file);
        this.dir = new NodeParam();
        this.dir.setValueClass(String.class.getName());
        this.setCallParam(this.dir);
        this.password = new NodeParam();
        this.password.setValueClass(String.class.getName());
        this.setCallParam(this.password);
        this.doneDelete = false;
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getFile())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].file is null.");
            return false;
        }
        return true;
    }

    public String getFile() {
        return this.file.getValue();
    }

    public void setFile(String i_File) {
        this.file.setValue(i_File);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPassword() {
        return this.password.getValue();
    }

    public void setPassword(String i_Password) {
        this.password.setValue(i_Password);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getDir() {
        return this.dir.getValue();
    }

    public void setDir(String i_Dir) {
        this.dir.setValue(i_Dir);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getDoneDelete() {
        return this.doneDelete;
    }

    public void setDoneDelete(Boolean i_DoneDelete) {
        this.doneDelete = i_DoneDelete == null ? false : i_DoneDelete;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public void setXJavaID(String i_Xid) {
        super.setXJavaID(i_Xid);
        this.setCallXID(this.getXid());
    }

    @Override
    public String getElementType() {
        return ElementType.Unzip.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.Unzip.getXmlName();
    }

    @Override
    public boolean xmlShowRetFalseIsError() {
        return false;
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        return io_ExecuteObject == null ? this : io_ExecuteObject;
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        return io_Params;
    }

    public String unzip(String i_ZipFile, String i_UnzipDir, String i_Password) {
        if (Help.isNull((String)i_ZipFile)) {
            throw new RuntimeException("ZipFile is null");
        }
        File v_ZipFile = new File(i_ZipFile);
        if (!v_ZipFile.exists()) {
            throw new RuntimeException("Unzip[" + i_ZipFile + "] is not exists.");
        }
        String v_UnzipDir = i_UnzipDir;
        if (Help.isNull((String)v_UnzipDir)) {
            v_UnzipDir = v_ZipFile.getParent();
        }
        try {
            FileHelp v_FHelp = new FileHelp();
            v_FHelp.UnCompressZip4j(i_ZipFile, v_UnzipDir, i_Password);
            if (this.doneDelete.booleanValue()) {
                v_ZipFile.delete();
            }
            return i_UnzipDir;
        }
        catch (Exception exce) {
            $Logger.error((Object)exce, i_ZipFile + " Unzip to " + i_UnzipDir, new Object[0]);
            throw new RuntimeException(exce.getMessage(), exce);
        }
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (!Help.isNull((String)this.file.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("file", this.file.getValue()));
        }
        if (!Help.isNull((String)this.dir.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("dir", this.dir.getValue()));
        }
        if (this.doneDelete != null && this.doneDelete.booleanValue()) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("doneDelete", this.doneDelete));
        }
        if (!Help.isNull((String)this.password.getValue())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("password", this.password.getValue()));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.file.getValue())) {
            v_Builder.append(this.file.getValue());
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" to ");
        if (!Help.isNull((String)this.dir.getValue())) {
            v_Builder.append(this.dir.getValue());
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.file.getValue())) {
            v_Builder.append(this.file.getValue());
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" to ");
        if (!Help.isNull((String)this.dir.getValue())) {
            v_Builder.append(this.dir.getValue());
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new UnzipConfig();
    }

    @Override
    public Object cloneMyOnly() {
        UnzipConfig v_Clone = new UnzipConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.doneDelete = this.doneDelete;
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone UnzipConfig xid is null.");
        }
        UnzipConfig v_Clone = (UnzipConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.doneDelete = this.doneDelete;
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone UnzipConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        UnzipConfig v_Clone = new UnzipConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

