/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;

public class CommandConfig
extends NodeConfig
implements NodeConfigBase {
    private String command;
    private PartitionMap<String, Integer> commandPlaceholders;
    private Boolean waitProcess;
    private String charEncoding;

    public CommandConfig() {
        this(0L, 0L);
    }

    public CommandConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setWaitProcess(true);
        this.setCharEncoding("UTF-8");
        this.setCallMethod("executeCommand");
        NodeParam v_CallParam = new NodeParam();
        v_CallParam.setValueClass(Long.class.getName());
        v_CallParam.setValue("");
        this.setCallParam(v_CallParam);
        v_CallParam = new NodeParam();
        v_CallParam.setValueClass(String.class.getName());
        v_CallParam.setValue("");
        this.setCallParam(v_CallParam);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getCommand())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].command is null.");
            return false;
        }
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String i_Command) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_Command)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_Command, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.commandPlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.commandPlaceholders = new TablePartitionLink();
        }
        this.command = i_Command;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getWaitProcess() {
        return this.waitProcess;
    }

    public void setWaitProcess(Boolean i_WaitProcess) {
        this.waitProcess = i_WaitProcess;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String i_CharEncoding) {
        this.charEncoding = i_CharEncoding;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public void setXJavaID(String i_Xid) {
        super.setXJavaID(i_Xid);
        this.setCallXID(this.getXid());
    }

    @Override
    public String getElementType() {
        return ElementType.Command.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.Command.getXmlName();
    }

    @Override
    public boolean xmlShowRetFalseIsError() {
        return false;
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        return io_ExecuteObject == null ? this : io_ExecuteObject;
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        if (!Help.isNull((String)this.timeout)) {
            try {
                io_Params[0] = ValueHelp.getValue(this.timeout, Long.class, 0L, io_Context);
            }
            catch (Exception exce) {
                throw new RuntimeException(this.getXid() + " timeout(" + this.timeout + ") error", exce);
            }
        }
        if (!Help.isNull((String)this.command)) {
            io_Params[1] = ValueHelp.replaceByContext(this.command, this.commandPlaceholders, io_Context);
        }
        return io_Params;
    }

    public List<String> executeCommand(Long i_Timeout, String i_Command) {
        if (Help.isNull((String)i_Command)) {
            throw new NullPointerException("Command is null.");
        }
        long v_Timeout = Help.NVL((Long)i_Timeout, (Long)0L) / 1000L;
        if (v_Timeout < 0L) {
            v_Timeout = 0L;
        }
        List v_CmdRet = Help.executeCommand((String)Help.NVL((String)this.charEncoding, (String)"UTF-8"), (boolean)((Boolean)Help.NVL((Object)this.waitProcess, (Object)true)), (!Help.isNull((String)this.getReturnID()) ? 1 : 0) != 0, (long)v_Timeout, (String[])new String[]{i_Command.trim()});
        return v_CmdRet;
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        if (!Help.isNull((String)this.getCommand())) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("command", this.getCommand()));
        }
        if (!Help.isNull((Object)this.getWaitProcess()) && !this.getWaitProcess().booleanValue()) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("waitProcess", this.getWaitProcess()));
        }
        if (!Help.isNull((String)this.getCharEncoding()) && !"UTF-8".equalsIgnoreCase(this.getCharEncoding())) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("charEncoding", this.getCharEncoding()));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder;
        block5: {
            v_Builder = new StringBuilder();
            if (!Help.isNull((String)this.getCommand())) {
                try {
                    String v_Command = ValueHelp.replaceByContext(this.command, this.commandPlaceholders, i_Context);
                    if (Help.isNull((String)v_Command)) {
                        v_Builder.append("?");
                        break block5;
                    }
                    v_Builder.append(v_Command);
                }
                catch (Exception exce) {
                    v_Builder.append(exce.getMessage());
                }
            } else {
                v_Builder.append("?");
            }
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.getCommand())) {
            v_Builder.append(this.getCommand());
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new CommandConfig();
    }

    @Override
    public Object cloneMyOnly() {
        CommandConfig v_Clone = new CommandConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.setComment(this.getComment());
        v_Clone.setWaitProcess(this.getWaitProcess());
        v_Clone.setCharEncoding(this.getCharEncoding());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CommandConfig xid is null.");
        }
        CommandConfig v_Clone = (CommandConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.setComment(this.getComment());
        v_Clone.setWaitProcess(this.getWaitProcess());
        v_Clone.setCharEncoding(this.getCharEncoding());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                NodeParam v_CloneNodeParam = new NodeParam();
                v_NodeParam.clone(v_CloneNodeParam, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.callParams.add(v_CloneNodeParam);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CommandConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        CommandConfig v_Clone = new CommandConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

