/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.nesting;

import java.util.Map;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.Comparer;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.ifelse.ConditionItem;
import org.hy.common.xml.log.Logger;

public class MTItem
extends ConditionItem {
    private static final Logger $Logger = new Logger(MTItem.class);
    private String callFlowXID;
    private String timeout = "0";
    private String context;
    private PartitionMap<String, Integer> contextPlaceholders;
    private String returnID;

    public MTItem() {
    }

    public MTItem(String i_ValueXIDA) {
        super(i_ValueXIDA);
    }

    public MTItem(Comparer i_Comparer, String i_ValueXIDA, String i_ValueXIDB) {
        super(i_Comparer, null, i_ValueXIDA, i_ValueXIDB);
    }

    public MTItem(Comparer i_Comparer, String i_ValueClass, String i_ValueXIDA, String i_ValueXIDB) {
        super(i_Comparer, i_ValueClass, i_ValueXIDA, i_ValueXIDB);
    }

    public String getCallFlowXID() {
        return ValueHelp.standardRefID(this.callFlowXID);
    }

    protected String gatCallFlowXID() {
        return this.callFlowXID;
    }

    public void setCallFlowXID(String i_CallFlowXID) {
        this.callFlowXID = ValueHelp.standardValueID(i_CallFlowXID);
    }

    protected Long gatTimeout(Map<String, Object> i_Context) throws Exception {
        Long v_Timeout = null;
        v_Timeout = Help.isNumber((String)this.timeout) ? Long.valueOf(this.timeout) : (Long)ValueHelp.getValue(this.timeout, Long.class, 0L, i_Context);
        return v_Timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String i_Timeout) {
        if (Help.isNull((String)i_Timeout)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_Timeout)) {
            Long v_Timeout = Long.valueOf(i_Timeout);
            if (v_Timeout < 0L) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.timeout = i_Timeout.trim();
        } else {
            this.timeout = ValueHelp.standardRefID(i_Timeout);
        }
    }

    public String getContext() {
        return this.context;
    }

    public synchronized void setContext(String i_Context) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_Context)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_Context, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.contextPlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.contextPlaceholders = new TablePartitionLink();
        }
        this.context = i_Context;
    }

    protected PartitionMap<String, Integer> getContextPlaceholders() {
        return this.contextPlaceholders;
    }

    public String getReturnID() {
        return this.returnID;
    }

    public void setReturnID(String i_ReturnID) {
        if (CallFlow.isSystemXID(i_ReturnID)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s returnID[" + i_ReturnID + "] is SystemXID.");
        }
        this.returnID = ValueHelp.standardValueID(i_ReturnID);
    }

    public String toXml(int i_Level, String i_SuperTreeID) {
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = "item";
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        if (!Help.isNull((String)this.comment)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("comment", this.comment));
        }
        if (this.valueClass != null) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("valueClass", this.gatValueClass().getName()));
        }
        if (!Help.isNull((String)this.valueXIDA)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("valueXIDA", this.valueXIDA));
        }
        if (this.comparer != null && Comparer.Equal != this.comparer) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("comparer", this.comparer.getValue()));
        }
        if (!Help.isNull((String)this.valueXIDB)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("valueXIDB", this.valueXIDB));
        }
        if (!Help.isNull((String)this.gatCallFlowXID())) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("callFlowXID", this.getCallFlowXID()));
        }
        if (!Help.isNull((String)this.timeout) && !"0".equals(this.timeout)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("timeout", this.timeout));
        }
        if (!Help.isNull((String)this.context)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("context", this.context, v_NewSpace));
        }
        if (!Help.isNull((String)this.returnID)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        return v_Xml.toString();
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (this.comparer != null && !Help.isNull((String)this.valueXIDA)) {
            Object v_ValueA = null;
            Object v_ValueB = null;
            try {
                v_ValueA = ValueHelp.getValue(this.valueXIDA, this.gatValueClass(), null, i_Context);
            }
            catch (Exception exce) {
                $Logger.error("ConditionItem[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s valueXIDA[" + this.valueXIDA + "] getValue error.", (Throwable)exce);
                v_ValueA = "ERROR";
            }
            if (this.valueXIDB == null) {
                v_Builder.append(this.valueXIDA).append("[");
                v_Builder.append(ValueHelp.getExpression(v_ValueA));
                v_Builder.append("]");
                if (Comparer.Equal.equals((Object)this.comparer)) {
                    if (v_ValueA == null) {
                        v_Builder.append(" ").append(this.comparer.getValue()).append(" NULL");
                    } else if (Boolean.class.equals(v_ValueA.getClass())) {
                        v_Builder.append(" ").append(this.comparer.getValue()).append(" TRUE");
                    } else {
                        v_Builder.append(" ").append(this.comparer.getValue()).append(" NULL");
                    }
                } else if (Comparer.EqualNot.equals((Object)this.comparer)) {
                    if (v_ValueA == null) {
                        v_Builder.append(" ").append(this.comparer.getValue()).append(" NULL");
                    } else if (Boolean.class.equals(v_ValueA.getClass())) {
                        v_Builder.append(" ").append(this.comparer.getValue()).append(" TRUE");
                    } else {
                        v_Builder.append(" ").append(this.comparer.getValue()).append(" NULL");
                    }
                } else {
                    v_Builder.append(" != NULL");
                }
            } else {
                try {
                    v_ValueB = ValueHelp.getValue(this.valueXIDB, this.gatValueClass(), null, i_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ConditionItem[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s valueXIDB[" + this.valueXIDB + "] getValue error.", (Throwable)exce);
                    v_ValueB = "ERROR";
                }
                v_Builder.append(ValueHelp.getExpression(v_ValueA));
                v_Builder.append(" ").append(this.comparer.getValue()).append(" ");
                v_Builder.append(ValueHelp.getExpression(v_ValueB));
            }
            v_Builder.append(" ");
        }
        v_Builder.append("TO ").append(Help.NVL((String)this.callFlowXID));
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (this.comparer != null && !Help.isNull((String)this.valueXIDA)) {
            v_Builder.append(this.valueXIDA == null ? "NULL" : ValueHelp.getExpression(this.valueXIDA, this.gatValueClass()));
            v_Builder.append(" ").append(this.comparer.getValue()).append(" ");
            v_Builder.append(this.valueXIDA == null ? "NULL" : ValueHelp.getExpression(this.valueXIDB, this.gatValueClass()));
            v_Builder.append(" ");
        }
        v_Builder.append("TO ").append(Help.NVL((String)this.callFlowXID));
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new MTItem();
    }

    @Override
    public Object cloneMyOnly() {
        MTItem v_Clone = new MTItem();
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.comparer = this.comparer;
        v_Clone.valueClass = this.valueClass;
        v_Clone.valueXIDA = this.valueXIDA;
        v_Clone.valueXIDB = this.valueXIDB;
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.timeout = this.timeout;
        v_Clone.context = this.context;
        v_Clone.returnID = this.returnID;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        MTItem v_Clone = (MTItem)io_Clone;
        v_Clone.xid = this.cloneXID(this.xid, i_ReplaceXID, i_ReplaceByXID, i_AppendXID);
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.comparer = this.comparer;
        v_Clone.valueClass = this.valueClass;
        v_Clone.valueXIDA = this.valueXIDA;
        v_Clone.valueXIDB = this.valueXIDB;
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.timeout = this.timeout;
        v_Clone.context = this.context;
        v_Clone.returnID = this.returnID;
    }
}

