/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.language;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.language.shell.ShellFile;
import org.hy.common.callflow.language.shell.ShellResult;
import org.hy.common.xml.log.Logger;

public class ShellConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(ShellConfig.class, Boolean.valueOf(true));
    private String initXID;
    private String host;
    private String port = "22";
    private String connectTimeout = "0";
    private String timeout = "0";
    private String user;
    private String password;
    private String shell;
    private PartitionMap<String, Integer> shellPlaceholders;
    private String upFile;
    private PartitionMap<String, Integer> upFilePlaceholders;
    private String downFile;
    private PartitionMap<String, Integer> downFilePlaceholders;
    private Boolean showLog = null;

    public ShellConfig() {
        this(0L, 0L);
    }

    public ShellConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.initXID)) {
            if (Help.isNull((String)this.getHost())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].host is null.");
                return false;
            }
            if (Help.isNull((String)this.getUser())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].user is null.");
                return false;
            }
            if (Help.isNull((String)this.getShell()) && Help.isNull((String)this.getUpFile()) && Help.isNull((String)this.getDownFile())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].shell\u3001upFile and downFile is null.");
                return false;
            }
        }
        return true;
    }

    public String getInitXID() {
        return ValueHelp.standardRefID(this.initXID);
    }

    public void setInitXID(String i_InitXID) {
        this.initXID = ValueHelp.standardValueID(i_InitXID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private String gatHost(Map<String, Object> i_Context) throws Exception {
        String v_Host = this.host;
        if (Help.isNull((String)v_Host) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_Host = v_Shell == null ? null : v_Shell.getHost();
        }
        return (String)ValueHelp.getValue(v_Host, String.class, "", i_Context);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String i_Host) {
        this.host = i_Host;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private Integer gatPort(Map<String, Object> i_Context) throws Exception {
        String v_Port = this.port;
        if ((Help.isNull((String)v_Port) || "0".equals(v_Port) || "22".equals(v_Port)) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_Port = v_Shell == null ? null : v_Shell.getPort();
        }
        Integer v_PortInt = null;
        v_PortInt = Help.isNumber((String)v_Port) ? Integer.valueOf(v_Port) : (Integer)ValueHelp.getValue(v_Port, Integer.class, 0, i_Context);
        return v_PortInt;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String i_Port) {
        if (Help.isNull((String)i_Port)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s port is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_Port)) {
            Integer v_Timeout = Integer.valueOf(i_Port);
            if (v_Timeout < 0) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s port Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            if (v_Timeout > 65535) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s port Greater than 65535.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.port = i_Port.trim();
        } else {
            this.port = ValueHelp.standardRefID(i_Port);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private Integer gatConnectTimeout(Map<String, Object> i_Context) throws Exception {
        String v_ConnectTimeout = this.connectTimeout;
        if ((Help.isNull((String)v_ConnectTimeout) || "0".equals(v_ConnectTimeout)) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_ConnectTimeout = v_Shell == null ? null : v_Shell.getConnectTimeout();
        }
        Integer v_ConnectTimeoutInt = null;
        v_ConnectTimeoutInt = Help.isNumber((String)v_ConnectTimeout) ? Integer.valueOf(v_ConnectTimeout) : (Integer)ValueHelp.getValue(v_ConnectTimeout, Integer.class, 0, i_Context);
        return v_ConnectTimeoutInt;
    }

    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(String i_ConnectTimeout) {
        if (Help.isNull((String)i_ConnectTimeout)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s connectTimeout is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_ConnectTimeout)) {
            Integer v_Timeout = Integer.valueOf(i_ConnectTimeout);
            if (v_Timeout < 0) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s connectTimeout Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.connectTimeout = i_ConnectTimeout.trim();
        } else {
            this.connectTimeout = ValueHelp.standardRefID(i_ConnectTimeout);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private Integer gatTimeout(Map<String, Object> i_Context) throws Exception {
        String v_Timeout = this.timeout;
        if ((Help.isNull((String)v_Timeout) || "0".equals(v_Timeout)) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_Timeout = v_Shell == null ? null : v_Shell.getTimeout();
        }
        Integer v_TimeoutInt = null;
        v_TimeoutInt = Help.isNumber((String)v_Timeout) ? Integer.valueOf(v_Timeout) : (Integer)ValueHelp.getValue(v_Timeout, Integer.class, 0, i_Context);
        return v_TimeoutInt;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String i_Timeout) {
        if (Help.isNull((String)i_Timeout)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_Timeout)) {
            Integer v_Timeout = Integer.valueOf(i_Timeout);
            if (v_Timeout < 0) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.timeout = i_Timeout.trim();
        } else {
            this.timeout = ValueHelp.standardRefID(i_Timeout);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private String gatUser(Map<String, Object> i_Context) throws Exception {
        String v_User = this.user;
        if (Help.isNull((String)v_User) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_User = v_Shell == null ? null : v_Shell.getUser();
        }
        return (String)ValueHelp.getValue(v_User, String.class, "", i_Context);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String i_User) {
        this.user = i_User;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private String gatPassword(Map<String, Object> i_Context) throws Exception {
        String v_Password = this.password;
        if (Help.isNull((String)v_Password) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_Password = v_Shell == null ? null : v_Shell.getPassword();
        }
        return (String)ValueHelp.getValue(v_Password, String.class, "", i_Context);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String i_Password) {
        this.password = i_Password;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getShell() {
        return this.shell;
    }

    public void setShell(String i_Shell) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_Shell)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_Shell, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.shellPlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.shellPlaceholders = new TablePartitionLink();
        }
        this.shell = i_Shell;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getUpFile() {
        return this.upFile;
    }

    public void setUpFile(String i_UpFile) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_UpFile)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_UpFile, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.upFilePlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.upFilePlaceholders = new TablePartitionLink();
        }
        this.upFile = i_UpFile;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getDownFile() {
        return this.downFile;
    }

    public void setDownFile(String i_DownFile) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_DownFile)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_DownFile, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.downFilePlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.downFilePlaceholders = new TablePartitionLink();
        }
        this.downFile = i_DownFile;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private Boolean gatShowLog(Map<String, Object> i_Context) throws Exception {
        Boolean v_ShowLog = this.showLog;
        if (Help.isNull((Object)v_ShowLog) && !Help.isNull((String)this.initXID)) {
            ShellConfig v_Shell = (ShellConfig)ValueHelp.getValue(this.getInitXID(), ShellConfig.class, null, i_Context);
            v_ShowLog = v_Shell == null ? null : v_Shell.getShowLog();
        }
        return v_ShowLog;
    }

    public Boolean getShowLog() {
        return this.showLog;
    }

    public void setShowLog(Boolean i_ShowLog) {
        this.showLog = i_ShowLog;
    }

    @Override
    public String getElementType() {
        return ElementType.Shell.getValue();
    }

    private List<ShellFile> parserUpFile(Map<String, Object> i_Context) {
        if (!Help.isNull((String)this.upFile)) {
            String v_UpFile = ValueHelp.replaceByContext(this.upFile, this.upFilePlaceholders, i_Context);
            String v_Temp = StringHelp.replaceAll((String)v_UpFile, (String)"\r\n", (String)"\n");
            String[] v_Files = StringHelp.split((String)v_Temp, (String)"\n");
            ArrayList<ShellFile> v_Ret = new ArrayList<ShellFile>();
            for (String v_Item : v_Files) {
                if (Help.isNull((String)v_Item)) continue;
                String[] v_FileAndDir = v_Item.trim().split(",");
                ShellFile v_ShellFile = new ShellFile(v_FileAndDir[0].trim(), v_FileAndDir[1].trim());
                File v_LocalFile = new File(v_ShellFile.getFile());
                if (!v_LocalFile.exists()) {
                    throw new RuntimeException("File[" + v_ShellFile.getFile() + "] is not exists.");
                }
                if (!v_LocalFile.canRead()) {
                    throw new RuntimeException("File[" + v_ShellFile.getFile() + "] can not read.");
                }
                v_Ret.add(v_ShellFile);
            }
            return v_Ret;
        }
        return null;
    }

    private List<ShellFile> parserDownFile(Map<String, Object> i_Context) {
        if (!Help.isNull((String)this.downFile)) {
            String v_DownFile = ValueHelp.replaceByContext(this.downFile, this.downFilePlaceholders, i_Context);
            String v_Temp = StringHelp.replaceAll((String)v_DownFile, (String)"\r\n", (String)"\n");
            String[] v_Files = StringHelp.split((String)v_Temp, (String)"\n");
            ArrayList<ShellFile> v_Ret = new ArrayList<ShellFile>();
            for (String v_Item : v_Files) {
                if (Help.isNull((String)v_Item)) continue;
                String[] v_FileAndDir = v_Item.trim().split(",");
                ShellFile v_ShellFile = new ShellFile(v_FileAndDir[0].trim(), v_FileAndDir[1].trim());
                File v_LocalDir = new File(v_ShellFile.getDir());
                if (!v_LocalDir.exists()) {
                    v_LocalDir.mkdirs();
                }
                v_Ret.add(v_ShellFile);
            }
            return v_Ret;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        if (Help.isNull((String)this.shell) && Help.isNull((String)this.upFile) && Help.isNull((String)this.downFile)) {
            v_Result.setException(new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s shell\u3001upFile and downFile is null."));
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
        try (SSHClient v_SSH = new SSHClient();){
            if (!this.handleContext(io_Context, v_Result)) {
                ExecuteResult executeResult = v_Result;
                return executeResult;
            }
            ShellResult v_ShellRet = new ShellResult();
            List<ShellFile> v_UpFiles = this.parserUpFile(io_Context);
            SCPFileTransfer v_SCP = null;
            String v_Host = this.gatHost(io_Context);
            Integer v_Port = this.gatPort(io_Context);
            String v_User = this.gatUser(io_Context);
            String v_Password = this.gatPassword(io_Context);
            Integer v_ConnectTime = this.gatConnectTimeout(io_Context);
            Integer v_Time = this.gatTimeout(io_Context);
            Boolean v_ShowLog = this.gatShowLog(io_Context);
            if (Help.isNull((String)v_Host)) {
                v_Result.setException(new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s host[" + this.host + "] is not find."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                ExecuteResult executeResult = v_Result;
                return executeResult;
            }
            if (Help.isNull((String)v_User)) {
                v_Result.setException(new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s user[" + this.user + "] is not find."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                ExecuteResult executeResult = v_Result;
                return executeResult;
            }
            if (v_ConnectTime > 0) {
                v_SSH.setConnectTimeout(v_ConnectTime.intValue());
            }
            if (v_Time > 0) {
                v_SSH.setTimeout(v_Time.intValue());
            }
            v_SSH.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            if (v_Port > 0 && v_Port != 22) {
                v_SSH.connect(v_Host, v_Port.intValue());
            } else {
                v_SSH.connect(v_Host);
            }
            if (!Help.isNull((String)v_Password)) {
                v_SSH.authPassword(v_User, v_Password);
            } else {
                Iterator<ShellFile> v_PrivateKeyPath = System.getProperty("user.home") + "/.ssh/id_rsa";
                KeyProvider v_KeyProvider = v_SSH.loadKeys((String)((Object)v_PrivateKeyPath));
                v_SSH.authPublickey(v_User, new KeyProvider[]{v_KeyProvider});
            }
            if (!Help.isNull(v_UpFiles)) {
                for (ShellFile v_UpFile : v_UpFiles) {
                    Session v_Session = v_SSH.startSession();
                    try {
                        Session.Command v_Command = v_Session.exec("mkdir -p " + v_UpFile.getDir());
                        try {
                            this.showLog(v_ShowLog, v_Command);
                            v_Command.join();
                        }
                        finally {
                            if (v_Command == null) continue;
                            v_Command.close();
                        }
                    }
                    finally {
                        if (v_Session == null) continue;
                        v_Session.close();
                    }
                }
                v_SCP = v_SSH.newSCPFileTransfer();
                for (ShellFile v_UpFile : v_UpFiles) {
                    v_SCP.upload((LocalSourceFile)new FileSystemFile(v_UpFile.getFile()), v_UpFile.getDir());
                }
                v_ShellRet.setUpFiles(v_UpFiles);
            }
            if (!Help.isNull((String)this.shell)) {
                String v_Shell = ValueHelp.replaceByContext(this.shell, this.shellPlaceholders, io_Context);
                try (Session v_Session = v_SSH.startSession();
                     Session.Command v_Command = v_Session.exec(v_Shell);){
                    ByteArrayOutputStream v_Output = null;
                    StringBuilder v_Log = this.showLog(v_ShowLog, v_Command);
                    if (v_Log == null) {
                        v_Output = new ByteArrayOutputStream();
                        v_Command.getInputStream().transferTo(v_Output);
                    }
                    v_Command.join();
                    v_ShellRet.setExitStatus(v_Command.getExitStatus());
                    if (v_Log == null) {
                        v_ShellRet.setResult(v_Output.toString().trim());
                        v_Output.close();
                    } else {
                        v_ShellRet.setResult(v_Log.toString());
                    }
                }
            }
            if (!Help.isNull((String)this.downFile)) {
                List<ShellFile> v_DownFiles = this.parserDownFile(io_Context);
                if (v_SCP == null) {
                    v_SCP = v_SSH.newSCPFileTransfer();
                }
                for (ShellFile v_DownFile : v_DownFiles) {
                    v_SCP.download(v_DownFile.getFile(), (LocalDestFile)new FileSystemFile(v_DownFile.getDir()));
                }
                v_ShellRet.setDownFiles(v_DownFiles);
            }
            v_Result.setResult(v_ShellRet);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            ExecuteResult executeResult = v_Result;
            return executeResult;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    private StringBuilder showLog(Boolean i_ShowLog, Session.Command i_Command) {
        if (i_ShowLog == null || !i_ShowLog.booleanValue()) {
            return null;
        }
        StringBuilder v_Log = new StringBuilder();
        new Thread(() -> {
            try (InputStream v_Input = i_Command.getInputStream();
                 BufferedReader v_Reader = new BufferedReader(new InputStreamReader(v_Input));){
                String v_Line = null;
                while ((v_Line = v_Reader.readLine()) != null) {
                    v_Log.append(v_Line).append("\r\n");
                    $Logger.info(this.getXid() + "[INFO] " + v_Line);
                }
            }
            catch (Exception error) {
                $Logger.error((Throwable)error);
            }
        }).start();
        new Thread(() -> {
            try (InputStream v_ErrorInput = i_Command.getErrorStream();
                 BufferedReader v_Reader = new BufferedReader(new InputStreamReader(v_ErrorInput));){
                String v_Line = null;
                while ((v_Line = v_Reader.readLine()) != null) {
                    v_Log.append(v_Line).append("\r\n");
                    $Logger.info(this.getXid() + "[WARN] " + v_Line);
                }
            }
            catch (Exception error) {
                $Logger.error((Throwable)error);
            }
        }).start();
        return v_Log;
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Shell.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            String v_Webhome;
            String v_Classhome;
            if (!Help.isNull((String)this.initXID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("initXID", this.getInitXID()));
            }
            if (!Help.isNull((String)this.host)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("host", this.host));
            }
            if (!(Help.isNull((String)this.port) || "0".equals(this.port) || "22".equals(this.port))) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("port", this.port));
            }
            if (!Help.isNull((String)this.connectTimeout) && !"0".equals(this.connectTimeout)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("connectTimeout", this.connectTimeout));
            }
            if (!Help.isNull((String)this.timeout) && !"0".equals(this.timeout)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("timeout", this.timeout));
            }
            if (!Help.isNull((String)this.user)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("user", this.user));
            }
            if (!Help.isNull((String)this.password)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("password", this.password));
            }
            if (!Help.isNull((String)this.upFile)) {
                v_Classhome = Help.getClassHomePath();
                v_Webhome = Help.getWebHomePath();
                String v_UpFile = this.upFile;
                if (v_UpFile.indexOf(v_Classhome) >= 0) {
                    v_UpFile = StringHelp.replaceAll((String)v_UpFile, (String)v_Classhome, (String)"classhome:");
                }
                if (v_UpFile.indexOf(v_Webhome) >= 0) {
                    v_UpFile = StringHelp.replaceAll((String)v_UpFile, (String)v_Webhome, (String)"webhome:");
                }
                v_Xml.append(v_NewSpace).append(IToXml.toValue("upFile", v_UpFile));
            }
            if (!Help.isNull((String)this.shell)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("shell", this.shell));
            }
            if (!Help.isNull((String)this.downFile)) {
                v_Classhome = Help.getClassHomePath();
                v_Webhome = Help.getWebHomePath();
                String v_DownFile = this.downFile;
                if (v_DownFile.indexOf(v_Classhome) >= 0) {
                    v_DownFile = StringHelp.replaceAll((String)v_DownFile, (String)v_Classhome, (String)"classhome:");
                }
                if (v_DownFile.indexOf(v_Webhome) >= 0) {
                    v_DownFile = StringHelp.replaceAll((String)v_DownFile, (String)v_Webhome, (String)"webhome:");
                }
                v_Xml.append(v_NewSpace).append(IToXml.toValue("downFile", v_DownFile));
            }
            if (!Help.isNull((Object)this.showLog)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("showLog", this.showLog));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        String v_User = this.user;
        String v_Host = this.host;
        try {
            v_User = this.gatUser(i_Context);
            v_Host = this.gatHost(i_Context);
        }
        catch (Exception exce) {
            $Logger.error("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "].toString is error", (Throwable)exce);
        }
        v_Builder.append("ssh ");
        if (!Help.isNull((String)v_User)) {
            v_Builder.append(v_User);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append("@");
        if (!Help.isNull((String)v_Host)) {
            v_Builder.append(v_Host);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" ");
        if (!Help.isNull((String)this.shell)) {
            String v_Shell = ValueHelp.replaceByContext(this.shell.trim(), this.shellPlaceholders, i_Context).trim();
            v_Builder.append(StringHelp.replaceAll((String)v_Shell, (String[])new String[]{"\r", "\n"}, (String[])StringHelp.$ReplaceSpace));
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("ssh ");
        if (!Help.isNull((String)this.user)) {
            v_Builder.append(this.user);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append("@");
        if (!Help.isNull((String)this.host)) {
            v_Builder.append(this.host);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" ");
        if (!Help.isNull((String)this.shell)) {
            v_Builder.append(this.shell);
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new ShellConfig();
    }

    @Override
    public Object cloneMyOnly() {
        ShellConfig v_Clone = new ShellConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.initXID = this.initXID;
        v_Clone.host = this.host;
        v_Clone.port = this.port;
        v_Clone.connectTimeout = this.connectTimeout;
        v_Clone.timeout = this.timeout;
        v_Clone.user = this.user;
        v_Clone.password = this.password;
        v_Clone.shell = this.shell;
        v_Clone.upFile = this.upFile;
        v_Clone.downFile = this.downFile;
        v_Clone.showLog = this.showLog;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ShellConfig xid is null.");
        }
        ShellConfig v_Clone = (ShellConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.initXID = this.initXID;
        v_Clone.host = this.host;
        v_Clone.port = this.port;
        v_Clone.connectTimeout = this.connectTimeout;
        v_Clone.timeout = this.timeout;
        v_Clone.user = this.user;
        v_Clone.password = this.password;
        v_Clone.shell = this.shell;
        v_Clone.upFile = this.upFile;
        v_Clone.downFile = this.downFile;
        v_Clone.showLog = this.showLog;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ShellConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        ShellConfig v_Clone = new ShellConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

