/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jep.SubInterpreter;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.fraction.Fraction;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.xml.XJSON;

public class PythonConfig
extends ExecuteElement
implements Cloneable {
    private String in;
    private String script;
    private List<String> pythonyScripts;
    private String python;
    private String pythonCode;
    private String out;
    private Map<String, String> outMap;
    private String charEncoding;

    public PythonConfig() {
        this(0L, 0L);
    }

    public PythonConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getPython()) && Help.isNull((String)this.getScript())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].script and python is null.");
            return false;
        }
        return true;
    }

    public String getIn() {
        return this.in;
    }

    public void setIn(String i_In) {
        this.in = i_In;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String i_Script) {
        this.script = i_Script;
        this.pythonyScripts = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPython() {
        return this.python;
    }

    public void setPython(String i_Python) {
        this.python = i_Python;
        this.pythonCode = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getOut() {
        return this.out;
    }

    public void setOut(String i_Out) {
        this.out = i_Out;
        this.outMap = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String i_CharEncoding) {
        this.charEncoding = i_CharEncoding;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String getElementType() {
        return ElementType.Python.getValue();
    }

    private Map<String, Object> parserIn(Map<String, Object> i_Context) throws Exception {
        XJSON v_XJson;
        Map v_JDatas;
        HashMap<String, Object> v_In = new HashMap<String, Object>();
        if (!Help.isNull((String)this.in) && !Help.isNull((Map)(v_JDatas = (Map)(v_XJson = new XJSON()).toJava(this.in)))) {
            for (Map.Entry v_Item : v_JDatas.entrySet()) {
                String v_Value;
                if (v_Item.getValue() instanceof String && ValueHelp.isXID(v_Value = v_Item.getValue().toString().trim())) {
                    Object v_Obj = ValueHelp.getValue(v_Value, null, null, i_Context);
                    v_In.put((String)v_Item.getKey(), v_Obj);
                    continue;
                }
                v_In.put((String)v_Item.getKey(), v_Item.getValue());
            }
        }
        return v_In;
    }

    private synchronized List<String> parserScript() {
        if (!Help.isNull((String)this.script) && this.pythonyScripts == null) {
            String v_Temp = StringHelp.replaceAll((String)this.script, (String)"\r\n", (String)"\n");
            String[] v_Scripts = StringHelp.split((String)v_Temp, (String)"\n");
            this.pythonyScripts = new ArrayList<String>();
            for (String v_Item : v_Scripts) {
                String v_PY = v_Item.trim();
                if (Help.isNull((String)v_PY)) continue;
                this.pythonyScripts.add(v_PY);
            }
        }
        return this.pythonyScripts;
    }

    private synchronized String parserPython() {
        if (!Help.isNull((String)this.python) && this.pythonCode == null) {
            String v_Temp;
            int v_First = this.python.indexOf("\n");
            String v_Python = this.python;
            if (v_First == 0) {
                v_Python = v_Python.substring(1);
            } else if (v_First > 0 && "".equals((v_Temp = v_Python.substring(0, v_First)).trim())) {
                v_Python = v_Python.substring(v_First + 1);
            }
            v_Temp = v_Python.replaceAll("^\\s+", "");
            int v_LPad = v_Python.length() - v_Temp.length();
            if (v_LPad > 0) {
                v_Python = v_Python.trim().replaceAll("(?<=\\n)\\s+(?=\\n)", StringHelp.lpad((String)"", (int)v_LPad, (String)" "));
                v_Python = v_Python.replaceAll("(\\n)\\s{1," + v_LPad + "}", "$1");
            } else {
                v_Python = v_Python.trim();
            }
            this.pythonCode = v_Python;
        }
        return this.pythonCode;
    }

    private synchronized Map<String, String> parserOut() {
        if (!Help.isNull((String)this.out) && this.outMap == null) {
            XJSON v_XJson = new XJSON();
            this.outMap = (Map)v_XJson.toJava(this.out);
        }
        return this.outMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        if (Help.isNull((String)this.python) && Help.isNull((String)this.script)) {
            v_Result.setException(new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s python and script is null."));
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
        try (SubInterpreter v_Jep = new SubInterpreter();){
            if (!this.handleContext(io_Context, v_Result)) {
                ExecuteResult executeResult = v_Result;
                return executeResult;
            }
            Map<String, Object> v_In = this.parserIn(io_Context);
            List<String> v_Scripts = this.parserScript();
            String v_Python = this.parserPython();
            Map<String, String> v_Out = this.parserOut();
            HashMap<String, Object> v_Ret = new HashMap<String, Object>();
            if (!Help.isNull(v_In)) {
                for (Map.Entry<String, Object> entry : v_In.entrySet()) {
                    v_Jep.set(entry.getKey(), entry.getValue());
                }
                v_In.clear();
            }
            if (!Help.isNull((String)this.charEncoding)) {
                v_Jep.exec("import sys");
                v_Jep.exec("import io");
                v_Jep.exec("sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='" + this.charEncoding + "')");
                v_Jep.exec("sys.stderr = io.TextIOWrapper(sys.stderr.buffer, encoding='" + this.charEncoding + "')");
            }
            if (!Help.isNull(v_Scripts)) {
                for (String string : v_Scripts) {
                    v_Jep.runScript(string);
                }
            }
            if (!Help.isNull((String)v_Python)) {
                v_Jep.exec(v_Python);
            }
            if (!Help.isNull(v_Out)) {
                for (Map.Entry entry : v_Out.entrySet()) {
                    String v_Type = v_Jep.getValue("type(" + (String)entry.getKey() + ").__name__").toString();
                    if ("Fraction".equals(v_Type)) {
                        Long v_Numerator = (Long)v_Jep.getValue((String)entry.getKey() + ".numerator");
                        Long v_Denominator = (Long)v_Jep.getValue((String)entry.getKey() + ".denominator");
                        v_Ret.put((String)entry.getValue(), new Fraction(v_Numerator.intValue(), v_Denominator.intValue()));
                        continue;
                    }
                    if ("complex".equals(v_Type)) {
                        double v_Real = (Double)v_Jep.getValue((String)entry.getKey() + ".real");
                        double v_Imaginary = (Double)v_Jep.getValue((String)entry.getKey() + ".imag");
                        v_Ret.put((String)entry.getValue(), new Complex(v_Real, v_Imaginary));
                        continue;
                    }
                    Object v_Value = v_Jep.getValue((String)entry.getKey());
                    v_Ret.put((String)entry.getValue(), v_Value);
                }
            }
            v_Result.setResult(v_Ret);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            ExecuteResult executeResult = v_Result;
            return executeResult;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Python.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.charEncoding)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("charEncoding", this.charEncoding));
            }
            if (!Help.isNull((String)this.in)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("in", this.in, v_NewSpace));
            }
            if (!Help.isNull((String)this.script)) {
                String v_Classhome = Help.getClassHomePath();
                String v_Webhome = Help.getWebHomePath();
                String v_Script = this.script;
                if (v_Script.indexOf(v_Classhome) >= 0) {
                    v_Script = StringHelp.replaceAll((String)v_Script, (String)v_Classhome, (String)"classhome:");
                }
                if (v_Script.indexOf(v_Webhome) >= 0) {
                    v_Script = StringHelp.replaceAll((String)v_Script, (String)v_Webhome, (String)"webhome:");
                }
                v_Xml.append(v_NewSpace).append(IToXml.toValue("script", v_Script));
            }
            if (!Help.isNull((String)this.python)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("python", this.python));
            }
            if (!Help.isNull((String)this.out)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("out", this.out, v_NewSpace));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        Map<String, Object> v_In = null;
        try {
            v_In = this.parserIn(i_Context);
        }
        catch (Exception exce) {
            v_Builder.append("Error input parameters");
        }
        if (!Help.isNull(v_In)) {
            for (Map.Entry<String, Object> v_Item : v_In.entrySet()) {
                v_Builder.append(v_Item.getKey()).append("=").append(v_Item.getValue()).append(" ");
            }
            v_In.clear();
        } else {
            v_Builder.append("No input parameters");
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.in)) {
            v_Builder.append(this.in);
        } else {
            v_Builder.append("No input parameters");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new PythonConfig();
    }

    @Override
    public Object cloneMyOnly() {
        PythonConfig v_Clone = new PythonConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.charEncoding = this.charEncoding;
        v_Clone.in = this.in;
        v_Clone.script = this.script;
        v_Clone.python = this.python;
        v_Clone.out = this.out;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone PythonConfig xid is null.");
        }
        PythonConfig v_Clone = (PythonConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.charEncoding = this.charEncoding;
        v_Clone.in = this.in;
        v_Clone.script = this.script;
        v_Clone.python = this.python;
        v_Clone.out = this.out;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone PythonConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        PythonConfig v_Clone = new PythonConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

