/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.language;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.hy.common.ByteHelp;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.app.Param;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;

public class GroovyConfig
extends ExecuteElement
implements Cloneable {
    private String in;
    private String script;
    private List<File> groovyScripts;
    private String groovy;
    private String groovyScript;
    private String out;
    private Map<String, String> outMap;

    public GroovyConfig() {
        this(0L, 0L);
    }

    public GroovyConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getGroovy()) && Help.isNull((String)this.getScript())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].script and groovy is null.");
            return false;
        }
        return true;
    }

    public String getIn() {
        return this.in;
    }

    public void setIn(String i_In) {
        this.in = i_In;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String i_Script) {
        this.script = i_Script;
        this.groovyScripts = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getGroovy() {
        return this.groovy;
    }

    public void setGroovy(String i_Groovy) {
        this.groovy = i_Groovy;
        this.groovyScript = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getOut() {
        return this.out;
    }

    public void setOut(String i_Out) {
        this.out = i_Out;
        this.outMap = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String getElementType() {
        return ElementType.Groovy.getValue();
    }

    private Map<String, Object> parserIn(Map<String, Object> i_Context) throws Exception {
        XJSON v_XJson;
        Map v_JDatas;
        HashMap<String, Object> v_In = new HashMap<String, Object>();
        if (!Help.isNull((String)this.in) && !Help.isNull((Map)(v_JDatas = (Map)(v_XJson = new XJSON()).toJava(this.in)))) {
            for (Map.Entry v_Item : v_JDatas.entrySet()) {
                String v_Value;
                if (v_Item.getValue() instanceof String && ValueHelp.isXID(v_Value = v_Item.getValue().toString().trim())) {
                    Object v_Obj = ValueHelp.getValue(v_Value, null, null, i_Context);
                    v_In.put((String)v_Item.getKey(), v_Obj);
                    continue;
                }
                v_In.put((String)v_Item.getKey(), v_Item.getValue());
            }
        }
        return v_In;
    }

    private synchronized List<Script> parserScript(GroovyShell i_Shell) throws CompilationFailedException, IOException {
        if (!Help.isNull((String)this.script)) {
            if (this.groovyScripts == null) {
                String v_Temp = StringHelp.replaceAll((String)this.script, (String)"\r\n", (String)"\n");
                String[] v_Scripts = StringHelp.split((String)v_Temp, (String)"\n");
                this.groovyScripts = new ArrayList<File>();
                for (String v_Script : v_Scripts) {
                    if (Help.isNull((String)v_Script)) continue;
                    this.groovyScripts.add(new File(v_Script.trim()));
                }
            }
            for (File v_Script : this.groovyScripts) {
                i_Shell.parse(v_Script);
            }
        }
        return null;
    }

    private synchronized Script parserGroovy(GroovyShell i_Shell) {
        if (!Help.isNull((String)this.groovy)) {
            if (this.groovyScript == null) {
                StringBuilder v_Import = new StringBuilder();
                v_Import.append("import ").append(Help.class.getName()).append(";\n");
                v_Import.append("import ").append(StringHelp.class.getName()).append(";\n");
                v_Import.append("import ").append(ByteHelp.class.getName()).append(";\n");
                v_Import.append("import ").append(Date.class.getName()).append(";\n");
                v_Import.append("import ").append(Return.class.getName()).append(";\n");
                v_Import.append("import ").append(Param.class.getName()).append(";\n");
                v_Import.append("import ").append(XJava.class.getName()).append(";\n");
                v_Import.append("import ").append(XJSON.class.getName()).append(";\n");
                v_Import.append("import ").append(List.class.getName()).append(";\n");
                v_Import.append("import ").append(ArrayList.class.getName()).append(";\n");
                v_Import.append("import ").append(Map.class.getName()).append(";\n");
                v_Import.append("import ").append(HashMap.class.getName()).append(";\n");
                v_Import.append("import ").append(Hashtable.class.getName()).append(";\n");
                v_Import.append(this.groovy);
                this.groovyScript = v_Import.toString();
            }
            return i_Shell.parse(this.groovyScript);
        }
        return null;
    }

    private synchronized Map<String, String> parserOut() {
        if (!Help.isNull((String)this.out) && this.outMap == null) {
            XJSON v_XJson = new XJSON();
            this.outMap = (Map)v_XJson.toJava(this.out);
        }
        return this.outMap;
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        if (Help.isNull((String)this.groovy) && Help.isNull((String)this.script)) {
            v_Result.setException(new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s groovy and script is null."));
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            Binding v_Binding = new Binding();
            GroovyShell v_Shell = new GroovyShell(v_Binding);
            Map<String, Object> v_In = this.parserIn(io_Context);
            List<Script> v_Scripts = this.parserScript(v_Shell);
            Script v_Groovy = this.parserGroovy(v_Shell);
            Map<String, String> v_Out = this.parserOut();
            HashMap<String, Object> v_Ret = new HashMap<String, Object>();
            if (!Help.isNull(v_In)) {
                for (Map.Entry<String, Object> entry : v_In.entrySet()) {
                    v_Binding.setVariable(entry.getKey(), entry.getValue());
                }
                v_In.clear();
            }
            if (!Help.isNull(v_Scripts)) {
                for (Script script : v_Scripts) {
                    script.run();
                }
            }
            if (v_Groovy != null) {
                v_Groovy.run();
            }
            if (!Help.isNull(v_Out)) {
                for (Map.Entry<String, Object> entry : v_Out.entrySet()) {
                    Object v_Value = v_Binding.getVariable(entry.getKey());
                    v_Ret.put((String)entry.getValue(), v_Value);
                }
            }
            v_Result.setResult(v_Ret);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Groovy.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.in)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("in", this.in, v_NewSpace));
            }
            if (!Help.isNull((String)this.script)) {
                String v_Classhome = Help.getClassHomePath();
                String v_Webhome = Help.getWebHomePath();
                String v_Script = this.script;
                if (v_Script.indexOf(v_Classhome) >= 0) {
                    v_Script = StringHelp.replaceAll((String)v_Script, (String)v_Classhome, (String)"classhome:");
                }
                if (v_Script.indexOf(v_Webhome) >= 0) {
                    v_Script = StringHelp.replaceAll((String)v_Script, (String)v_Webhome, (String)"webhome:");
                }
                v_Xml.append(v_NewSpace).append(IToXml.toValue("script", v_Script));
            }
            if (!Help.isNull((String)this.groovy)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("groovy", this.groovy));
            }
            if (!Help.isNull((String)this.out)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("out", this.out, v_NewSpace));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        Map<String, Object> v_In = null;
        try {
            v_In = this.parserIn(i_Context);
        }
        catch (Exception exce) {
            v_Builder.append("Error input parameters");
        }
        if (!Help.isNull(v_In)) {
            for (Map.Entry<String, Object> v_Item : v_In.entrySet()) {
                v_Builder.append(v_Item.getKey()).append("=").append(v_Item.getValue()).append(" ");
            }
            v_In.clear();
        } else {
            v_Builder.append("No input parameters");
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.in)) {
            v_Builder.append(this.in);
        } else {
            v_Builder.append("No input parameters");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new GroovyConfig();
    }

    @Override
    public Object cloneMyOnly() {
        GroovyConfig v_Clone = new GroovyConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.in = this.in;
        v_Clone.script = this.script;
        v_Clone.groovy = this.groovy;
        v_Clone.out = this.out;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone GroovyConfig xid is null.");
        }
        GroovyConfig v_Clone = (GroovyConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.in = this.in;
        v_Clone.script = this.script;
        v_Clone.groovy = this.groovy;
        v_Clone.out = this.out;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone GroovyConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        GroovyConfig v_Clone = new GroovyConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

