/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.ifelse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.Logical;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.ifelse.ConditionItem;
import org.hy.common.callflow.ifelse.IfElse;

public class ConditionConfig
extends ExecuteElement
implements IfElse,
Cloneable {
    private Logical logical = Logical.And;
    private List<IfElse> items = new ArrayList<IfElse>();

    public ConditionConfig() {
        this(0L, 0L);
    }

    public ConditionConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (this.getLogical() == null) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].logical is null.");
            return false;
        }
        if (Help.isNull(this.getItems())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "] has no condition items.");
            return false;
        }
        return this.check_Condition(this, io_Result, this);
    }

    private boolean check_Condition(ConditionConfig i_Condition, Return<Object> io_Result, IExecute i_ExecObject) {
        if (i_Condition.getLogical() == null) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].logical is null.");
            return false;
        }
        if (Help.isNull(i_Condition.getItems())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] has no condition items.");
            return false;
        }
        for (IfElse v_Item : i_Condition.getItems()) {
            if (v_Item instanceof ConditionConfig) {
                if (this.check_Condition((ConditionConfig)v_Item, io_Result, i_ExecObject)) continue;
                return false;
            }
            if (v_Item instanceof ConditionItem) {
                ConditionItem v_CItem = (ConditionItem)v_Item;
                if (v_CItem.getComparer() == null) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].comparer is null.");
                    return false;
                }
                if (Help.isNull((String)v_CItem.getValueXIDA())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].valueXIDA is null.");
                    return false;
                }
                if (!ValueHelp.isRefID(v_CItem.getValueXIDA()) && Help.isNull((String)v_CItem.getValueClass())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] valueXIDA is Normal type ,but valueClass is null.");
                    return false;
                }
                if (Help.isNull((String)v_CItem.getValueXIDB()) || ValueHelp.isRefID(v_CItem.getValueXIDB()) || !Help.isNull((String)v_CItem.getValueClass())) continue;
                io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] valueXIDB is Normal type ,but valueClass is null.");
                return false;
            }
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].item is unknown type.");
            return false;
        }
        return true;
    }

    @Override
    public String getElementType() {
        return ElementType.Condition.getValue();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            boolean v_ExceRet = this.allow(io_Context);
            if (!Help.isNull((String)this.returnID)) {
                io_Context.put(this.returnID, v_ExceRet);
            }
            v_Result.setResult(v_ExceRet);
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public boolean allow(Map<String, Object> i_Context) throws Exception {
        if (this.logical == null) {
            throw new NullPointerException("Condition logical [" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] is null.");
        }
        if (Help.isNull(this.items)) {
            throw new NullPointerException("Condition items [" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] is null.");
        }
        if (Logical.And.equals((Object)this.logical)) {
            for (IfElse v_Item : this.items) {
                if (v_Item == null) {
                    throw new NullPointerException("Condition list element [" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] is null.");
                }
                boolean v_ChildRet = v_Item.allow(i_Context);
                if (v_ChildRet) continue;
                return false;
            }
            return true;
        }
        if (Logical.Or.equals((Object)this.logical)) {
            for (IfElse v_Item : this.items) {
                if (v_Item == null) {
                    throw new NullPointerException("Condition list element [" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] is null.");
                }
                boolean v_ChildRet = v_Item.allow(i_Context);
                if (!v_ChildRet) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean reject(Map<String, Object> i_Context) throws Exception {
        return !this.allow(i_Context);
    }

    public boolean setConditionItem(ConditionItem i_ConditionItem) {
        return this.setItem(i_ConditionItem);
    }

    public boolean setCondition(ConditionConfig i_Condition) {
        return this.setItem(i_Condition);
    }

    public boolean setItem(ConditionItem i_Item) {
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
        if (i_Item != null) {
            this.items.add(i_Item);
            return true;
        }
        return false;
    }

    public boolean setItem(ConditionConfig i_Item) {
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
        if (i_Item != null) {
            this.items.add(i_Item);
            return true;
        }
        return false;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public void setLogical(Logical i_Logical) {
        this.logical = i_Logical;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public List<IfElse> getItems() {
        return this.items;
    }

    public void setItems(List<IfElse> i_Items) {
        if (i_Items == null) {
            this.items.clear();
        } else {
            this.items = i_Items;
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Condition.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((Object)((Object)this.logical))) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("logical", this.logical.getValue()));
            }
            if (!Help.isNull(this.items)) {
                for (IfElse v_Item : this.items) {
                    v_Xml.append(v_Item.toXml(i_Level + 1, v_TreeID, i_ExportType));
                }
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!(Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getFaileds()) && Help.isNull(this.route.getExceptions()))) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.If.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getFaileds(), RouteType.Else.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getFaileds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getFaileds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (this.logical != null && !Help.isNull(this.items)) {
            for (int x = 0; x < this.items.size(); ++x) {
                IfElse v_Item;
                if (x >= 1) {
                    v_Builder.append(" ").append(this.logical.getValue()).append(" ");
                }
                if ((v_Item = this.items.get(x)) instanceof ConditionConfig) {
                    v_Builder.append("(").append(v_Item.toString(i_Context)).append(")");
                    continue;
                }
                v_Builder.append(v_Item.toString(i_Context));
            }
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (this.logical != null && !Help.isNull(this.items)) {
            for (int x = 0; x < this.items.size(); ++x) {
                IfElse v_Item;
                if (x >= 1) {
                    v_Builder.append(" ").append(this.logical.getValue()).append(" ");
                }
                if ((v_Item = this.items.get(x)) instanceof ConditionConfig) {
                    v_Builder.append("(").append(v_Item.toString()).append(")");
                    continue;
                }
                v_Builder.append(v_Item.toString());
            }
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new ConditionConfig();
    }

    @Override
    public Object cloneMyOnly() {
        ConditionConfig v_Clone = new ConditionConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.logical = this.logical;
        for (IfElse v_Item : this.items) {
            if (v_Item instanceof ConditionItem) {
                v_Clone.items.add((ConditionItem)((ConditionItem)v_Item).cloneMyOnly());
                continue;
            }
            if (v_Item instanceof ConditionConfig) {
                v_Clone.items.add((ConditionConfig)((ConditionConfig)v_Item).cloneMyOnly());
                continue;
            }
            throw new RuntimeException("Unknown type[" + v_Item.getClass().getName() + "] of exception");
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ConditionConfig xid is null.");
        }
        ConditionConfig v_Clone = (ConditionConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.logical = this.logical;
        for (IfElse v_Item : this.items) {
            if (v_Item instanceof ConditionItem) {
                ConditionItem v_CloneConditionItem = new ConditionItem();
                v_Item.clone(v_CloneConditionItem, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.items.add(v_CloneConditionItem);
                continue;
            }
            if (v_Item instanceof ConditionConfig) {
                ConditionConfig v_CloneCondition = new ConditionConfig();
                v_Item.clone(v_CloneCondition, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.items.add(v_CloneCondition);
                continue;
            }
            throw new RuntimeException("Unknown type[" + v_Item.getClass().getName() + "] of exception");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ConditionConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        ConditionConfig v_Clone = new ConditionConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

