/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.forloop;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.xml.log.Logger;

public class ForConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(ForConfig.class);
    private String start;
    private String end;
    private String step;
    private String indexID;
    private String indexNo;
    private String elementID;

    public ForConfig() {
        this(0L, 0L);
    }

    public ForConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getXid())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + ".xid is null.");
            return false;
        }
        if (Help.isNull((String)this.getEnd())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].end is null.");
            return false;
        }
        if (Help.isNull(this.getRoute().getSucceeds())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].Succeed route is null.");
            return false;
        }
        return true;
    }

    @Override
    public String getElementType() {
        return ElementType.For.getValue();
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String i_Start) {
        if (Help.isNull((String)i_Start)) {
            this.start = null;
            return;
        }
        String v_Start = i_Start.trim();
        this.start = Help.isNumber((String)v_Start) ? v_Start : ValueHelp.standardRefID(v_Start);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String i_End) {
        if (Help.isNull((String)i_End)) {
            this.end = null;
            return;
        }
        String v_End = i_End.trim();
        this.end = Help.isNumber((String)v_End) ? v_End : ValueHelp.standardRefID(v_End);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String i_Step) {
        if (Help.isNull((String)i_Step)) {
            this.step = null;
            return;
        }
        String v_Step = i_Step.trim();
        this.step = Help.isNumber((String)v_Step) ? v_Step : ValueHelp.standardRefID(v_Step);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
    }

    public String getIndexID() {
        return this.indexID;
    }

    public void setIndexID(String i_IndexID) {
        if (CallFlow.isSystemXID(i_IndexID)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s indexID[" + i_IndexID + "] is SystemXID.");
        }
        this.indexID = ValueHelp.standardValueID(i_IndexID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getIndexNo() {
        return this.indexNo;
    }

    public void setIndexNo(String i_IndexNo) {
        if (CallFlow.isSystemXID(i_IndexNo)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s indexNo[" + i_IndexNo + "] is SystemXID.");
        }
        this.indexNo = ValueHelp.standardValueID(i_IndexNo);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getElementID() {
        return this.elementID;
    }

    public void setElementID(String i_ElementID) {
        if (CallFlow.isSystemXID(i_ElementID)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s elementID[" + i_ElementID + "] is SystemXID.");
        }
        this.elementID = ValueHelp.standardValueID(i_ElementID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            String v_WorkID = CallFlow.getWorkID(io_Context);
            String v_Prefix = v_WorkID + "@" + this.getXid() + "@For@";
            String v_IndexID = v_Prefix + "index";
            String v_IteratorID = v_Prefix + "iterator";
            Integer v_OldIndex = (Integer)io_Context.get(v_IndexID);
            int v_Index = 0;
            Object v_Element = null;
            if (Help.isNull((String)this.start)) {
                Object v_End = null;
                try {
                    v_End = ValueHelp.getValue(this.end, null, null, io_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end[" + this.end + "] error.", (Throwable)exce);
                    v_Result.setException(exce);
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                if (v_End == null) {
                    v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end is null."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                if (MethodReflect.isExtendImplement((Object)v_End, List.class)) {
                    List v_List = (List)v_End;
                    Iterator v_Iterator = null;
                    if (v_OldIndex != null) {
                        v_Index = v_OldIndex + 1;
                        v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                    } else {
                        v_Iterator = v_List.iterator();
                        io_Context.put(v_IteratorID, v_Iterator);
                    }
                    if (!v_Iterator.hasNext()) {
                        v_Result.setException(new IndexOutOfBoundsException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s " + this.end + " List.hasNext() error."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    v_Element = v_Iterator.next();
                } else if (MethodReflect.isExtendImplement((Object)v_End, Set.class)) {
                    Set v_Set = (Set)v_End;
                    Iterator v_Iterator = null;
                    if (v_OldIndex != null) {
                        v_Index = v_OldIndex + 1;
                        v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                    } else {
                        v_Iterator = v_Set.iterator();
                        io_Context.put(v_IteratorID, v_Iterator);
                    }
                    if (!v_Iterator.hasNext()) {
                        v_Result.setException(new IndexOutOfBoundsException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s " + this.end + " Set.hasNext() error."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    v_Element = v_Iterator.next();
                } else if (MethodReflect.isExtendImplement((Object)v_End, Collection.class)) {
                    Collection v_Collection = (Collection)v_End;
                    Iterator v_Iterator = null;
                    if (v_OldIndex != null) {
                        v_Index = v_OldIndex + 1;
                        v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                    } else {
                        v_Iterator = v_Collection.iterator();
                        io_Context.put(v_IteratorID, v_Iterator);
                    }
                    if (!v_Iterator.hasNext()) {
                        v_Result.setException(new IndexOutOfBoundsException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s " + this.end + " Collection.hasNext() error."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    v_Element = v_Iterator.next();
                } else if (MethodReflect.isExtendImplement((Object)v_End, Map.class)) {
                    Map v_Map = (Map)v_End;
                    Iterator v_Iterator = null;
                    if (v_OldIndex != null) {
                        v_Index = v_OldIndex + 1;
                        v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                    } else {
                        v_Iterator = v_Map.entrySet().iterator();
                        io_Context.put(v_IteratorID, v_Iterator);
                    }
                    if (!v_Iterator.hasNext()) {
                        v_Result.setException(new IndexOutOfBoundsException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s " + this.end + " Map.hasNext() error."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    v_Element = v_Iterator.next();
                } else if (Help.isArray((Object)v_End)) {
                    int v_Len = Array.getLength(v_End);
                    if (v_OldIndex != null) {
                        v_Index = v_OldIndex + 1;
                    }
                    if (v_Len <= v_Index) {
                        v_Result.setException(new IndexOutOfBoundsException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s " + this.end + " Array.length " + v_Len + " <= " + v_Index + " error."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    v_Element = Array.get(v_End, v_Index);
                } else {
                    v_Result.setException(new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end is not list."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                io_Context.put(v_IndexID, v_Index);
                this.refreshIndex(io_Context, v_Index);
                this.refreshElementID(io_Context, v_Element);
            } else {
                Integer v_Start = null;
                try {
                    v_Start = (Integer)ValueHelp.getValue(this.start, Integer.class, null, io_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s start[" + this.start + "] error.", (Throwable)exce);
                    v_Result.setException(exce);
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                if (v_Start == null) {
                    v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s start is null."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                Integer v_End = null;
                try {
                    v_End = (Integer)ValueHelp.getValue(this.end, Integer.class, null, io_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end[" + this.end + "] error.", (Throwable)exce);
                    v_Result.setException(exce);
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                if (v_End == null) {
                    v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end is null."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                Integer v_Step = null;
                try {
                    v_Step = (Integer)ValueHelp.getValue(this.step, Integer.class, 1, io_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s step[" + this.step + "] error.", (Throwable)exce);
                    v_Result.setException(exce);
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                v_Index = v_OldIndex != null ? v_OldIndex + v_Step : v_Start;
                if (v_End < v_Index) {
                    v_Result.setException(new IndexOutOfBoundsException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s " + this.end + " " + v_End + " < " + v_Index + " error."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                io_Context.put(v_IndexID, v_Index);
                this.refreshIndex(io_Context, v_Index);
            }
            v_Result.setResult(true);
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    public boolean hasNext(Map<String, Object> io_Context) {
        String v_WorkID = CallFlow.getWorkID(io_Context);
        String v_Prefix = v_WorkID + "@" + this.getXid() + "@For@";
        String v_IndexID = v_Prefix + "index";
        String v_IteratorID = v_Prefix + "iterator";
        Integer v_OldIndex = (Integer)io_Context.get(v_IndexID);
        int v_Index = 0;
        if (Help.isNull((String)this.start)) {
            Object v_End = null;
            try {
                v_End = ValueHelp.getValue(this.end, null, null, io_Context);
            }
            catch (Exception exce) {
                $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end[" + this.end + "] error.", (Throwable)exce);
                return false;
            }
            if (v_End == null) {
                $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end is null."));
                return false;
            }
            if (MethodReflect.isExtendImplement((Object)v_End, List.class)) {
                List v_List = (List)v_End;
                Iterator v_Iterator = null;
                if (v_OldIndex != null) {
                    v_Index = v_OldIndex + 1;
                    v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                } else {
                    v_Iterator = v_List.iterator();
                    io_Context.put(v_IteratorID, v_Iterator);
                }
                return v_Iterator.hasNext();
            }
            if (MethodReflect.isExtendImplement((Object)v_End, Set.class)) {
                Set v_Set = (Set)v_End;
                Iterator v_Iterator = null;
                if (v_OldIndex != null) {
                    v_Index = v_OldIndex + 1;
                    v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                } else {
                    v_Iterator = v_Set.iterator();
                    io_Context.put(v_IteratorID, v_Iterator);
                }
                return v_Iterator.hasNext();
            }
            if (MethodReflect.isExtendImplement((Object)v_End, Collection.class)) {
                Collection v_Collection = (Collection)v_End;
                Iterator v_Iterator = null;
                if (v_OldIndex != null) {
                    v_Index = v_OldIndex + 1;
                    v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                } else {
                    v_Iterator = v_Collection.iterator();
                    io_Context.put(v_IteratorID, v_Iterator);
                }
                return v_Iterator.hasNext();
            }
            if (MethodReflect.isExtendImplement((Object)v_End, Map.class)) {
                Map v_Map = (Map)v_End;
                Iterator v_Iterator = null;
                if (v_OldIndex != null) {
                    v_Index = v_OldIndex + 1;
                    v_Iterator = (Iterator)io_Context.get(v_IteratorID);
                } else {
                    v_Iterator = v_Map.entrySet().iterator();
                    io_Context.put(v_IteratorID, v_Iterator);
                }
                return v_Iterator.hasNext();
            }
            if (Help.isArray((Object)v_End)) {
                int v_Len = Array.getLength(v_End);
                if (v_OldIndex != null) {
                    v_Index = v_OldIndex + 1;
                }
                return v_Len > v_Index;
            }
            $Logger.error((Throwable)new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end is not list."));
            return false;
        }
        Integer v_Start = null;
        try {
            v_Start = (Integer)ValueHelp.getValue(this.start, Integer.class, null, io_Context);
        }
        catch (Exception exce) {
            $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s start[" + this.start + "] error.", (Throwable)exce);
            return false;
        }
        if (v_Start == null) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s start is null."));
            return false;
        }
        Integer v_End = null;
        try {
            v_End = (Integer)ValueHelp.getValue(this.end, Integer.class, null, io_Context);
        }
        catch (Exception exce) {
            $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end[" + this.end + "] error.", (Throwable)exce);
            return false;
        }
        if (v_End == null) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end is null."));
            return false;
        }
        Integer v_Step = null;
        try {
            v_Step = (Integer)ValueHelp.getValue(this.step, Integer.class, 1, io_Context);
        }
        catch (Exception exce) {
            $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s step[" + this.step + "] error.", (Throwable)exce);
            return false;
        }
        v_Index = v_OldIndex != null ? v_OldIndex + v_Step : v_Start;
        return v_End >= v_Index;
    }

    private void refreshIndex(Map<String, Object> io_Context, Integer i_Index) {
        if (!Help.isNull((String)this.indexID) && io_Context != null) {
            io_Context.put(this.indexID, i_Index);
        }
        if (!Help.isNull((String)this.indexNo) && io_Context != null) {
            io_Context.put(this.indexNo, i_Index + 1);
        }
    }

    private void refreshElementID(Map<String, Object> io_Context, Object i_Element) {
        if (!Help.isNull((String)this.elementID) && io_Context != null) {
            io_Context.put(this.elementID, i_Element);
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.For.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.start)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("start", this.start));
            }
            if (!Help.isNull((String)this.end)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("end", this.end));
            }
            if (!Help.isNull((String)this.step)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("step", this.step));
            }
            if (!Help.isNull((String)this.indexID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("indexID", this.indexID));
            }
            if (!Help.isNull((String)this.indexNo)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("indexNo", this.indexNo));
            }
            if (!Help.isNull((String)this.elementID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("elementID", this.elementID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        Object v_End = null;
        String v_WorkID = CallFlow.getWorkID(i_Context);
        String v_Prefix = v_WorkID + "@" + this.getXid() + "@For@";
        String v_IndexID = v_Prefix + "index";
        Integer v_OldIndex = (Integer)i_Context.get(v_IndexID);
        int v_Index = 0;
        v_Builder.append("for (");
        if (Help.isNull((String)this.start)) {
            try {
                v_End = ValueHelp.getValue(this.end, null, null, i_Context);
            }
            catch (Exception exce) {
                $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end[" + this.end + "] error.", (Throwable)exce);
            }
            if (v_OldIndex != null) {
                v_Index = v_OldIndex + 1;
            }
            v_End = v_End == null ? "NULL" : (MethodReflect.isExtendImplement((Object)v_End, List.class) ? "List(" + ((List)v_End).size() + ")[" + v_Index + "]" : (MethodReflect.isExtendImplement((Object)v_End, Set.class) ? "Set(" + ((Set)v_End).size() + ")[" + v_Index + "]" : (MethodReflect.isExtendImplement((Object)v_End, Collection.class) ? "Collection(" + ((Collection)v_End).size() + ")[" + v_Index + "]" : (MethodReflect.isExtendImplement((Object)v_End, Map.class) ? "Map(" + ((Map)v_End).size() + ")[" + v_Index + "]" : (Help.isArray((Object)v_End) ? "Array(" + Array.getLength(v_End) + ")[" + v_Index + "]" : "Not-List")))));
            if (Help.isNull((String)this.elementID)) {
                v_Builder.append(this.end);
            } else {
                v_Builder.append(":").append(this.elementID).append(" : ").append(this.end);
            }
            v_Builder.append("=").append(v_End);
        } else {
            Object v_Start = null;
            try {
                v_Start = ValueHelp.getValue(this.start, Integer.class, null, i_Context);
            }
            catch (Exception exce) {
                $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s start[" + this.start + "] error.", (Throwable)exce);
            }
            try {
                v_End = ValueHelp.getValue(this.end, Integer.class, null, i_Context);
            }
            catch (Exception exce) {
                $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s end[" + this.end + "] error.", (Throwable)exce);
            }
            if (Help.isNull((String)this.indexID)) {
                v_Builder.append(v_Start).append(" .. ").append(v_End);
            } else {
                Integer v_Step = null;
                try {
                    v_Step = (Integer)ValueHelp.getValue(this.step, Integer.class, 1, i_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ForConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s step[" + this.step + "] error.", (Throwable)exce);
                }
                if (v_OldIndex != null) {
                    v_Start = v_OldIndex + v_Step;
                }
                v_Builder.append(":").append(this.indexID).append("=").append(v_Start).append("; ").append(":").append(this.indexID).append("<=").append(v_End).append("; ").append(":").append(this.indexID).append("+=").append(v_Step);
            }
        }
        v_Builder.append(")");
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("for (");
        if (Help.isNull((String)this.start)) {
            if (Help.isNull((String)this.elementID)) {
                v_Builder.append(Help.NVL((String)this.end, (String)"?"));
            } else {
                v_Builder.append(":").append(this.elementID).append(" : ").append(Help.NVL((String)this.end, (String)"?"));
            }
        } else if (Help.isNull((String)this.indexID)) {
            v_Builder.append(this.start).append(" .. ").append(Help.NVL((String)this.end, (String)"?"));
        } else {
            v_Builder.append(":").append(this.indexID).append("=").append(this.start).append("; ").append(":").append(this.indexID).append("<=").append(Help.NVL((String)this.end, (String)"?")).append("; ").append(":").append(this.indexID).append("+=").append(Help.NVL((String)this.step, (String)"1"));
        }
        v_Builder.append(")");
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new ForConfig();
    }

    @Override
    public Object cloneMyOnly() {
        ForConfig v_Clone = new ForConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.start = this.start;
        v_Clone.end = this.end;
        v_Clone.step = this.step;
        v_Clone.indexID = this.indexID;
        v_Clone.indexNo = this.indexNo;
        v_Clone.elementID = this.elementID;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ForConfig xid is null.");
        }
        ForConfig v_Clone = (ForConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.start = this.start;
        v_Clone.end = this.end;
        v_Clone.step = this.step;
        v_Clone.indexID = this.indexID;
        v_Clone.indexNo = this.indexNo;
        v_Clone.elementID = this.elementID;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ForConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        ForConfig v_Clone = new ForConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

