/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.forloop.ForConfig;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;
import org.hy.common.xml.XJava;

public class ExecuteElementCheckHelp {
    private static ExecuteElementCheckHelp $Instance = new ExecuteElementCheckHelp();

    public static ExecuteElementCheckHelp getInstance() {
        return $Instance;
    }

    public Return<Object> check(IExecute i_ExecObject) {
        Return v_Ret = new Return(true);
        if (i_ExecObject == null) {
            return v_Ret.set(false).setParamStr("CFlowCheck\uff1aExecObject is null.");
        }
        HashMap<String, Integer> v_XIDs = new HashMap<String, Integer>();
        HashMap<String, Integer> v_ForXIDs = new HashMap<String, Integer>();
        HashMap<String, String> v_RefNulls = new HashMap<String, String>();
        if (this.check((Return<Object>)v_Ret, i_ExecObject, v_XIDs, v_ForXIDs, v_RefNulls) && !Help.isNull(v_ForXIDs)) {
            for (Map.Entry v_Item : v_ForXIDs.entrySet()) {
                if ((Integer)v_Item.getValue() > 0) continue;
                v_Ret.set(false).setParamStr("CFlowCheck\uff1aFor.xid[" + (String)v_Item.getKey() + "] refXID count is 0.");
                break;
            }
        }
        if (v_Ret.get() && !Help.isNull(v_RefNulls)) {
            for (Map.Entry v_Item : v_RefNulls.entrySet()) {
                String v_RefXID = ((String)v_Item.getKey()).split(" ")[0];
                String v_RefOwnerXID = (String)v_Item.getValue();
                Integer v_RefCount = (Integer)v_XIDs.get(v_RefXID);
                if (v_RefCount == null) {
                    v_Ret.set(false).setParamStr("CFlowCheck\uff1aXID[" + v_RefOwnerXID + "]'s SelfLoop.RefXID[" + v_RefXID + "] is not exists or not valid.");
                    break;
                }
                ExecuteElement v_Ref = (ExecuteElement)XJava.getObject((String)v_RefXID);
                ExecuteElement v_RefOwner = (ExecuteElement)XJava.getObject((String)v_RefOwnerXID);
                boolean v_IsOK = false;
                for (String v_RefTreeID : v_Ref.getTreeIDs()) {
                    for (String v_OwnerTreeID : v_RefOwner.getTreeIDs()) {
                        if (!v_OwnerTreeID.startsWith(v_RefTreeID)) continue;
                        v_IsOK = true;
                        break;
                    }
                    if (!v_IsOK) continue;
                    break;
                }
                if (v_IsOK) continue;
                v_Ret.set(false).setParamStr("CFlowCheck\uff1aXID[" + v_RefOwnerXID + "]'s SelfLoop.RefXID[" + v_RefXID + "], it must be a forward reference, not a backward reference.");
                break;
            }
        }
        if (v_Ret.get()) {
            ((ExecuteElement)i_ExecObject).checkOK();
        }
        v_XIDs.clear();
        v_ForXIDs.clear();
        v_RefNulls.clear();
        return v_Ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean check(Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs, Map<String, String> io_RefNulls) {
        if (!Help.isNull((String)i_ExecObject.getXJavaID())) {
            Integer v_RefCount = io_XIDs.get(i_ExecObject.getXJavaID());
            if (v_RefCount != null) {
                if (i_ExecObject.gatPrevious() != null && v_RefCount < i_ExecObject.gatPrevious().size() - 1) {
                    io_XIDs.put(i_ExecObject.getXJavaID(), v_RefCount + 1);
                    return true;
                }
                io_Result.set(false).setParamStr("CFlowCheck\uff1aXID[" + i_ExecObject.getXJavaID() + "] cannot be repeated.");
                return false;
            }
            io_XIDs.put(i_ExecObject.getXJavaID(), 0);
        }
        if (i_ExecObject instanceof ForConfig) {
            if (!i_ExecObject.check(io_Result)) return false;
            io_ForXIDs.put(i_ExecObject.getXJavaID(), 0);
        } else if (!i_ExecObject.check(io_Result)) {
            return false;
        }
        if (!this.check_SelfLoop(i_ExecObject.getRoute().getSucceeds(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls)) return false;
        if (!this.check_SelfLoop(i_ExecObject.getRoute().getFaileds(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls)) return false;
        return this.check_SelfLoop(i_ExecObject.getRoute().getExceptions(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls);
    }

    private boolean check_SelfLoop(List<RouteItem> i_Childs, Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs, Map<String, String> io_RefNulls) {
        if (!Help.isNull(i_Childs)) {
            for (RouteItem v_RouteItem : i_Childs) {
                ExecuteElement v_Child = v_RouteItem.gatNext();
                if (v_Child == null) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aRouteItem.next is null.");
                    return false;
                }
                if (v_Child instanceof SelfLoop) {
                    SelfLoop v_SelfLoop = (SelfLoop)v_Child;
                    ExecuteElement v_Owner = v_SelfLoop.gatOwner().gatOwner().gatOwner();
                    String v_RefXID = v_SelfLoop.gatRefXID();
                    Integer v_RefCount = io_XIDs.get(v_RefXID);
                    if (v_Owner instanceof ForConfig && v_Owner.getXid().equals(v_SelfLoop.getRefXID())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aSelfLoop.RefXID[" + v_SelfLoop.getRefXID() + "] ref ForConfig[" + v_Owner.getXid() + "] myself.");
                        return false;
                    }
                    if (v_RefCount == null) {
                        io_RefNulls.put(v_RefXID + " " + v_Owner.getXJavaID(), v_Owner.getXJavaID());
                        continue;
                    }
                    v_RefCount = io_ForXIDs.get(v_RefXID);
                    if (v_RefCount == null) continue;
                    io_ForXIDs.put(v_RefXID, v_RefCount + 1);
                    continue;
                }
                if (v_Child == v_RouteItem.gatOwner().gatOwner()) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aRouteItem.next cannot be itself[" + Help.NVL((String)v_RouteItem.gatOwner().gatOwner().getXid()) + "].");
                    return false;
                }
                if (this.check(io_Result, v_Child, io_XIDs, io_ForXIDs, io_RefNulls)) continue;
                return false;
            }
        }
        return true;
    }

    private ExecuteElementCheckHelp() {
    }
}

