/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.WSContentType;
import org.hy.common.callflow.event.websocket.WSPushExecuter;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class WSPushConfig
extends NodeConfig
implements NodeConfigBase {
    private static final Logger $Logger = new Logger(WSPushConfig.class);
    private static WSPushExecuter $WSPushExecuter = null;
    private NodeParam nameParam = new NodeParam();
    private String newMessage;
    private PartitionMap<String, Integer> newMessagePlaceholders;
    private String allMessage;
    private PartitionMap<String, Integer> allMessagePlaceholders;
    private String contentType;
    private String serviceTypeName;
    private String moduleCode;
    private String moduleName;

    public WSPushConfig() {
        this(0L, 0L);
    }

    public WSPushConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.nameParam.setValueClass(String.class.getName());
        this.setCallParam(this.nameParam);
        NodeParam v_CallParam = new NodeParam();
        v_CallParam.setValueClass(null);
        v_CallParam.setValue("");
        this.setCallParam(v_CallParam);
        v_CallParam = new NodeParam();
        v_CallParam.setValueClass(null);
        v_CallParam.setValue("");
        this.setCallParam(v_CallParam);
        this.setName(null);
        this.setCallMethod("pushMessages");
        this.setContentType(WSContentType.Json.getValue());
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getName())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].name is null.");
            return false;
        }
        if (Help.isNull((String)this.getNewMessage())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].newMessage is null.");
            return false;
        }
        return true;
    }

    private synchronized void findWSClass() {
        if ($WSPushExecuter != null) {
            return;
        }
        Object v_Executer = XJava.getObject((String)"WebSocketPushExecuter");
        if (v_Executer != null) {
            if (v_Executer instanceof WSPushExecuter) {
                $WSPushExecuter = (WSPushExecuter)v_Executer;
            } else {
                $Logger.error((Throwable)new ClassNotFoundException("Found XID[WebSocketPushExecuter] is not instanceof WSPushExecuter."));
            }
        } else {
            $Logger.error((Throwable)new ClassNotFoundException("Not found XID[WebSocketPushExecuter]."));
        }
    }

    public String getName() {
        return this.nameParam.getValue();
    }

    public void setName(String i_Name) {
        if (Help.isNull((String)i_Name)) {
            this.nameParam.setValue("ws");
        } else {
            this.nameParam.setValue(i_Name.trim());
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getServiceTypeName() {
        return this.serviceTypeName;
    }

    public void setServiceTypeName(String i_ServiceTypeName) {
        this.serviceTypeName = i_ServiceTypeName;
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    public void setModuleCode(String i_ModuleCode) {
        this.moduleCode = i_ModuleCode;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String i_ModuleName) {
        this.moduleName = i_ModuleName;
    }

    public String getNewMessage() {
        return this.newMessage;
    }

    public void setNewMessage(String i_NewMessage) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_NewMessage)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_NewMessage, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.newMessagePlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.newMessagePlaceholders = new TablePartitionLink();
        }
        this.newMessage = i_NewMessage;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getAllMessage() {
        return this.allMessage;
    }

    public void setAllMessage(String i_AllMessage) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_AllMessage)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_AllMessage, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.allMessagePlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.allMessagePlaceholders = new TablePartitionLink();
        }
        this.allMessage = i_AllMessage;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String i_ContentType) {
        this.contentType = Help.isNull((String)i_ContentType) ? WSContentType.Json.getValue() : i_ContentType;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public void setXJavaID(String i_Xid) {
        super.setXJavaID(i_Xid);
        this.setCallXID(this.getXid());
    }

    @Override
    public String getElementType() {
        return ElementType.WSPush.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.WSPush.getXmlName();
    }

    @Override
    public boolean xmlShowRetFalseIsError() {
        return false;
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        return io_ExecuteObject == null ? this : io_ExecuteObject;
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        if (!Help.isNull((String)this.newMessage)) {
            io_Params[1] = ValueHelp.replaceByContext(this.newMessage, this.newMessagePlaceholders, io_Context);
        }
        if (!Help.isNull((String)this.allMessage)) {
            io_Params[2] = ValueHelp.replaceByContext(this.allMessage, this.allMessagePlaceholders, io_Context);
        }
        return io_Params;
    }

    @Override
    public void generateInit(Map<String, Object> io_Context, Object i_ExecuteObject, Object[] i_Params) {
        this.findWSClass();
        if ($WSPushExecuter == null) {
            throw new RuntimeException("WSPushExecuter is not find.");
        }
        String v_ServiceType = (String)i_Params[0];
        if (Help.isNull((String)v_ServiceType) || Help.isNull((String)this.serviceTypeName) || Help.isNull((String)this.moduleCode) || Help.isNull((String)this.moduleName)) {
            return;
        }
        $WSPushExecuter.register(i_Params[0].toString(), this.serviceTypeName, this.moduleCode, this.moduleName);
    }

    public boolean pushMessages(String i_Name, Object i_NewMessage, Object i_AllMessage) {
        if (i_NewMessage == null) {
            throw new NullPointerException("NewMessage is null.");
        }
        try {
            XJSON v_XJson;
            String v_NewMsg = null;
            String v_AllMsg = null;
            if (i_NewMessage instanceof String) {
                v_NewMsg = i_NewMessage.toString();
            } else if (WSContentType.Json.getValue().equalsIgnoreCase(this.getContentType())) {
                v_XJson = new XJSON();
                v_NewMsg = v_XJson.toJson(i_NewMessage).toJSONString();
            } else {
                v_NewMsg = i_NewMessage.toString();
            }
            if (i_AllMessage == null) {
                v_AllMsg = v_NewMsg;
            } else if (i_AllMessage instanceof String) {
                v_AllMsg = i_AllMessage.toString();
            } else if (WSContentType.Json.getValue().equalsIgnoreCase(this.getContentType())) {
                v_XJson = new XJSON();
                v_AllMsg = v_XJson.toJson(i_AllMessage).toJSONString();
            } else {
                v_AllMsg = i_AllMessage.toString();
            }
            $WSPushExecuter.pushMessages(i_Name, v_NewMsg, Help.NVL((String)v_AllMsg, (String)v_NewMsg));
            return true;
        }
        catch (Exception exce) {
            throw new RuntimeException(exce);
        }
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (!Help.isNull((String)this.getName())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("name", this.getName()));
        }
        if (!Help.isNull((String)this.getServiceTypeName())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("serviceTypeName", this.getServiceTypeName()));
        }
        if (!Help.isNull((String)this.getModuleCode())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("moduleCode", this.getModuleCode()));
        }
        if (!Help.isNull((String)this.getModuleName())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("moduleName", this.getModuleName()));
        }
        if (!Help.isNull((String)this.getNewMessage())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("newMessage", this.getNewMessage(), v_NewSpace));
        }
        if (!Help.isNull((String)this.getAllMessage())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("allMessage", this.getAllMessage(), v_NewSpace));
        }
        if (!Help.isNull((String)this.getContentType()) && !WSContentType.Json.getValue().equalsIgnoreCase(this.getContentType())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("contentType", this.getContentType()));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder;
        block9: {
            v_Builder = new StringBuilder();
            v_Builder.append("WS name: ");
            if (!Help.isNull((String)this.getName())) {
                try {
                    String v_Name = (String)ValueHelp.getValue(this.getName(), String.class, "", i_Context);
                    v_Builder.append(v_Name);
                }
                catch (Exception exce) {
                    v_Builder.append(exce.getMessage());
                }
            } else {
                v_Builder.append("?");
            }
            v_Builder.append(" : ");
            if (!Help.isNull((String)this.getNewMessage())) {
                try {
                    String v_NewMessage = ValueHelp.replaceByContext(this.newMessage, this.newMessagePlaceholders, i_Context);
                    if (Help.isNull((String)v_NewMessage)) {
                        v_Builder.append("?");
                        break block9;
                    }
                    v_Builder.append(v_NewMessage);
                }
                catch (Exception exce) {
                    v_Builder.append(exce.getMessage());
                }
            } else {
                v_Builder.append("?");
            }
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("WS name: ");
        if (!Help.isNull((String)this.getName())) {
            v_Builder.append(this.getName());
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" : ");
        if (!Help.isNull((String)this.getNewMessage())) {
            v_Builder.append(this.getNewMessage());
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new WSPushConfig();
    }

    @Override
    public Object cloneMyOnly() {
        WSPushConfig v_Clone = new WSPushConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.serviceTypeName = this.serviceTypeName;
        v_Clone.moduleCode = this.moduleCode;
        v_Clone.moduleName = this.moduleName;
        v_Clone.contentType = this.contentType;
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.setNewMessage(this.getNewMessage());
        v_Clone.setAllMessage(this.getAllMessage());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone WSPushConfig xid is null.");
        }
        WSPushConfig v_Clone = (WSPushConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.serviceTypeName = this.serviceTypeName;
        v_Clone.moduleCode = this.moduleCode;
        v_Clone.moduleName = this.moduleName;
        v_Clone.contentType = this.contentType;
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        v_Clone.setNewMessage(this.getNewMessage());
        v_Clone.setAllMessage(this.getAllMessage());
        if (!Help.isNull((List)this.callParams)) {
            v_Clone.callParams = new ArrayList();
            for (NodeParam v_NodeParam : this.callParams) {
                NodeParam v_CloneNodeParam = new NodeParam();
                v_NodeParam.clone(v_CloneNodeParam, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.callParams.add(v_CloneNodeParam);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone WSPushConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        WSPushConfig v_Clone = new WSPushConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

