/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.common.FindClass;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.WSContentType;
import org.hy.common.callflow.event.websocket.WSPullData;
import org.hy.common.callflow.event.websocket.WSPullExecuter;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.xml.log.Logger;

public class WSPullConfig
extends NodeConfig
implements NodeConfigBase {
    private static final Logger $Logger = new Logger(WSPullConfig.class);
    private String wsURL;
    private PartitionMap<String, Integer> wsURLPlaceholders;
    private String callFlowXID;
    private String contentType;
    private String returnClass;

    public WSPullConfig() {
        this(0L, 0L);
    }

    public WSPullConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setCallMethod("pullMessages");
        NodeParam v_CallParam = new NodeParam();
        v_CallParam.setValueClass(Map.class.getName());
        v_CallParam.setValue(":CallFlowContext");
        this.setCallParam(v_CallParam);
        this.setContentType(WSContentType.Json.getValue());
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getWsURL())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].wsURL is null.");
            return false;
        }
        if (Help.isNull((String)this.getCallFlowXID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].callFlowXID is null.");
            return false;
        }
        return true;
    }

    private WSPullExecuter newWSPullExecuter() {
        WSPullExecuter v_Executer = null;
        Class<?> v_WSClass = FindClass.finds("WebSocketPullExecuter");
        if (v_WSClass != null) {
            if (!MethodReflect.isExtendImplement(v_WSClass, WSPullExecuter.class)) {
                ClassNotFoundException v_Error = new ClassNotFoundException("Class[" + v_WSClass.getName() + "] does not implement interface(WSPullExecuter)");
                $Logger.error((Throwable)v_Error);
            }
            try {
                v_Executer = (WSPullExecuter)v_WSClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exce) {
                InstantiationException v_Error = new InstantiationException("Class[" + v_WSClass.getName() + "] newInstance error");
                $Logger.error((Throwable)v_Error);
            }
        }
        return v_Executer;
    }

    public String getWsURL() {
        return this.wsURL;
    }

    public void setWsURL(String i_WsURL) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_WsURL)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_WsURL, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.wsURLPlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.wsURLPlaceholders = new TablePartitionLink();
        }
        this.wsURL = i_WsURL;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String i_ContentType) {
        this.contentType = Help.isNull((String)i_ContentType) ? WSContentType.Json.getValue() : i_ContentType;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCallFlowXID() {
        return ValueHelp.standardRefID(this.callFlowXID);
    }

    public String gatCallFlowXID() {
        return this.callFlowXID;
    }

    public void setCallFlowXID(String i_CallFlowXID) {
        this.callFlowXID = ValueHelp.standardValueID(i_CallFlowXID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Class<?> gatReturnClass() {
        if (!Help.isNull((String)this.returnClass)) {
            try {
                return Help.forName((String)this.returnClass);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return null;
    }

    public String getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(String i_ReturnClass) {
        this.returnClass = Void.class.getName().equals(i_ReturnClass) ? null : i_ReturnClass;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public void setXJavaID(String i_Xid) {
        super.setXJavaID(i_Xid);
        this.setCallXID(this.getXid());
    }

    @Override
    public String getElementType() {
        return ElementType.WSPull.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.WSPull.getXmlName();
    }

    @Override
    public boolean xmlShowRetFalseIsError() {
        return false;
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        return io_ExecuteObject == null ? this : io_ExecuteObject;
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        return io_Params;
    }

    public boolean pullMessages(Map<String, Object> io_Context) {
        WSPullExecuter v_Executer = this.newWSPullExecuter();
        if (v_Executer == null) {
            throw new RuntimeException("WSPullExecuter is not find.");
        }
        if (Help.isNull((String)this.gatCallFlowXID())) {
            throw new NullPointerException("CallFlowXID is null.");
        }
        try {
            return v_Executer.init(new WSPullData(this, io_Context, this.wsURLPlaceholders));
        }
        catch (Exception exce) {
            throw new RuntimeException(exce);
        }
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (!Help.isNull((String)this.getWsURL())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("wsURL", this.getWsURL()));
        }
        if (!Help.isNull((String)this.gatCallFlowXID())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("callFlowXID", this.getCallFlowXID()));
        }
        if (!Help.isNull((String)this.getContentType()) && !WSContentType.Json.getValue().equalsIgnoreCase(this.getContentType())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("contentType", this.getContentType()));
        }
        if (!Help.isNull((String)this.returnClass)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("returnClass", this.returnClass));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("WSPull : ");
        if (!Help.isNull((String)this.getWsURL())) {
            v_Builder.append(ValueHelp.replaceByContext(this.wsURL, this.wsURLPlaceholders, i_Context));
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" : ");
        if (!Help.isNull((String)this.gatCallFlowXID())) {
            v_Builder.append(this.getCallFlowXID());
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("WSPull : ");
        if (!Help.isNull((String)this.getWsURL())) {
            v_Builder.append(this.getWsURL());
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(" : ");
        if (!Help.isNull((String)this.gatCallFlowXID())) {
            v_Builder.append(this.getCallFlowXID());
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new WSPullConfig();
    }

    @Override
    public Object cloneMyOnly() {
        WSPullConfig v_Clone = new WSPullConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.wsURL = this.wsURL;
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.contentType = this.contentType;
        v_Clone.returnClass = this.returnClass;
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone WSPullConfig xid is null.");
        }
        WSPullConfig v_Clone = (WSPullConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.wsURL = this.wsURL;
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.contentType = this.contentType;
        v_Clone.returnClass = this.returnClass;
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone WSPullConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        WSPullConfig v_Clone = new WSPullConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

