/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.MessageType;
import org.hy.common.callflow.event.PublishConfig;
import org.hy.common.callflow.event.mqtt.SubscribeMQTTListener;
import org.hy.common.callflow.event.mqtt.SubscribeMQTTs;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.APIConfig;
import org.hy.common.callflow.node.APIException;
import org.hy.common.mqtt.client.enums.MessageFormat;
import org.hy.common.xml.XJava;

public class SubscribeConfig
extends APIConfig {
    private static final String $ListenerXID = "_SubscribeMQTTListener";
    private static final String $ReturnTopic = "_Topic";
    private static final String $ReturnMessage = "_Message";
    private MessageType subscribeType;
    private String subscribeURL;
    private String subscribeXID;
    private String brokerPassword;
    private String userID;
    private String callFlowXID;
    private String format;
    private Map<String, Object> executeContext;

    public SubscribeConfig() {
        this(0L, 0L);
    }

    public SubscribeConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setSubscribeType(MessageType.MQTT);
        this.setSubscribeURL(PublishConfig.$PublishURL);
        this.setFormat(MessageFormat.Text.getValue());
        this.setRequestType("POST");
        this.setSucceedFlag("200");
        this.setConnectTimeout(10000);
        this.setReadTimeout(15000);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getSubscribeXID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].subscribeXID is null.");
            return false;
        }
        if (Help.isNull((String)this.getUserID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].userID is null.");
            return false;
        }
        if (Help.isNull((String)this.getCallFlowXID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].callFlowXID is null.");
            return false;
        }
        return true;
    }

    public MessageType getSubscribeType() {
        return this.subscribeType;
    }

    public void setSubscribeType(MessageType i_SubscribeType) {
        this.subscribeType = i_SubscribeType == null ? MessageType.MQTT : i_SubscribeType;
        if (this.subscribeType.equals((Object)MessageType.MQTT)) {
            this.setReturnClass(SubscribeMQTTs.class.getName());
            this.setReturnClassKey("data");
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getSubscribeURL() {
        return this.subscribeURL;
    }

    public void setSubscribeURL(String i_SubscribeURL) {
        this.subscribeURL = Help.isNull((String)i_SubscribeURL) ? PublishConfig.$PublishURL : i_SubscribeURL;
        this.setUrl(this.subscribeURL + "/msMQTT/subscribe/querySubscribe");
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getSubscribeXID() {
        return this.subscribeXID;
    }

    public void setSubscribeXID(String i_SubscribeXID) {
        this.subscribeXID = i_SubscribeXID;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getBrokerPassword() {
        return this.brokerPassword;
    }

    public void setBrokerPassword(String i_BrokerPassword) {
        this.brokerPassword = i_BrokerPassword;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String i_UserID) {
        this.userID = i_UserID;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCallFlowXID() {
        return ValueHelp.standardRefID(this.callFlowXID);
    }

    public String gatCallFlowXID() {
        return this.callFlowXID;
    }

    public void setCallFlowXID(String i_CallFlowXID) {
        this.callFlowXID = ValueHelp.standardValueID(i_CallFlowXID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String i_Format) {
        this.format = i_Format;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Map<String, Object> gatExecuteContext() {
        return this.executeContext;
    }

    public String getReturnIDTopic() {
        if (Help.isNull((String)this.returnID)) {
            return null;
        }
        return this.returnID + $ReturnTopic;
    }

    public String getReturnIDMessage() {
        if (Help.isNull((String)this.returnID)) {
            return null;
        }
        return this.returnID + $ReturnMessage;
    }

    @Override
    public String getElementType() {
        return ElementType.Subscribe.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.Subscribe.getXmlName();
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        if (!Help.isNull((String)this.param)) {
            io_Params[0] = ValueHelp.replaceByContext(this.param, io_Context);
        }
        String v_SubscribeXID = null;
        v_SubscribeXID = !Help.isNull((String)this.subscribeXID) ? ValueHelp.replaceByContext(this.subscribeXID, io_Context) : "";
        String v_UserID = null;
        v_UserID = !Help.isNull((String)this.userID) ? ValueHelp.replaceByContext(this.userID, io_Context) : "";
        StringBuilder v_Body = new StringBuilder();
        if (MessageType.MQTT.equals((Object)this.subscribeType)) {
            v_Body.append("{");
            v_Body.append("  \"xid\": \"").append(v_SubscribeXID).append("\",");
            v_Body.append("  \"userID\": \"").append(v_UserID).append("\"");
            v_Body.append("}");
        }
        io_Params[1] = v_Body.toString();
        if (!Help.isNull((String)this.head)) {
            String v_Head = ValueHelp.replaceByContext(this.head, io_Context);
            try {
                io_Params[2] = ValueHelp.getValue(v_Head, Map.class, null, io_Context);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return io_Params;
    }

    @Override
    public Return<Object> generateReturn(Map<String, Object> io_Context, Object io_ExecuteReturn) {
        Return<Object> v_Ret = super.generateReturn(io_Context, io_ExecuteReturn);
        if (!v_Ret.booleanValue()) {
            return v_Ret;
        }
        if (this.subscribeType.equals((Object)MessageType.MQTT)) {
            SubscribeMQTTs v_Subscribes = (SubscribeMQTTs)v_Ret.paramObj;
            if (Help.isNull((Object)v_Subscribes)) {
                APIException v_Exce = new APIException(v_Ret.getParamStr(), "SubscribeMQTTs size is 0.", v_Ret.getParamObj());
                return new Return(false).setException((Exception)v_Exce);
            }
            SubscribeMQTTListener v_Listener = (SubscribeMQTTListener)XJava.getObject((String)(this.getXid() + $ListenerXID));
            if (v_Listener != null) {
                v_Listener.unsubscribeClose();
            }
            this.executeContext = new HashMap<String, Object>();
            if (!Help.isNull(io_Context)) {
                for (Map.Entry<String, Object> v_Item : io_Context.entrySet()) {
                    if (CallFlow.isSystemXID(v_Item.getKey())) continue;
                    this.executeContext.put(v_Item.getKey(), v_Item.getValue());
                }
            }
            v_Listener = new SubscribeMQTTListener(v_Subscribes.getDatas().get(0), this);
            XJava.putObject((String)(this.getXid() + $ListenerXID), (Object)v_Listener);
        }
        return v_Ret;
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (this.subscribeType != null && !MessageType.MQTT.equals((Object)this.subscribeType)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("subscribeType", this.subscribeType.getValue()));
        }
        if (!Help.isNull((String)this.subscribeURL) && !PublishConfig.$PublishURL.equals(this.subscribeURL)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("subscribeURL", this.subscribeURL));
        }
        if (!Help.isNull((String)this.subscribeXID)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("subscribeXID", this.subscribeXID));
        }
        if (!Help.isNull((String)this.userID)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("userID", this.userID));
        }
        if (!Help.isNull((String)this.brokerPassword)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("brokerPassword", this.brokerPassword));
        }
        if (this.getConnectTimeout() != 10000) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("connectTimeout", this.getConnectTimeout()));
        }
        if (this.getReadTimeout() != 15000) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("readTimeout", this.getReadTimeout()));
        }
        if (!Help.isNull((String)this.param)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("param", this.param));
        }
        if (!Help.isNull((String)this.head)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("head", this.head));
        }
        if (!Help.isNull((String)this.gatCallFlowXID())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("callFlowXID", this.getCallFlowXID()));
        }
        if (!Help.isNull((String)this.format) && !MessageFormat.Text.equals((Object)MessageFormat.get((String)this.format))) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("format", this.format, v_NewSpace));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("\u8ba2\u9605");
        v_Builder.append(this.subscribeType.getValue());
        v_Builder.append(":");
        v_Builder.append(this.subscribeURL);
        v_Builder.append(":");
        if (Help.isNull((String)this.getSubscribeXID())) {
            v_Builder.append("?");
        } else {
            try {
                v_Builder.append(ValueHelp.getValue(this.getSubscribeXID(), String.class, this.getSubscribeXID(), i_Context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        v_Builder.append(":");
        if (Help.isNull((String)this.getUserID())) {
            v_Builder.append("?");
        } else {
            try {
                v_Builder.append(ValueHelp.getValue(this.getUserID(), String.class, this.getUserID(), i_Context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        v_Builder.append(" TO ");
        if (Help.isNull((String)this.gatCallFlowXID())) {
            v_Builder.append("?");
        } else {
            v_Builder.append(this.getCallFlowXID());
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("\u8ba2\u9605");
        v_Builder.append(this.subscribeType.getValue());
        v_Builder.append(":");
        v_Builder.append(this.subscribeURL);
        v_Builder.append(":");
        v_Builder.append(Help.NVL((String)this.getSubscribeXID(), (String)"?"));
        v_Builder.append(":");
        v_Builder.append(Help.NVL((String)this.getUserID(), (String)"?"));
        v_Builder.append(" TO ");
        v_Builder.append(Help.NVL((String)this.getCallFlowXID(), (String)"?"));
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new SubscribeConfig();
    }

    @Override
    public Object cloneMyOnly() {
        SubscribeConfig v_Clone = new SubscribeConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.setSubscribeType(this.getSubscribeType());
        v_Clone.setSubscribeURL(this.getSubscribeURL());
        v_Clone.setSubscribeXID(this.getSubscribeXID());
        v_Clone.setBrokerPassword(this.getBrokerPassword());
        v_Clone.setUserID(this.getUserID());
        v_Clone.setParam(this.getParam());
        v_Clone.setHead(this.getHead());
        v_Clone.setContext(this.getContext());
        v_Clone.setConnectTimeout(this.getConnectTimeout());
        v_Clone.setReadTimeout(this.getReadTimeout());
        v_Clone.setTimeout(this.getTimeout());
        v_Clone.setCallFlowXID(this.getCallFlowXID());
        v_Clone.setFormat(this.getFormat());
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone SubscribeConfig xid is null.");
        }
        SubscribeConfig v_Clone = (SubscribeConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.setSubscribeType(this.getSubscribeType());
        v_Clone.setSubscribeURL(this.getSubscribeURL());
        v_Clone.setSubscribeXID(this.getSubscribeXID());
        v_Clone.setBrokerPassword(this.getBrokerPassword());
        v_Clone.setUserID(this.getUserID());
        v_Clone.setParam(this.getParam());
        v_Clone.setHead(this.getHead());
        v_Clone.setContext(this.getContext());
        v_Clone.setConnectTimeout(this.getConnectTimeout());
        v_Clone.setReadTimeout(this.getReadTimeout());
        v_Clone.setTimeout(this.getTimeout());
        v_Clone.setCallFlowXID(this.getCallFlowXID());
        v_Clone.setFormat(this.getFormat());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone SubscribeConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        SubscribeConfig v_Clone = new SubscribeConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

