/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.MessageType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.APIConfig;
import org.hy.common.mqtt.client.enums.MessageFormat;

public class PublishConfig
extends APIConfig {
    public static String $PublishURL = "http://127.0.0.1";
    private MessageType publishType = MessageType.MQTT;
    private String publishURL;
    private String publishXID;
    private String message;
    private String format;
    private Integer qoS;
    private Boolean retain;
    private String userID;

    public PublishConfig() {
        this(0L, 0L);
    }

    public PublishConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        this.setPublishURL($PublishURL);
        this.setRequestType("POST");
        this.setSucceedFlag("200");
        this.setConnectTimeout(10000);
        this.setReadTimeout(15000);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getPublishXID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].publishXID is null.");
            return false;
        }
        if (Help.isNull((String)this.getMessage())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].message is null.");
            return false;
        }
        if (Help.isNull((String)this.getUserID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].userID is null.");
            return false;
        }
        if (!(Help.isNull((Integer)this.getQoS()) || this.getQoS() >= 0 && this.getQoS() <= 2)) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].qoS is invalid.");
            return false;
        }
        return true;
    }

    public MessageType getPublishType() {
        return this.publishType;
    }

    public void setPublishType(MessageType i_PublishType) {
        this.publishType = i_PublishType == null ? MessageType.MQTT : i_PublishType;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPublishURL() {
        return this.publishURL;
    }

    public void setPublishURL(String i_PublishURL) {
        this.publishURL = Help.isNull((String)i_PublishURL) ? $PublishURL : i_PublishURL;
        this.setUrl(this.publishURL + "/msMQTT/publish/executePublish");
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPublishXID() {
        return this.publishXID;
    }

    public void setPublishXID(String i_PublishXID) {
        this.publishXID = i_PublishXID;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String i_Message) {
        this.message = i_Message;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String i_Format) {
        this.format = i_Format;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Integer getQoS() {
        return this.qoS;
    }

    public void setQoS(Integer i_QoS) {
        this.qoS = i_QoS;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getRetain() {
        return this.retain;
    }

    public void setRetain(Boolean i_Retain) {
        this.retain = i_Retain;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String i_UserID) {
        this.userID = i_UserID;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String getElementType() {
        return ElementType.Publish.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.Publish.getXmlName();
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        if (!Help.isNull((String)this.param)) {
            io_Params[0] = ValueHelp.replaceByContext(this.param, io_Context);
        }
        String v_PublishXID = null;
        v_PublishXID = !Help.isNull((String)this.publishXID) ? ValueHelp.replaceByContext(this.publishXID, io_Context) : "";
        String v_Message = null;
        v_Message = !Help.isNull((String)this.message) ? ValueHelp.replaceByContext(this.message, io_Context) : "";
        String v_Format = null;
        if (!Help.isNull((String)this.format)) {
            v_Format = ValueHelp.replaceByContext(this.format, io_Context);
            if (MessageFormat.get((String)v_Format) == null) {
                v_Format = "TEXT";
            }
        } else {
            v_Format = "TEXT";
        }
        String v_UserID = null;
        v_UserID = !Help.isNull((String)this.userID) ? ValueHelp.replaceByContext(this.userID, io_Context) : "";
        StringBuilder v_Body = new StringBuilder();
        if (MessageType.MQTT.equals((Object)this.publishType)) {
            v_Body.append("{");
            v_Body.append("  \"xid\": \"").append(v_PublishXID).append("\",");
            v_Body.append("  \"message\": \"").append(v_Message).append("\",");
            v_Body.append("  \"format\": \"").append(v_Format).append("\",");
            if (!Help.isNull((Integer)this.qoS)) {
                v_Body.append("  \"qoS\": \"").append(this.qoS).append("\",");
            }
            if (!Help.isNull((Object)this.retain)) {
                v_Body.append("  \"retain\": \"").append(this.retain != false ? 1 : 0).append("\",");
            }
            v_Body.append("  \"userID\": \"").append(v_UserID).append("\"");
            v_Body.append("}");
        }
        io_Params[1] = v_Body.toString();
        if (!Help.isNull((String)this.head)) {
            String v_Head = ValueHelp.replaceByContext(this.head, io_Context);
            try {
                io_Params[2] = ValueHelp.getValue(v_Head, Map.class, null, io_Context);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return io_Params;
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (this.publishType != null && !MessageType.MQTT.equals((Object)this.publishType)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("publishType", this.publishType.getValue()));
        }
        if (!Help.isNull((String)this.publishURL) && !$PublishURL.equals(this.publishURL)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("publishURL", this.publishURL));
        }
        if (!Help.isNull((String)this.publishXID)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("publishXID", this.publishXID));
        }
        if (!Help.isNull((String)this.message)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("message", this.message, v_NewSpace));
        }
        if (!Help.isNull((String)this.format) && !MessageFormat.Text.equals((Object)MessageFormat.get((String)this.format))) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("format", this.format, v_NewSpace));
        }
        if (!Help.isNull((Integer)this.qoS)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("qoS", this.qoS));
        }
        if (!Help.isNull((Object)this.retain)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("retain", this.retain));
        }
        if (!Help.isNull((String)this.userID)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("userID", this.userID));
        }
        if (this.getConnectTimeout() != 10000) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("connectTimeout", this.getConnectTimeout()));
        }
        if (this.getReadTimeout() != 15000) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("readTimeout", this.getReadTimeout()));
        }
        if (!Help.isNull((String)this.param)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("param", this.param));
        }
        if (!Help.isNull((String)this.head)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("head", this.head));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("\u53d1\u5e03");
        v_Builder.append(this.publishType.getValue());
        v_Builder.append(":");
        v_Builder.append(this.publishURL);
        v_Builder.append(":");
        if (Help.isNull((String)this.getPublishXID())) {
            v_Builder.append("?");
        } else {
            try {
                v_Builder.append(ValueHelp.getValue(this.getPublishXID(), String.class, this.getPublishXID(), i_Context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        v_Builder.append(":");
        if (Help.isNull((String)this.getUserID())) {
            v_Builder.append("?");
        } else {
            try {
                v_Builder.append(ValueHelp.getValue(this.getUserID(), String.class, this.getUserID(), i_Context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        v_Builder.append(":");
        if (Help.isNull((String)this.getMessage())) {
            v_Builder.append("?");
        } else {
            try {
                v_Builder.append(ValueHelp.getValue(this.getMessage(), String.class, this.getMessage(), i_Context));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("\u53d1\u5e03");
        v_Builder.append(this.publishType.getValue());
        v_Builder.append(":");
        v_Builder.append(this.publishURL);
        v_Builder.append(":");
        v_Builder.append(Help.NVL((String)this.getPublishXID(), (String)"?"));
        v_Builder.append(":");
        v_Builder.append(Help.NVL((String)this.getUserID(), (String)"?"));
        v_Builder.append(":");
        v_Builder.append(Help.NVL((String)this.getMessage(), (String)"?"));
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new PublishConfig();
    }

    @Override
    public Object cloneMyOnly() {
        PublishConfig v_Clone = new PublishConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.setPublishType(this.getPublishType());
        v_Clone.setPublishURL(this.getPublishURL());
        v_Clone.setPublishXID(this.getPublishXID());
        v_Clone.setMessage(this.getMessage());
        v_Clone.setFormat(this.getFormat());
        v_Clone.setQoS(this.getQoS());
        v_Clone.setRetain(this.getRetain());
        v_Clone.setUserID(this.getUserID());
        v_Clone.setParam(this.getParam());
        v_Clone.setHead(this.getHead());
        v_Clone.setContext(this.getContext());
        v_Clone.setConnectTimeout(this.getConnectTimeout());
        v_Clone.setReadTimeout(this.getReadTimeout());
        v_Clone.setTimeout(this.getTimeout());
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone PublishConfig xid is null.");
        }
        PublishConfig v_Clone = (PublishConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.setPublishType(this.getPublishType());
        v_Clone.setPublishURL(this.getPublishURL());
        v_Clone.setPublishXID(this.getPublishXID());
        v_Clone.setMessage(this.getMessage());
        v_Clone.setFormat(this.getFormat());
        v_Clone.setQoS(this.getQoS());
        v_Clone.setRetain(this.getRetain());
        v_Clone.setUserID(this.getUserID());
        v_Clone.setParam(this.getParam());
        v_Clone.setHead(this.getHead());
        v_Clone.setContext(this.getContext());
        v_Clone.setConnectTimeout(this.getConnectTimeout());
        v_Clone.setReadTimeout(this.getReadTimeout());
        v_Clone.setTimeout(this.getTimeout());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone PublishConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        PublishConfig v_Clone = new PublishConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

