/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.JobIntervalType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.thread.Job;
import org.hy.common.thread.Jobs;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class JOBConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(JOBConfig.class);
    private String jobsXID;
    private String callFlowXID;
    private String intervalType;
    private String intervalLen;
    private String condition;
    private List<Date> startTimes;
    private Job job;
    private Map<String, Object> executeContext;

    public JOBConfig() {
        this(0L, 0L);
    }

    public JOBConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (Help.isNull((String)this.getCallFlowXID())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].callFlowXID is null.");
            return false;
        }
        if (Help.isNull((String)this.getIntervalType())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].intervalType is null.");
            return false;
        }
        if (!this.getIntervalType().startsWith(":") && JobIntervalType.get(this.getIntervalType()) == null) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].intervalType is invalid.");
            return false;
        }
        if (Help.isNull((String)this.getIntervalLen())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].intervalLen is null.");
            return false;
        }
        if (!this.getIntervalLen().startsWith(":")) {
            if (!Help.isNumber((String)this.getIntervalLen())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].intervalLen is invalid.");
                return false;
            }
            int v_IntervalLen = Integer.parseInt(this.getIntervalLen());
            if (v_IntervalLen <= 0) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getXid()) + "].intervalLen <= 0.");
                return false;
            }
        }
        return true;
    }

    @Override
    public String getElementType() {
        return ElementType.Job.getValue();
    }

    public String getJobsXID() {
        return ValueHelp.standardRefID(this.jobsXID);
    }

    private String gatJobsXID() {
        return this.jobsXID;
    }

    public void setJobsXID(String i_JobsXID) {
        this.jobsXID = ValueHelp.standardValueID(i_JobsXID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCallFlowXID() {
        return ValueHelp.standardRefID(this.callFlowXID);
    }

    private String gatCallFlowXID() {
        return this.callFlowXID;
    }

    public void setCallFlowXID(String i_CallFlowXID) {
        this.callFlowXID = ValueHelp.standardValueID(i_CallFlowXID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(String i_IntervalType) {
        this.intervalType = i_IntervalType;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getIntervalLen() {
        return this.intervalLen;
    }

    public void setIntervalLen(String i_IntervalLen) {
        this.intervalLen = i_IntervalLen;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String i_Condition) {
        this.condition = i_Condition;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public List<Date> getStartTimes() {
        return this.startTimes;
    }

    public void setStartTimes(List<Date> i_StartTimes) {
        this.startTimes = i_StartTimes;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public void setStartTime(String i_StartTimesStr) {
        String[] v_STimeArr;
        if (Help.isNull((String)i_StartTimesStr)) {
            return;
        }
        this.startTimes = new ArrayList<Date>();
        for (String v_STime : v_STimeArr = StringHelp.replaceAll((String)i_StartTimesStr, (String[])new String[]{"\t", "\n", "\r"}, (String[])new String[]{""}).split(",")) {
            this.startTimes.add(new Date(v_STime.trim()));
        }
        Help.toSort(this.startTimes);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public void executeJobForCallFlow() {
        HashMap<String, Object> v_Context = new HashMap<String, Object>();
        if (!Help.isNull(this.executeContext)) {
            v_Context.putAll(this.executeContext);
        }
        if (!Help.isNull((String)this.context)) {
            try {
                String v_ContextValue = ValueHelp.replaceByContext(this.context, (PartitionMap<String, Integer>)this.contextPlaceholders, v_Context);
                Map v_ContextMap = (Map)ValueHelp.getValue(v_ContextValue, Map.class, null, v_Context);
                v_Context.putAll(v_ContextMap);
                v_ContextMap.clear();
                v_ContextMap = null;
            }
            catch (Exception exce) {
                $Logger.error((Throwable)exce);
                return;
            }
        }
        if (Help.isNull((String)this.gatCallFlowXID())) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s callFlowXID[" + Help.NVL((String)this.callFlowXID, (String)"?") + "] is null."));
            return;
        }
        Object v_CallObject = XJava.getObject((String)this.gatCallFlowXID());
        if (v_CallObject == null) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + this.gatCallFlowXID() + "] is not find."));
            return;
        }
        if (!MethodReflect.isExtendImplement((Object)v_CallObject, ExecuteElement.class)) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + this.gatCallFlowXID() + "] is not ExecuteElement."));
            return;
        }
        ExecuteResult v_Result = CallFlow.execute((ExecuteElement)v_CallObject, v_Context);
        if (v_Result.isSuccess()) {
            $Logger.info("Success\uff1a" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment));
        } else {
            $Logger.error("Failed\uff1a" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "\u3002Error XID = " + v_Result.getExecuteXID(), (Throwable)v_Result.getException());
        }
        ExecuteResult v_FirstResult = CallFlow.getFirstResult(v_Context);
        $Logger.info("\n" + CallFlow.getHelpLog().logs(v_FirstResult));
        v_Context.clear();
        v_Context = null;
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            if (Help.isNull((String)this.xid)) {
                v_Result.setException(new NullPointerException("JOBConfig[" + Help.NVL((String)this.comment) + "]'s XID is null."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            String v_IntervalType = (String)ValueHelp.getValue(this.getIntervalType(), String.class, null, io_Context);
            JobIntervalType v_JobIntervalType = JobIntervalType.get(v_IntervalType);
            if (v_JobIntervalType == null) {
                v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s intervalType[" + Help.NVL((String)this.intervalType, (String)"?") + "] is null."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            Integer v_IntervalLen = (Integer)ValueHelp.getValue(this.getIntervalLen(), Integer.class, null, io_Context);
            if (v_IntervalLen == null) {
                v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s intervalLen[" + Help.NVL((String)this.intervalLen, (String)"?") + "] is null."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            if (Help.isNull((String)this.gatCallFlowXID())) {
                v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s callFlowXID[" + Help.NVL((String)this.callFlowXID, (String)"?") + "] is null."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            Object v_CallObject = XJava.getObject((String)this.gatCallFlowXID());
            if (v_CallObject == null) {
                v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + this.gatCallFlowXID() + "] is not find."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            if (!MethodReflect.isExtendImplement((Object)v_CallObject, ExecuteElement.class)) {
                v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + this.gatCallFlowXID() + "] is not ExecuteElement."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            List<Date> v_StartTimes = this.getStartTimes();
            if (Help.isNull(v_StartTimes)) {
                v_StartTimes = new ArrayList<Date>();
                v_StartTimes.add(Date.getNowTime().getFirstTimeOfDay());
            }
            Jobs v_Jobs = null;
            if (Help.isNull((String)this.gatJobsXID())) {
                v_Jobs = (Jobs)XJava.getObject(Jobs.class, (boolean)false);
            } else {
                Object v_JobsObject = XJava.getObject((String)this.gatJobsXID());
                if (!(v_JobsObject instanceof Jobs)) {
                    v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s Jobs[" + this.gatCallFlowXID() + "] is not Jobs."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                v_Jobs = (Jobs)v_JobsObject;
            }
            if (v_Jobs == null) {
                v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s Jobs[" + Help.NVL((String)this.gatJobsXID(), (String)"?") + "] is null."));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            this.executeContext = new HashMap<String, Object>();
            if (!Help.isNull(io_Context)) {
                for (Map.Entry<String, Object> v_Item : io_Context.entrySet()) {
                    if (CallFlow.isSystemXID(v_Item.getKey())) continue;
                    this.executeContext.put(v_Item.getKey(), v_Item.getValue());
                }
            }
            if (this.job != null) {
                this.delJobByJobs(v_Jobs, this.job.getCode());
            }
            this.job = new Job();
            this.job.setXJavaID("JOB_" + this.getXid());
            this.job.setCode("JOB_" + this.getXid());
            this.job.setName(this.getComment());
            this.job.setComment(this.getComment());
            this.job.setIntervalType(v_JobIntervalType.getInterval().intValue());
            this.job.setIntervalLen(v_IntervalLen.intValue());
            this.job.setStartTimes(v_StartTimes);
            this.job.setCondition(this.getCondition());
            this.job.setXid(this.getXid());
            this.job.setMethodName("executeJobForCallFlow");
            XJava.putObject((String)this.getXid(), (Object)this);
            XJava.putObject((String)("JOB_" + this.getXid()), (Object)this.job);
            v_Jobs.addJob(this.job);
            v_Result.setResult(true);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    private void delJobByJobs(Jobs i_Jobs, String i_Code) {
        Iterator v_JobList = i_Jobs.getJobs();
        while (v_JobList.hasNext()) {
            Job v_Item = (Job)v_JobList.next();
            if (!v_Item.getCode().equals(i_Code)) continue;
            i_Jobs.delJob(v_Item);
            break;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Job.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.gatJobsXID())) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("jobsXID", this.getJobsXID()));
            }
            if (!Help.isNull((String)this.gatCallFlowXID())) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("callFlowXID", this.getCallFlowXID()));
            }
            if (!Help.isNull((String)this.intervalType)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("intervalType", this.intervalType));
            }
            if (!Help.isNull((String)this.intervalLen)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("intervalLen", this.intervalLen));
            }
            if (!Help.isNull((String)this.condition)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("condition", this.condition));
            }
            if (!Help.isNull(this.startTimes)) {
                for (Date v_StartTime : this.startTimes) {
                    v_Xml.append(v_NewSpace).append(IToXml.toValue("startTime", v_StartTime));
                }
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        JobIntervalType v_JobIntervalType = null;
        Integer v_IntervalLen = null;
        try {
            String v_IntervalType = (String)ValueHelp.getValue(this.getIntervalType(), String.class, null, i_Context);
            v_JobIntervalType = JobIntervalType.get(v_IntervalType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v_IntervalLen = (Integer)ValueHelp.getValue(this.getIntervalLen(), Integer.class, null, i_Context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (v_JobIntervalType == null && v_IntervalLen == null) {
            v_Builder.append("\u672a\u77e5\u95f4\u9694\uff0c\u672a\u77e5\u5468\u671f");
        } else if (v_JobIntervalType == null) {
            v_Builder.append("\u95f4\u9694").append(v_IntervalLen).append("\uff0c\u672a\u77e5\u5468\u671f");
        } else if (v_IntervalLen == null) {
            v_Builder.append("\u672a\u77e5\u95f4\u9694\uff0c").append(v_JobIntervalType.getComment());
        } else if (v_JobIntervalType.equals((Object)JobIntervalType.Manual)) {
            v_Builder.append(v_JobIntervalType.getComment());
        } else {
            v_Builder.append("\u95f4\u9694 ").append(v_IntervalLen).append(" ").append(v_JobIntervalType.getComment()).append(" \u5468\u671f\u6267\u884c");
        }
        if (Help.isNull((String)this.gatCallFlowXID())) {
            v_Builder.append("?");
        } else {
            v_Builder.append(this.getCallFlowXID());
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (Help.isNull((String)this.intervalType) && Help.isNull((String)this.intervalLen)) {
            v_Builder.append("\u672a\u77e5\u95f4\u9694\uff0c\u672a\u77e5\u5468\u671f");
        } else if (Help.isNull((String)this.intervalType)) {
            v_Builder.append("\u95f4\u9694").append(this.intervalLen).append("\uff0c\u672a\u77e5\u5468\u671f");
        } else if (Help.isNull((String)this.intervalLen)) {
            v_Builder.append("\u672a\u77e5\u95f4\u9694\uff0c").append(this.intervalType);
        } else {
            v_Builder.append("\u95f4\u9694 ").append(this.intervalLen).append(" ").append(this.intervalType).append(" \u5468\u671f\u6267\u884c");
        }
        if (Help.isNull((String)this.gatCallFlowXID())) {
            v_Builder.append("?");
        } else {
            v_Builder.append(this.getCallFlowXID());
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new JOBConfig();
    }

    @Override
    public Object cloneMyOnly() {
        JOBConfig v_Clone = new JOBConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.jobsXID = this.jobsXID;
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.intervalType = this.intervalType;
        v_Clone.intervalLen = this.intervalLen;
        v_Clone.condition = this.condition;
        if (!Help.isNull(this.startTimes)) {
            for (Date v_Time : this.startTimes) {
                v_Clone.setStartTime(v_Time.getFull());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone JOBConfig xid is null.");
        }
        JOBConfig v_Clone = (JOBConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.jobsXID = this.jobsXID;
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.intervalType = this.intervalType;
        v_Clone.intervalLen = this.intervalLen;
        v_Clone.condition = this.condition;
        if (!Help.isNull(this.startTimes)) {
            for (Date v_Time : this.startTimes) {
                v_Clone.setStartTime(v_Time.getFull());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone JOBConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        JOBConfig v_Clone = new JOBConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

