/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.callflow.cache.ICache;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.XJavaObject;

public class CacheLocal<Data>
implements ICache<Data> {
    private static final String $Level = ">";
    private Class<Data> dataClass;

    public CacheLocal(Class<Data> i_DataClass) {
        this.dataClass = i_DataClass;
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Data i_Data) {
        XJava.putObject((String)(i_Database + $Level + i_Table + $Level + i_ID), i_Data);
        return 1L;
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Data i_Data, long i_ExpireTime) {
        XJava.putObject((String)(i_Database + $Level + i_Table + $Level + i_ID), i_Data, (long)i_ExpireTime);
        return 1L;
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Map<String, Object> i_Datas, Long i_ExpireTime) {
        XJava.putObject((String)(i_Database + $Level + i_Table + $Level + i_ID), i_Datas, (long)i_ExpireTime);
        return 1L;
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Object i_Datas, boolean i_HaveNullValue, Long i_ExpireTime) {
        String v_XID = i_Database + $Level + i_Table + $Level + i_ID;
        Object v_Old = XJava.getObject((String)v_XID);
        if (v_Old == null) {
            XJava.putObject((String)v_XID, (Object)i_Datas, (long)i_ExpireTime);
            return 1L;
        }
        XJava.putObject((String)v_XID, (Object)i_Datas, (long)i_ExpireTime);
        return 1L;
    }

    @Override
    public Data remove(String i_Database, String i_Table, String i_ID) {
        Object v_Old = XJava.getObject((String)(i_Database + $Level + i_Table + $Level + i_ID));
        if (v_Old != null) {
            XJava.remove((String)i_ID);
        }
        return (Data)v_Old;
    }

    @Override
    public synchronized boolean dropTable(String i_Database, String i_Table) {
        Map v_Datas = XJava.getObjects((String)(i_Database + $Level + i_Table + $Level));
        if (!Help.isNull((Map)v_Datas)) {
            for (String v_Key : v_Datas.keySet()) {
                XJava.remove((String)v_Key);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean dropDatabase(String i_Database) {
        Map v_Datas = XJava.getObjects((String)(i_Database + $Level));
        if (!Help.isNull((Map)v_Datas)) {
            for (String v_Key : v_Datas.keySet()) {
                XJava.remove((String)v_Key);
            }
            return true;
        }
        return false;
    }

    @Override
    public Data get(String i_Database, String i_Table, String i_ID) {
        return this.getRow(i_Database, i_Table, i_ID);
    }

    @Override
    public Data getRow(String i_Database, String i_Table, String i_ID) {
        Object v_Object = XJava.getObject((String)(i_Database + $Level + i_Table + $Level + i_ID), (boolean)false);
        return this.toData(v_Object);
    }

    private Data toData(Object i_Data) {
        if (this.dataClass != null) {
            if (i_Data == null) {
                return null;
            }
            if (i_Data.getClass().equals(this.dataClass)) {
                return (Data)i_Data;
            }
            if (MethodReflect.isExtendImplement((Object)i_Data, Map.class)) {
                Data v_Data = null;
                try {
                    v_Data = this.dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exce) {
                    throw new RuntimeException(exce);
                }
                Help.setValues(v_Data, (Map)((Map)i_Data));
                return v_Data;
            }
            if (i_Data instanceof String) {
                XJSON v_XJson = new XJSON();
                return (Data)v_XJson.toJava((String)i_Data, this.dataClass);
            }
        }
        return (Data)i_Data;
    }

    @Override
    public Map<String, String> getRows(String i_Database) {
        Map v_Datas = XJava.getMetadatas((String)(i_Database + $Level));
        HashMap<String, String> v_Ret = new HashMap<String, String>();
        if (!Help.isNull((Map)v_Datas)) {
            for (Map.Entry v_Item : v_Datas.entrySet()) {
                v_Ret.put((String)v_Item.getKey(), ((XJavaObject)v_Item.getValue()).getCreateTime().getFull());
            }
            v_Datas.clear();
        }
        return v_Ret;
    }

    @Override
    public Map<String, Data> getRowsMap(String i_Database, String i_Table) {
        Map v_Datas = XJava.getObjects((String)(i_Database + $Level + i_Table + $Level), (boolean)false);
        HashMap<String, Data> v_Ret = new HashMap<String, Data>();
        if (!Help.isNull((Map)v_Datas)) {
            for (Map.Entry v_Item : v_Datas.entrySet()) {
                if (v_Item.getValue() == null || !v_Item.getValue().getClass().equals(this.dataClass)) continue;
                v_Ret.put((String)v_Item.getKey(), this.toData(v_Item.getValue()));
            }
            v_Datas.clear();
            v_Datas = null;
        }
        return v_Ret;
    }

    @Override
    public List<Data> getRowsList(String i_Database, String i_Table) {
        Map v_Datas = XJava.getObjects((String)(i_Database + $Level + i_Table + $Level), (boolean)false);
        ArrayList<Data> v_Ret = new ArrayList<Data>();
        if (!Help.isNull((Map)v_Datas)) {
            for (Map.Entry v_Item : v_Datas.entrySet()) {
                if (v_Item.getValue() == null || !v_Item.getValue().getClass().equals(this.dataClass)) continue;
                v_Ret.add(this.toData(v_Item.getValue()));
            }
            v_Datas.clear();
            v_Datas = null;
        }
        return v_Ret;
    }

    @Override
    public Boolean set(String i_Key, String i_Value) {
        XJava.putObject((String)i_Key, (Object)i_Value);
        return true;
    }

    @Override
    public Boolean setex(String i_Key, String i_Value, Long i_ExpireTime) {
        XJava.putObject((String)i_Key, (Object)i_Value, (long)i_ExpireTime);
        return true;
    }

    @Override
    public synchronized Boolean setnx(String i_Key, String i_Value) {
        if (XJava.getObject((String)i_Key) == null) {
            XJava.putObject((String)i_Key, (Object)i_Value);
            return true;
        }
        return false;
    }

    @Override
    public String get(String i_Key) {
        Object v_Value = XJava.getObject((String)i_Key);
        if (v_Value != null) {
            return v_Value.toString();
        }
        return null;
    }

    @Override
    public synchronized String getdel(String i_Key) {
        String v_Value = this.get(i_Key);
        XJava.remove((String)v_Value);
        return v_Value;
    }

    @Override
    public synchronized Long del(String ... i_Keys) {
        if (!Help.isNull((Object[])i_Keys)) {
            long v_Count = 0L;
            for (String v_Key : i_Keys) {
                XJava.remove((String)v_Key);
                ++v_Count;
            }
            return v_Count;
        }
        return 0L;
    }

    @Override
    public synchronized Long delete(String i_Database, String i_Table, String i_ID) {
        String v_XID = i_Database + $Level + i_Table + $Level + i_ID;
        if (XJava.getObject((String)v_XID) != null) {
            XJava.remove((String)v_XID);
            return 1L;
        }
        return 0L;
    }
}

