/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.cache;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.cache.CacheFactory;
import org.hy.common.callflow.cache.ICache;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.redis.IRedis;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class CacheGetConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(CacheGetConfig.class);
    private String cacheXID;
    private String dataBase;
    private String table;
    private String pkID;
    private Boolean allowDelValue = false;
    private String rowClass = null;
    private Boolean returnListOrMap = true;
    private ICache<?> cache;
    private boolean isInit = false;

    public CacheGetConfig() {
        this(0L, 0L);
    }

    public CacheGetConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public boolean check(Return<Object> io_Result) {
        if (!Help.isNull((String)this.getTable()) && Help.isNull((String)this.getDataBase())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getDataBase()) + "].database is null ,but table is not null.");
            return false;
        }
        if (!Help.isNull((String)this.getPkID()) && !Help.isNull((String)this.getDataBase()) && Help.isNull((String)this.getTable())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1a" + this.getClass().getSimpleName() + "[" + Help.NVL((String)this.getTable()) + "].table is null ,but database and pkID are not null.");
            return false;
        }
        return true;
    }

    public String getCacheXID() {
        if (Help.isNull((String)this.cacheXID)) {
            return null;
        }
        return ":" + this.cacheXID;
    }

    public void setCacheXID(String i_CacheXID) {
        this.cacheXID = ValueHelp.standardValueID(i_CacheXID);
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private synchronized ICache<?> gatCache() {
        if (!this.isInit) {
            Object v_Cache;
            Class<Object> v_RowClass = this.gatRowClass();
            if (v_RowClass == null) {
                v_RowClass = HashMap.class;
            }
            this.cache = !Help.isNull((String)this.cacheXID) ? ((v_Cache = XJava.getObject((String)this.cacheXID)) == null ? CacheFactory.newInstanceOf(null, v_RowClass) : (v_Cache instanceof IRedis ? CacheFactory.newInstanceOf((IRedis)v_Cache, v_RowClass) : CacheFactory.newInstanceOf(null, v_RowClass))) : CacheFactory.newInstanceOf(null, v_RowClass);
            this.isInit = true;
        }
        return this.cache;
    }

    public String getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(String i_DataBase) {
        this.dataBase = i_DataBase;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String i_Table) {
        this.table = i_Table;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPkID() {
        return this.pkID;
    }

    public void setPkID(String i_PkID) {
        this.pkID = i_PkID;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getAllowDelValue() {
        return this.allowDelValue;
    }

    public void setAllowDelValue(Boolean i_AllowDelValue) {
        this.allowDelValue = i_AllowDelValue;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getReturnList() {
        return this.returnListOrMap == false;
    }

    public void setReturnList(Boolean i_ReturnList) {
        this.returnListOrMap = i_ReturnList == false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getReturnMap() {
        return this.returnListOrMap;
    }

    public void setReturnMap(Boolean i_ReturnMap) {
        this.returnListOrMap = i_ReturnMap;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Class<?> gatRowClass() {
        if (!Help.isNull((String)this.rowClass)) {
            try {
                return Help.forName((String)this.rowClass);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return null;
    }

    public String getRowClass() {
        return this.rowClass;
    }

    public void setRowClass(String i_RowClass) {
        this.rowClass = i_RowClass;
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String getElementType() {
        return ElementType.CacheGet.getValue();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            this.gatCache();
            Object v_CacheRetDatas = null;
            if (!Help.isNull((String)this.dataBase)) {
                String v_DataBase = (String)ValueHelp.getValue(this.dataBase, String.class, "", io_Context);
                if (Help.isNull((String)v_DataBase)) {
                    v_Result.setException(new RuntimeException(this.getXid() + " database[" + this.dataBase + "] is not exists."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                if (!Help.isNull((String)this.table)) {
                    String v_Table = (String)ValueHelp.getValue(this.table, String.class, "", io_Context);
                    if (Help.isNull((String)v_Table)) {
                        v_Result.setException(new RuntimeException(this.getXid() + " table[" + this.table + "] is not exists."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    if (!Help.isNull((String)this.pkID)) {
                        String v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", io_Context);
                        if (Help.isNull((String)v_PKID)) {
                            v_Result.setException(new RuntimeException(this.getXid() + " pkID[" + this.pkID + "] is not exists."));
                            this.refreshStatus(io_Context, v_Result.getStatus());
                            return v_Result;
                        }
                        v_CacheRetDatas = this.cache.getRow(v_DataBase, v_Table, v_PKID);
                    } else {
                        v_CacheRetDatas = this.returnListOrMap.booleanValue() ? this.cache.getRowsMap(v_DataBase, v_Table) : this.cache.getRowsList(v_DataBase, v_Table);
                    }
                } else {
                    v_CacheRetDatas = this.cache.getRows(v_DataBase);
                }
            } else if (!Help.isNull((String)this.pkID)) {
                String v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", io_Context);
                if (Help.isNull((String)v_PKID)) {
                    v_Result.setException(new RuntimeException(this.getXid() + " pkID[" + this.pkID + "] is not exists."));
                    this.refreshStatus(io_Context, v_Result.getStatus());
                    return v_Result;
                }
                v_CacheRetDatas = this.allowDelValue != false ? this.cache.getdel(v_PKID) : this.cache.get(v_PKID);
            }
            v_Result.setResult(v_CacheRetDatas);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.CacheGet.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.cacheXID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("cacheXID", this.getCacheXID()));
            }
            if (!Help.isNull((String)this.dataBase)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("dataBase", this.dataBase));
            }
            if (!Help.isNull((String)this.table)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("table", this.table));
            }
            if (!Help.isNull((String)this.pkID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("pkID", this.pkID));
            }
            if (!Help.isNull((Object)this.allowDelValue) && this.allowDelValue.booleanValue()) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("allowDelValue", this.allowDelValue));
            }
            if (!Help.isNull((String)this.rowClass)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("rowClass", this.rowClass));
            }
            if (!Help.isNull((Object)this.returnListOrMap) && !this.returnListOrMap.booleanValue()) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnList", this.returnListOrMap == false));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
            this.toXmlExecute(v_Xml, v_NewSpace);
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        if (!Help.isNull((String)this.cacheXID)) {
            v_Builder.append(this.getCacheXID());
            if (XJava.getObject((String)this.cacheXID) == null) {
                v_Builder.append(" is NULL");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (!Help.isNull((String)this.dataBase)) {
            String v_Database = null;
            try {
                v_Database = (String)ValueHelp.getValue(this.dataBase, String.class, "", i_Context);
            }
            catch (Exception exce) {
                $Logger.error(this.getXid() + ".Database[" + this.dataBase + "] is error", (Throwable)exce);
            }
            if (!Help.isNull((String)v_Database)) {
                v_Builder.append(v_Database);
            } else {
                v_Builder.append("[").append(this.dataBase).append("=?]");
            }
            v_Builder.append(".");
            if (!Help.isNull((String)this.table)) {
                String v_Table = null;
                try {
                    v_Table = (String)ValueHelp.getValue(this.table, String.class, "", i_Context);
                }
                catch (Exception exce) {
                    $Logger.error(this.getXid() + ".Table[" + this.table + "] is error", (Throwable)exce);
                }
                if (!Help.isNull((String)v_Table)) {
                    v_Builder.append(v_Table);
                } else {
                    v_Builder.append("[").append(this.table).append("=?]");
                }
                v_Builder.append(".");
                if (!Help.isNull((String)this.pkID)) {
                    String v_PKID = null;
                    try {
                        v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", i_Context);
                    }
                    catch (Exception exce) {
                        $Logger.error(this.getXid() + ".PKID[" + this.pkID + "] is error", (Throwable)exce);
                    }
                    if (!Help.isNull((String)v_PKID)) {
                        v_Builder.append(v_PKID);
                    } else {
                        v_Builder.append("[").append(this.pkID).append("=?]");
                    }
                } else {
                    v_Builder.append("\u8868\u4e2d\u5168\u90e8\u6570\u636e");
                }
            } else {
                v_Builder.append("\u5e93\u4e2d\u5168\u90e8\u8868");
            }
        } else if (!Help.isNull((String)this.pkID)) {
            String v_PKID = null;
            try {
                v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", i_Context);
            }
            catch (Exception exce) {
                $Logger.error(this.getXid() + ".PKID[" + this.pkID + "] is error", (Throwable)exce);
            }
            if (this.allowDelValue.booleanValue()) {
                v_Builder.append("getdel(").append(Help.NVL((String)v_PKID, (String)(this.pkID + "=?"))).append(")");
            } else {
                v_Builder.append(Help.NVL((String)v_PKID, (String)(this.pkID + "=?")));
            }
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        if (!Help.isNull((String)this.cacheXID)) {
            v_Builder.append(this.getCacheXID());
            if (XJava.getObject((String)this.cacheXID) == null) {
                v_Builder.append(" is NULL");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (!Help.isNull((String)this.dataBase)) {
            v_Builder.append(this.dataBase);
            v_Builder.append(".");
            if (!Help.isNull((String)this.table)) {
                v_Builder.append(this.table);
                v_Builder.append(".");
                if (!Help.isNull((String)this.pkID)) {
                    v_Builder.append(this.pkID);
                } else {
                    v_Builder.append("\u8868\u4e2d\u5168\u90e8\u6570\u636e");
                }
            } else {
                v_Builder.append("\u5e93\u4e2d\u5168\u90e8\u8868");
            }
        } else if (!Help.isNull((String)this.pkID)) {
            if (this.allowDelValue.booleanValue()) {
                v_Builder.append("getdel(").append(this.pkID).append(")");
            } else {
                v_Builder.append(this.pkID);
            }
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new CacheGetConfig();
    }

    @Override
    public Object cloneMyOnly() {
        CacheGetConfig v_Clone = new CacheGetConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.cacheXID = this.cacheXID;
        v_Clone.dataBase = this.dataBase;
        v_Clone.table = this.table;
        v_Clone.pkID = this.pkID;
        v_Clone.allowDelValue = this.allowDelValue;
        v_Clone.rowClass = this.rowClass;
        v_Clone.returnListOrMap = this.returnListOrMap;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CacheGetConfig xid is null.");
        }
        CacheGetConfig v_Clone = (CacheGetConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.cacheXID = this.cacheXID;
        v_Clone.dataBase = this.dataBase;
        v_Clone.table = this.table;
        v_Clone.pkID = this.pkID;
        v_Clone.allowDelValue = this.allowDelValue;
        v_Clone.rowClass = this.rowClass;
        v_Clone.returnListOrMap = this.returnListOrMap;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CacheGetConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        CacheGetConfig v_Clone = new CacheGetConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

