/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.route;

import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.XJavaID;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.cache.CacheGetConfig;
import org.hy.common.callflow.cache.CacheSetConfig;
import org.hy.common.callflow.clone.CloneableCallFlow;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.enums.SelfLoopType;
import org.hy.common.callflow.event.JOBConfig;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.forloop.ForConfig;
import org.hy.common.callflow.ifelse.ConditionConfig;
import org.hy.common.callflow.nesting.NestingConfig;
import org.hy.common.callflow.node.CalculateConfig;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.WaitConfig;
import org.hy.common.callflow.python.PythonConfig;
import org.hy.common.callflow.returns.ReturnConfig;
import org.hy.common.callflow.route.RouteConfig;
import org.hy.common.callflow.route.SelfLoop;

public class RouteItem
implements IToXml,
CloneableCallFlow,
XJavaID {
    private RouteConfig owner;
    private RouteType routeType;
    private String id;
    private String xid;
    private String comment;
    private String pathDatas;
    private String lineStyle;
    private String lineColor;
    private Double lineSize;
    private String fontColor;
    private String fontFamily;
    private String fontWeight;
    private Double fontSize;
    private String fontAlign;
    private String createUserID;
    private String updateUserID;
    private Date createTime;
    private Date updateTime;
    private ExecuteElement next;

    public RouteItem(RouteConfig i_Route, RouteType i_RouteType) {
        this.owner = i_Route;
        this.routeType = i_RouteType;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public SelfLoopType getSelfLoopType() {
        if (this.next == null) {
            return SelfLoopType.Normal;
        }
        if (this.next instanceof SelfLoop) {
            SelfLoop v_SelfLoop = (SelfLoop)this.next;
            ExecuteElement v_Owner = this.owner.gatOwner();
            ExecuteElement v_RefExecute = v_SelfLoop.gatExecuteElement();
            if (ElementType.For.getValue().equals(v_RefExecute.getElementType())) {
                if (v_Owner == v_RefExecute || v_Owner.getXid().equals(v_RefExecute.getXid())) {
                    throw new RuntimeException("SelfLoop.RefXID[" + v_SelfLoop.getRefXID() + "] ref ForConfig[" + v_Owner.getXid() + "] myself.");
                }
                return SelfLoopType.For;
            }
            if (v_Owner == v_RefExecute || v_Owner.getXid().equals(v_RefExecute.getXid())) {
                return SelfLoopType.MySelf;
            }
            return SelfLoopType.While;
        }
        return SelfLoopType.Normal;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String i_Id) {
        this.id = i_Id;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String i_Comment) {
        this.comment = i_Comment;
    }

    public String getPathDatas() {
        return this.pathDatas;
    }

    public void setPathDatas(String i_PathDatas) {
        this.pathDatas = i_PathDatas;
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String i_LineStyle) {
        this.lineStyle = i_LineStyle;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(String i_LineColor) {
        this.lineColor = i_LineColor;
    }

    public Double getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(Double i_LineSize) {
        this.lineSize = i_LineSize;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String i_FontColor) {
        this.fontColor = i_FontColor;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String i_FontFamily) {
        this.fontFamily = i_FontFamily;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String i_FontWeight) {
        this.fontWeight = i_FontWeight;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double i_FontSize) {
        this.fontSize = i_FontSize;
    }

    public String getFontAlign() {
        return this.fontAlign;
    }

    public void setFontAlign(String i_FontAlign) {
        this.fontAlign = i_FontAlign;
    }

    public String getCreateUserID() {
        return this.createUserID;
    }

    public void setCreateUserID(String i_CreateUserID) {
        this.createUserID = i_CreateUserID;
    }

    public String getUpdateUserID() {
        return this.updateUserID;
    }

    public void setUpdateUserID(String i_UpdateUserID) {
        this.updateUserID = i_UpdateUserID;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date i_CreateTime) {
        this.createTime = i_CreateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date i_UpdateTime) {
        this.updateTime = i_UpdateTime;
    }

    public ExecuteElement gatNext() {
        return this.next;
    }

    public void setNext(ExecuteElement i_Next) {
        this.next = i_Next;
    }

    public void setNext(String i_RefXID) {
        this.setNext(new SelfLoop(this, i_RefXID));
        this.owner.orderBy();
    }

    public void setOwner(RouteConfig i_Owner) {
        this.owner = i_Owner;
    }

    public RouteConfig gatOwner() {
        return this.owner;
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)(i_Level + 1), (String)v_Level1);
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (this.id != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("id", this.id));
            }
            if (!Help.isNull((String)this.comment)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("comment", this.comment));
            }
        } else if (!Help.isNull((String)this.comment)) {
            v_Xml.append(v_NewSpace).append(IToXml.toComment(this.comment));
        }
        if (ExportType.UI.equals((Object)i_ExportType) || ExportType.All.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.lineStyle)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("lineStyle", this.lineStyle));
            }
            if (!Help.isNull((String)this.lineColor)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("lineColor", this.lineColor));
            }
            if (!Help.isNull((Double)this.lineSize)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("lineSize", this.lineSize));
            }
            if (!Help.isNull((String)this.fontColor)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontColor", this.fontColor));
            }
            if (!Help.isNull((String)this.fontFamily)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontFamily", this.fontFamily));
            }
            if (!Help.isNull((String)this.fontWeight)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontWeight", this.fontWeight));
            }
            if (!Help.isNull((Double)this.fontSize)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontSize", this.fontSize));
            }
            if (!Help.isNull((String)this.fontAlign)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontAlign", this.fontAlign));
            }
            if (!Help.isNull((String)this.createUserID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("createUserID", this.createUserID));
            }
            if (!Help.isNull((String)this.updateUserID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("updateUserID", this.updateUserID));
            }
            if (this.createTime != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("createTime", this.createTime.getFull()));
            }
            if (this.updateTime != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("updateTime", this.updateTime.getFull()));
            }
            if (!Help.isNull((String)this.pathDatas)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("pathDatas", this.pathDatas, v_NewSpace));
            }
        }
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (this.next instanceof SelfLoop) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("next", ((SelfLoop)this.next).getRefXID()));
            } else if (!Help.isNull((String)this.next.getXJavaID())) {
                v_Xml.append(v_NewSpace).append(IToXml.toRef("next", this.next.getXJavaID()));
            } else {
                v_Xml.append(this.next.toXml(i_Level + 1, i_SuperTreeID, i_ExportType));
            }
        }
        return v_Xml.toString();
    }

    @Override
    public Object newMy() {
        throw new RuntimeException("Not allowed to call RouteItem.newMy().");
    }

    @Override
    public Object cloneMyOnly() {
        throw new RuntimeException("Not allowed to call RouteItem.cloneMyOnly().");
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        RouteItem v_Clone = (RouteItem)io_Clone;
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.pathDatas = this.pathDatas;
        v_Clone.lineStyle = this.lineStyle;
        v_Clone.lineColor = this.lineColor;
        v_Clone.lineSize = this.lineSize;
        v_Clone.fontColor = this.fontColor;
        v_Clone.fontFamily = this.fontFamily;
        v_Clone.fontWeight = this.fontWeight;
        v_Clone.fontSize = this.fontSize;
        v_Clone.fontAlign = this.fontAlign;
        v_Clone.createUserID = this.createUserID;
        v_Clone.updateUserID = this.updateUserID;
        v_Clone.createTime = this.createTime == null ? null : new Date(this.createTime.getTime());
        Date date = v_Clone.updateTime = this.updateTime == null ? null : new Date(this.updateTime.getTime());
        if (this.next != null) {
            if (this.next instanceof NodeConfig) {
                Object v_CloneNode = this.next.newMy();
                ((CloneableCallFlow)v_CloneNode).clone(v_CloneNode, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = (ExecuteElement)v_CloneNode;
            } else if (this.next instanceof WaitConfig) {
                WaitConfig v_CloneWait = new WaitConfig();
                ((WaitConfig)this.next).clone(v_CloneWait, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneWait;
            } else if (this.next instanceof ConditionConfig) {
                ConditionConfig v_CloneCondition = new ConditionConfig();
                ((ConditionConfig)this.next).clone(v_CloneCondition, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneCondition;
            } else if (this.next instanceof NestingConfig) {
                NestingConfig v_CloneNesting = new NestingConfig();
                ((NestingConfig)this.next).clone(v_CloneNesting, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneNesting;
            } else if (this.next instanceof CalculateConfig) {
                CalculateConfig v_CloneCalculate = new CalculateConfig();
                ((CalculateConfig)this.next).clone(v_CloneCalculate, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneCalculate;
            } else if (this.next instanceof ForConfig) {
                ForConfig v_CloneFor = new ForConfig();
                ((ForConfig)this.next).clone(v_CloneFor, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneFor;
            } else if (this.next instanceof ReturnConfig) {
                ReturnConfig v_CloneReturn = new ReturnConfig();
                ((ReturnConfig)this.next).clone(v_CloneReturn, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneReturn;
            } else if (this.next instanceof CacheGetConfig) {
                CacheGetConfig v_CloneCacheGet = new CacheGetConfig();
                ((CacheGetConfig)this.next).clone(v_CloneCacheGet, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneCacheGet;
            } else if (this.next instanceof CacheSetConfig) {
                CacheSetConfig v_CloneCacheSet = new CacheSetConfig();
                ((CacheSetConfig)this.next).clone(v_CloneCacheSet, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneCacheSet;
            } else if (this.next instanceof JOBConfig) {
                JOBConfig v_CloneReturn = new JOBConfig();
                ((JOBConfig)this.next).clone(v_CloneReturn, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneReturn;
            } else if (this.next instanceof PythonConfig) {
                PythonConfig v_CloneReturn = new PythonConfig();
                ((PythonConfig)this.next).clone(v_CloneReturn, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.next = v_CloneReturn;
            } else {
                if (this.next instanceof SelfLoop) {
                    throw new RuntimeException("Not allowed RouteItem's next is SelfLoop");
                }
                throw new RuntimeException("Unknown type[" + this.next.getClass().getName() + "] of exception");
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new RuntimeException("Not allowed to call RouteItem.clone().");
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String i_Xid) {
        if (CallFlow.isSystemXID(i_Xid)) {
            throw new IllegalArgumentException("RouteItem XID[" + i_Xid + "] is SystemXID.");
        }
        this.xid = i_Xid;
    }

    public void setXJavaID(String i_XJavaID) {
        if (CallFlow.isSystemXID(i_XJavaID)) {
            throw new IllegalArgumentException("RouteItem XJavaID[" + i_XJavaID + "] is SystemXID.");
        }
        this.xid = i_XJavaID;
    }

    public String getXJavaID() {
        return this.xid;
    }
}

