/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.returns;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.returns.ReturnData;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.log.Logger;

public class ReturnConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(ReturnConfig.class);
    private String retClass = ReturnData.class.getName();
    private String retValue;
    private PartitionMap<String, Integer> retValuePlaceholders;
    private String retDefault;
    private Object retDefaultObject;

    public ReturnConfig() {
        this(0L, 0L);
    }

    public ReturnConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public String getElementType() {
        return ElementType.Return.getValue();
    }

    public synchronized Object gatRetDefaultObject() throws Exception {
        if (this.retDefault == null || this.retClass == null) {
            return null;
        }
        if (this.retDefaultObject == null) {
            Class<?> v_RetClass = this.gatRetClass();
            if (Help.isBasicDataType(v_RetClass)) {
                this.retDefaultObject = Help.toObject(v_RetClass, (String)this.retDefault);
            } else {
                XJSON v_XJson = new XJSON();
                this.retDefaultObject = v_XJson.toJava(this.retDefault, v_RetClass);
            }
        }
        return this.retDefaultObject;
    }

    public Class<?> gatRetClass() {
        if (!Help.isNull((String)this.retClass)) {
            try {
                return Help.forName((String)this.retClass);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return null;
    }

    public String getRetClass() {
        return this.retClass;
    }

    public void setRetClass(String i_RetClass) {
        this.retClass = Void.class.getName().equals(i_RetClass) ? null : i_RetClass;
        this.retDefaultObject = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getRetValue() {
        return this.retValue;
    }

    public synchronized void setRetValue(String i_RetValue) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_RetValue)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_RetValue, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.retValuePlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.retValuePlaceholders = new TablePartitionLink();
        }
        this.retValue = i_RetValue;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getRetDefault() {
        return this.retDefault;
    }

    public void setRetDefault(String i_RetDefault) {
        this.retDefault = i_RetDefault;
        this.retDefaultObject = null;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public boolean isReturn() {
        return Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getErrors());
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            String v_RetValue = null;
            v_RetValue = !Help.isNull((String)this.retValue) ? ValueHelp.replaceByContext(this.retValue, this.retValuePlaceholders, io_Context) : this.retValue;
            Object v_Value = ValueHelp.getValue(v_RetValue, this.gatRetClass(), this.gatRetDefaultObject(), io_Context);
            if (this.isReturn()) {
                io_Context.put("CallFlowReturn", true);
                io_Context.put("CallFlowReturnValue", v_Value);
            }
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result.setResult(v_Value);
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Return.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.retClass) && !this.retClass.equals(ReturnData.class.getName())) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("retClass", this.gatRetClass().getName()));
            }
            if (!Help.isNull((String)this.retValue)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("retValue", this.retValue, v_NewSpace));
            }
            if (!Help.isNull((String)this.retDefault)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("retDefault", this.retDefault, v_NewSpace));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        Object v_Value = null;
        v_Builder.append("Return\uff1a");
        String v_RetValue = null;
        v_RetValue = !Help.isNull((String)this.retValue) ? ValueHelp.replaceByContext(this.retValue, this.retValuePlaceholders, i_Context) : this.retValue;
        try {
            v_Value = ValueHelp.getValue(v_RetValue, this.gatRetClass(), this.gatRetDefaultObject(), i_Context);
        }
        catch (Exception exce) {
            $Logger.error("ReturnConfig[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s retValue[" + this.retValue + "] getValue error.", (Throwable)exce);
        }
        v_Builder.append(v_Value);
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("Return\uff1a").append(this.retValue);
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new ReturnConfig();
    }

    @Override
    public Object cloneMyOnly() {
        ReturnConfig v_Clone = new ReturnConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.retClass = this.retClass;
        v_Clone.retValue = this.retValue;
        v_Clone.retDefault = this.retDefault;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ReturnConfig xid is null.");
        }
        ReturnConfig v_Clone = (ReturnConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.retClass = this.retClass;
        v_Clone.retValue = this.retValue;
        v_Clone.retDefault = this.retDefault;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone ReturnConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        ReturnConfig v_Clone = new ReturnConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

