/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.xml.log.Logger;

public class WaitConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(WaitConfig.class);
    private String waitTime = "0";
    private String counter = "CallFlowWaitCounter";
    private String counterMax;

    public WaitConfig() {
        this(0L, 0L);
    }

    public WaitConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public String getElementType() {
        return ElementType.Wait.getValue();
    }

    public String getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(String i_WaitTime) {
        if (Help.isNull((String)i_WaitTime)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s WaitTime is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_WaitTime)) {
            Long v_WaitTime = Long.valueOf(i_WaitTime);
            if (v_WaitTime < 0L) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s WaitTime Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.waitTime = i_WaitTime.trim();
        } else {
            this.waitTime = ValueHelp.standardRefID(i_WaitTime);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCounter() {
        return this.counter;
    }

    public void setCounter(String i_Counter) {
        this.counter = Help.isNull((String)i_Counter) ? "CallFlowWaitCounter" : ValueHelp.standardValueID(i_Counter.trim());
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCounterMax() {
        return this.counterMax;
    }

    public void setCounterMax(String i_CounterMax) {
        if (Help.isNull((String)i_CounterMax)) {
            this.counterMax = null;
        } else if (Help.isNumber((String)i_CounterMax)) {
            Integer v_CounterMax = Integer.valueOf(i_CounterMax);
            if (v_CounterMax <= 0) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CounterMax Less than or Equal to zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.counterMax = i_CounterMax.trim();
        } else {
            this.counterMax = ValueHelp.standardRefID(i_CounterMax);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            Integer v_CounterMax;
            Integer v_Counter;
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            Long v_WaitTime = null;
            v_WaitTime = Help.isNumber((String)this.waitTime) ? Long.valueOf(this.waitTime) : (Long)ValueHelp.getValue(this.waitTime, Long.class, 0L, io_Context);
            if (v_WaitTime > 0L) {
                Thread.sleep(v_WaitTime, 0);
            }
            if ((v_Counter = (Integer)io_Context.get(this.counter)) == null) {
                v_Counter = 1;
                io_Context.put(this.counter, 1);
            } else {
                v_Counter = v_Counter + 1;
                io_Context.put(this.counter, v_Counter);
            }
            boolean v_Ret = true;
            if (!Help.isNull((String)this.counterMax) && (v_CounterMax = (Integer)ValueHelp.getValue(this.counterMax, Integer.class, 0, io_Context)) != null) {
                v_Ret = v_Counter <= v_CounterMax;
            }
            v_Result.setResult(v_Ret);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Wait.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.waitTime)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("waitTime", this.waitTime));
            }
            if (!Help.isNull((String)this.counter)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("counter", this.counter));
            }
            if (!Help.isNull((String)this.counterMax)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("counterMax", this.counterMax));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!(Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getFaileds()) && Help.isNull(this.route.getExceptions()))) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.If.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getFaileds(), RouteType.Else.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getFaileds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getFaileds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder;
        block9: {
            v_Builder = new StringBuilder();
            v_Builder.append("Wait\uff1a");
            if (!Help.isNumber((String)this.waitTime)) {
                v_Builder.append(this.waitTime).append("=");
                Long v_WaitTime = null;
                try {
                    v_WaitTime = (Long)ValueHelp.getValue(this.waitTime, Long.class, null, i_Context);
                    if (v_WaitTime == null) {
                        v_Builder.append("?");
                        break block9;
                    }
                    v_Builder.append(v_WaitTime);
                }
                catch (Exception exce) {
                    v_Builder.append("ERROR");
                    $Logger.error((Throwable)exce);
                }
            } else {
                v_Builder.append(this.waitTime);
            }
        }
        v_Builder.append(" ms");
        if (!Help.isNull((String)this.counter)) {
            Integer v_Counter = (Integer)i_Context.get(this.counter);
            v_Counter = v_Counter == null ? Integer.valueOf(1) : Integer.valueOf(v_Counter + 1);
            v_Builder.append(" Counter\uff1a").append(v_Counter);
        }
        if (!Help.isNull((String)this.counterMax)) {
            v_Builder.append(" CounterMax\uff1a");
            try {
                Integer v_CounterMax = (Integer)ValueHelp.getValue(this.counterMax, Integer.class, 0, i_Context);
                v_Builder.append(v_CounterMax);
            }
            catch (Exception exce) {
                v_Builder.append("ERROR");
                $Logger.error((Throwable)exce);
            }
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        v_Builder.append("Wait\uff1a").append(this.waitTime).append(" ms");
        if (!Help.isNull((String)this.counter)) {
            v_Builder.append(" Counter\uff1a").append(this.counter);
        }
        if (Help.isNull((String)this.counterMax)) {
            v_Builder.append(" Max\uff1a").append(this.counterMax);
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new WaitConfig();
    }

    @Override
    public Object cloneMyOnly() {
        WaitConfig v_Clone = new WaitConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.waitTime = this.waitTime;
        v_Clone.counter = this.counter;
        v_Clone.counterMax = this.counterMax;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone WaitConfig xid is null.");
        }
        WaitConfig v_Clone = (WaitConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.waitTime = this.waitTime;
        v_Clone.counter = this.counter;
        v_Clone.counterMax = this.counterMax;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone WaitConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        WaitConfig v_Clone = new WaitConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

