/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.callflow.timeout.TimeoutConfig;
import org.hy.common.xml.XHttp;
import org.hy.common.xml.XJava;
import org.hy.common.xml.XSQL;
import org.hy.common.xml.log.Logger;
import org.hy.common.xml.plugins.XSQLGroup;

public class NodeConfig
extends ExecuteElement
implements NodeConfigBase,
Cloneable {
    private static final Logger $Logger = new Logger(NodeConfig.class);
    protected String callXID;
    protected String callMethod;
    protected Method callMethodObject;
    protected boolean isInit = false;
    protected List<NodeParam> callParams;
    protected String timeout = "0";

    public NodeConfig() {
        this(0L, 0L);
    }

    public NodeConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public String getElementType() {
        return ElementType.Node.getValue();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        if (Help.isNull((String)this.callXID)) {
            v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallXID is null."));
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
        if (!this.handleContext(io_Context, v_Result)) {
            return v_Result;
        }
        Object v_CallObject = XJava.getObject((String)this.callXID);
        if ((v_CallObject = this.generateObject(io_Context, v_CallObject)) == null) {
            v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallXID[" + this.callXID + "] is not find."));
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
        Object[] v_ParamValues = null;
        if (!Help.isNull(this.callParams)) {
            v_ParamValues = new Object[this.callParams.size()];
            try {
                for (int x = 0; x < v_ParamValues.length; ++x) {
                    NodeParam v_NodeParam = this.callParams.get(x);
                    v_ParamValues[x] = ValueHelp.getValue(v_NodeParam.getValue(), v_NodeParam.gatValueClass(), v_NodeParam.gatValueDefaultObject(), io_Context);
                }
            }
            catch (Exception exce) {
                v_Result.setException(exce);
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
        } else {
            v_ParamValues = new Object[]{};
        }
        try {
            v_ParamValues = this.generateParams(io_Context, v_ParamValues);
            this.init(io_Context, v_CallObject, v_ParamValues);
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
        try {
            Return<Object> v_ExceRet = null;
            Long v_Timeout = this.gatTimeout(io_Context);
            if (v_Timeout > 0L) {
                TimeoutConfig<Object> v_Future = this.executeAsync(v_Timeout, io_Context, v_CallObject, v_ParamValues);
                v_ExceRet = (Return<Object>)v_Future.execute();
                if (!v_Future.isSucceed()) {
                    throw v_Future.getException();
                }
            } else if (Void.TYPE.equals(this.callMethodObject.getReturnType())) {
                this.callMethodObject.invoke(v_CallObject, v_ParamValues);
                v_ExceRet = this.generateReturn(io_Context, Void.TYPE);
            } else {
                v_ExceRet = this.generateReturn(io_Context, this.callMethodObject.invoke(v_CallObject, v_ParamValues));
            }
            if (!v_ExceRet.get()) {
                throw v_ExceRet.getException();
            }
            v_Result.setResult(v_ExceRet.getParamObj());
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            if (exce instanceof TimeoutException) {
                v_Result.setTimeout((TimeoutException)exce);
            } else if (exce.getCause() instanceof TimeoutException) {
                v_Result.setTimeout((TimeoutException)exce.getCause());
            } else {
                v_Result.setException(exce);
            }
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    private TimeoutConfig<Object> executeAsync(Long i_Timeout, Map<String, Object> io_Context, Object i_CallObject, Object[] i_ParamValues) {
        return new TimeoutConfig<Object>(i_Timeout).future(() -> {
            try {
                if (Void.TYPE.equals(this.callMethodObject.getReturnType())) {
                    this.callMethodObject.invoke(i_CallObject, i_ParamValues);
                    return this.generateReturn(io_Context, Void.TYPE);
                }
                return this.generateReturn(io_Context, this.callMethodObject.invoke(i_CallObject, i_ParamValues));
            }
            catch (Exception exce) {
                throw new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] executeAsync error", exce);
            }
        });
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        return io_ExecuteObject;
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        return io_Params;
    }

    public void generateInit(Map<String, Object> io_Context, Object i_ExecuteObject, Object[] i_Params) {
    }

    @Override
    public Return<Object> generateReturn(Map<String, Object> io_Context, Object io_ExecuteReturn) {
        return new Return(true).setParamObj(io_ExecuteReturn);
    }

    public synchronized void init(Map<String, Object> io_Context) {
        if (this.isInit) {
            return;
        }
        if (Help.isNull((String)this.callXID)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallXID is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        Object v_CallObject = XJava.getObject((String)this.callXID);
        if (v_CallObject == null) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallXID[" + this.getCallXID() + "] is not find.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        Object[] v_ParamValues = null;
        if (!Help.isNull(this.callParams)) {
            v_ParamValues = new Object[this.callParams.size()];
            try {
                for (int x = 0; x < v_ParamValues.length; ++x) {
                    NodeParam v_NodeParam = this.callParams.get(x);
                    v_ParamValues[x] = ValueHelp.getValue(v_NodeParam.getValue(), v_NodeParam.gatValueClass(), v_NodeParam.gatValueDefaultObject(), io_Context);
                }
            }
            catch (Exception exce) {
                $Logger.error((Throwable)exce);
                throw new RuntimeException(exce);
            }
        } else {
            v_ParamValues = new Object[]{};
        }
        this.init(io_Context, v_CallObject, v_ParamValues);
    }

    private synchronized void init(Map<String, Object> io_Context, Object i_CallObject, Object[] i_ParamValues) {
        if (this.isInit) {
            return;
        }
        if (Help.isNull((String)this.callMethod)) {
            throw new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallMethod is null.");
        }
        List v_CallMethods = MethodReflect.getMethods(i_CallObject.getClass(), (String)this.callMethod, (int)i_ParamValues.length);
        if (Help.isNull((List)v_CallMethods)) {
            throw new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallMethod[" + this.callMethod + "(" + i_ParamValues.length + ")] is not find.");
        }
        if (v_CallMethods.size() == 1) {
            this.isInit = true;
            this.callMethodObject = (Method)v_CallMethods.get(0);
        } else {
            HashMap<Integer, Method> v_Bests = new HashMap<Integer, Method>();
            for (Method v_Method : v_CallMethods) {
                int v_BestValue = 0;
                Class<?>[] v_MPClassTypes = v_Method.getParameterTypes();
                for (int y = v_MPClassTypes.length - 1; y >= 0; --y) {
                    Class<?> v_ParamValueClass = null;
                    v_ParamValueClass = i_ParamValues[y] == null ? this.callParams.get(y).gatValueClass() : i_ParamValues[y].getClass();
                    if (v_ParamValueClass == null) continue;
                    if (v_ParamValueClass == v_MPClassTypes[y]) {
                        v_BestValue = (int)((double)v_BestValue + Math.pow(1.0, v_MPClassTypes.length - y) * 3.0);
                        continue;
                    }
                    if (v_MPClassTypes[y] == Object.class) {
                        v_BestValue = (int)((double)v_BestValue + Math.pow(1.0, v_MPClassTypes.length - y));
                        continue;
                    }
                    if (!MethodReflect.isExtendImplement(v_ParamValueClass, v_MPClassTypes[y])) continue;
                    v_BestValue = (int)((double)v_BestValue + Math.pow(1.0, v_MPClassTypes.length - y) * 2.0);
                }
                if (v_BestValue <= 0) continue;
                v_Bests.put(v_BestValue, v_Method);
            }
            if (!Help.isNull(v_Bests)) {
                v_CallMethods.clear();
                v_CallMethods = Help.toList((Map)Help.toReverse(v_Bests));
                v_Bests.clear();
                if (v_CallMethods.size() == 1) {
                    this.isInit = true;
                    this.callMethodObject = (Method)v_CallMethods.get(0);
                } else {
                    this.isInit = true;
                    this.callMethodObject = (Method)v_CallMethods.get(0);
                    if (!(i_CallObject instanceof XHttp || i_CallObject instanceof XSQL || i_CallObject instanceof XSQLGroup)) {
                        $Logger.warn("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallMethod[" + this.callMethod + "(" + i_ParamValues.length + ")] is find " + v_CallMethods.size() + " methods.");
                    }
                }
            } else {
                throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallMethod[" + this.callMethod + "(" + i_ParamValues.length + ")] is not find.");
            }
        }
        this.generateInit(io_Context, v_CallMethods, i_ParamValues);
    }

    public String getCallXID() {
        if (Help.isNull((String)this.callXID)) {
            return null;
        }
        return ":" + this.callXID;
    }

    public void setCallXID(String i_CallXID) {
        this.callXID = ValueHelp.standardValueID(i_CallXID);
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getCallMethod() {
        return this.callMethod;
    }

    public void setCallMethod(String i_CallMethod) {
        this.callMethod = i_CallMethod;
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallParam(NodeParam i_Param) {
        NodeConfig nodeConfig = this;
        synchronized (nodeConfig) {
            if (this.callParams == null) {
                this.callParams = new ArrayList<NodeParam>();
            }
        }
        this.callParams.add(i_Param);
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public List<NodeParam> getCallParams() {
        return this.callParams;
    }

    public void setCallParams(List<NodeParam> i_CallParams) {
        this.callParams = i_CallParams;
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private Long gatTimeout(Map<String, Object> i_Context) throws Exception {
        Long v_Timeout = null;
        v_Timeout = Help.isNumber((String)this.timeout) ? Long.valueOf(this.timeout) : (Long)ValueHelp.getValue(this.timeout, Long.class, 0L, i_Context);
        return v_Timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String i_Timeout) {
        if (Help.isNull((String)i_Timeout)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_Timeout)) {
            Long v_Timeout = Long.valueOf(i_Timeout);
            if (v_Timeout < 0L) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.timeout = i_Timeout.trim();
        } else {
            this.timeout = ValueHelp.standardRefID(i_Timeout);
        }
    }

    @Override
    public String toXmlName() {
        return ElementType.Node.getXmlName();
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        if (!Help.isNull((String)this.callXID)) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("callXID", this.getCallXID()));
        }
        if (!Help.isNull((String)this.callMethod)) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("callMethod", this.callMethod));
        }
        if (!Help.isNull(this.callParams)) {
            for (NodeParam v_Param : this.callParams) {
                io_Xml.append(v_Param.toXml(i_Level + 1, i_TreeID));
            }
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = this.toXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            this.toXmlContent(v_Xml, i_Level, v_Level1, v_LevelN, i_SuperTreeID, v_TreeID);
            if (!Help.isNull((String)this.timeout) && !"0".equals(this.timeout)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("timeout", this.timeout));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        v_Builder.append(":");
        if (!Help.isNull((String)this.callXID)) {
            v_Builder.append(this.callXID);
            if (XJava.getObject((String)this.callXID) == null) {
                v_Builder.append(" is NULL");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (!Help.isNull((String)this.callMethod)) {
            v_Builder.append(this.callMethod);
            this.init(i_Context);
            if (this.callMethodObject == null) {
                v_Builder.append(" not find");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append("(");
        if (!Help.isNull(this.callParams)) {
            for (int x = 0; x < this.callParams.size(); ++x) {
                if (x >= 1) {
                    v_Builder.append(" ,");
                }
                v_Builder.append(this.callParams.get(x).toString(i_Context));
            }
        }
        v_Builder.append(")");
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        v_Builder.append(":");
        if (!Help.isNull((String)this.callXID)) {
            v_Builder.append(this.callXID);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (!Help.isNull((String)this.callMethod)) {
            v_Builder.append(this.callMethod);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append("(");
        if (!Help.isNull(this.callParams)) {
            for (int x = 0; x < this.callParams.size(); ++x) {
                if (x >= 1) {
                    v_Builder.append(" ,");
                }
                v_Builder.append(this.callParams.get(x).toString());
            }
        }
        v_Builder.append(")");
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new NodeConfig();
    }

    @Override
    public Object cloneMyOnly() {
        NodeConfig v_Clone = new NodeConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callXID = this.callXID;
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        if (!Help.isNull(this.callParams)) {
            v_Clone.callParams = new ArrayList<NodeParam>();
            for (NodeParam v_NodeParam : this.callParams) {
                v_Clone.callParams.add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone NodeConfig xid is null.");
        }
        NodeConfig v_Clone = (NodeConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callXID = this.callXID;
        v_Clone.callMethod = this.callMethod;
        v_Clone.timeout = this.timeout;
        if (!Help.isNull(this.callParams)) {
            v_Clone.callParams = new ArrayList<NodeParam>();
            for (NodeParam v_NodeParam : this.callParams) {
                NodeParam v_CloneNodeParam = new NodeParam();
                v_NodeParam.clone(v_CloneNodeParam, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.callParams.add(v_CloneNodeParam);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone NodeConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        NodeConfig v_Clone = new NodeConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

