/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.context.MapContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.xml.log.Logger;

public class CalculateConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(CalculateConfig.class);
    private static final String[] $Fel_BlockingUp = new String[]{"{", "}"};
    private static final FelEngine $FelEngine = new FelEngineImpl();
    private String calc;
    private String calcFel;
    private PartitionMap<String, Integer> placeholders;

    public CalculateConfig() {
        this(0L, 0L);
    }

    public CalculateConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public String getElementType() {
        return ElementType.Calculate.getValue();
    }

    public String getElementTypeDetail() {
        if (Help.isNull((String)this.returnID)) {
            return ElementType.Calculate.getValue();
        }
        return ElementType.Condition.getValue();
    }

    public String getCalc() {
        return this.calc;
    }

    public void setCalc(String i_Calc) {
        this.calc = i_Calc.trim();
        this.calcFel = i_Calc.trim();
        this.placeholders = null;
        if (!Help.isNull((String)this.calc)) {
            this.placeholders = Help.toReverse((PartitionMap)StringHelp.parsePlaceholders((String)this.calc, (boolean)true));
            for (String v_Key : this.placeholders.keySet()) {
                this.calcFel = StringHelp.replaceAll((String)this.calcFel, (String)(":" + v_Key), (String)StringHelp.replaceAll((String)v_Key, (String)".", (String)"_"));
            }
            this.calcFel = StringHelp.replaceAll((String)this.calcFel, (String[])$Fel_BlockingUp, (String[])new String[]{""});
        } else {
            this.calc = null;
            this.calcFel = null;
            this.placeholders = null;
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            if (!this.handleContext(io_Context, v_Result)) {
                return v_Result;
            }
            if (Help.isNull((String)this.calc)) {
                v_Result.setException(new NullPointerException("Calculate[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s calc is null"));
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            MapContext v_FelContext = new MapContext();
            for (String v_Item : this.placeholders.keySet()) {
                Object v_Key = ":" + v_Item;
                Object v_Value = ValueHelp.getValue((String)v_Key, null, "", io_Context);
                v_Key = StringHelp.replaceAll((String)v_Item, (String)".", (String)"_");
                v_FelContext.set((String)v_Key, v_Value);
            }
            Object v_CalcRet = $FelEngine.eval(this.calcFel, (FelContext)v_FelContext);
            this.refreshReturn(io_Context, v_CalcRet);
            if (Help.isNull((String)this.returnID)) {
                v_Result.setResult((Boolean)v_CalcRet);
            } else {
                v_Result.setResult(v_CalcRet);
            }
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Calculate.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.calc)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("calc", this.calc));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!(Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getFaileds()) && Help.isNull(this.route.getExceptions()))) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                if (Help.isNull((String)this.returnID)) {
                    this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.If.getXmlName(), i_Level, v_TreeID, i_ExportType);
                    this.toXmlRouteItems(v_Xml, this.route.getFaileds(), RouteType.Else.getXmlName(), i_Level, v_TreeID, i_ExportType);
                } else {
                    this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                }
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getFaileds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getFaileds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        if (Help.isNull((String)this.calc)) {
            v_Builder.append("?");
        } else {
            LinkedHashMap<Object, String> v_Replaces = new LinkedHashMap<Object, String>();
            for (String v_Item : this.placeholders.keySet()) {
                try {
                    String v_Key = ":" + v_Item;
                    Object v_Value = ValueHelp.getValue(v_Key, String.class, "?", i_Context);
                    if (v_Value == null) {
                        v_Replaces.put(v_Key, "?");
                        continue;
                    }
                    v_Replaces.put(v_Key, v_Value.toString());
                }
                catch (Exception exce) {
                    $Logger.error("Calculate[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s calc[" + this.calc + "] get[" + v_Item + "] error.", (Throwable)exce);
                    v_Replaces.put(v_Item, "ERROR");
                }
            }
            v_Builder.append(StringHelp.replaceAll((String)this.calc, v_Replaces, (boolean)true));
            v_Replaces.clear();
            Object var3_3 = null;
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        if (Help.isNull((String)this.calc)) {
            v_Builder.append("?");
        } else {
            v_Builder.append(this.calc);
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new CalculateConfig();
    }

    @Override
    public Object cloneMyOnly() {
        CalculateConfig v_Clone = new CalculateConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.setCalc(this.calc);
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CalculateConfig xid is null.");
        }
        CalculateConfig v_Clone = (CalculateConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.setCalc(this.calc);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CalculateConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        CalculateConfig v_Clone = new CalculateConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

