/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.callflow.common.ITreeID;
import org.hy.common.callflow.common.TreeIDHelp;
import org.hy.common.callflow.enums.ExecuteStatus;
import org.hy.common.xml.log.Logger;

public class ExecuteResult
implements ITreeID {
    private static final Logger $Logger = new Logger(ExecuteResult.class);
    public static final TreeIDHelp $TreeID = new TreeIDHelp(".", 1, 1);
    private String treeID;
    private Integer treeLevel;
    private Integer treeNo;
    private Integer nestingLevel;
    private String executeTreeID;
    private String executeXID;
    private String executeLogic;
    private String elementType;
    protected String comment;
    private ExecuteStatus status;
    private Object result;
    private boolean success;
    private Exception exception;
    private Long beginTime = Date.getTimeNano();
    private Long endTime;
    private ExecuteResult previous;
    private List<ExecuteResult> nexts;

    public ExecuteResult() {
        this(1, "", "", "");
    }

    public ExecuteResult(Integer i_NestingLevel, String i_ExecuteTreeID, String i_ExecuteXID, String i_ExecuteLogic) {
        this(i_NestingLevel, i_ExecuteTreeID, i_ExecuteXID, i_ExecuteLogic, null);
    }

    public ExecuteResult(Integer i_NestingLevel, String i_ExecuteTreeID, String i_ExecuteXID, String i_ExecuteLogic, ExecuteResult i_Previous) {
        this.nestingLevel = i_NestingLevel;
        this.success = false;
        this.executeTreeID = i_ExecuteTreeID;
        this.executeXID = i_ExecuteXID;
        this.executeLogic = i_ExecuteLogic;
        this.status = ExecuteStatus.Started;
        this.previous = i_Previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult setTimeout(TimeoutException i_TimeoutException) {
        ExecuteResult executeResult = this;
        synchronized (executeResult) {
            if (this.success || this.exception != null) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("All state setter methods are only allowed to be executed once.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
        }
        this.endTime = Date.getTimeNano();
        this.exception = i_TimeoutException;
        this.success = false;
        this.status = ExecuteStatus.Timeout;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult setCancel() {
        ExecuteResult executeResult = this;
        synchronized (executeResult) {
            if (this.exception != null) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("All state setter methods are only allowed to be executed once.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
        }
        this.endTime = Date.getTimeNano();
        this.exception = new CancellationException();
        this.status = ExecuteStatus.Canceled;
        return this;
    }

    public Object getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult setResult(Object i_Result) {
        ExecuteResult executeResult = this;
        synchronized (executeResult) {
            if (this.success || this.exception != null) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("All state setter methods are only allowed to be executed once.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
        }
        this.endTime = Date.getTimeNano();
        this.success = true;
        this.result = i_Result;
        this.status = ExecuteStatus.Finished;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult setException(Exception i_Exception) {
        ExecuteResult executeResult = this;
        synchronized (executeResult) {
            if ((this.success || this.exception != null) && (this.success || this.exception != null)) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("All state setter methods are only allowed to be executed once.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
        }
        this.endTime = Date.getTimeNano();
        this.exception = i_Exception;
        this.success = false;
        this.status = ExecuteStatus.Exception;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult setException(Exception i_Exception, Object i_Result) {
        ExecuteResult executeResult = this;
        synchronized (executeResult) {
            if ((this.success || this.exception != null) && (this.success || this.exception != null)) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("All state setter methods are only allowed to be executed once.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
        }
        this.endTime = Date.getTimeNano();
        this.exception = i_Exception;
        this.success = false;
        this.status = ExecuteStatus.Exception;
        this.result = i_Result;
        return this;
    }

    public ExecuteResult gatPrevious() {
        return this.previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult setPrevious(ExecuteResult i_Previous) {
        ExecuteResult executeResult = this;
        synchronized (executeResult) {
            if (this.previous != null && (this.success || this.exception != null)) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("The setPrevious method of A can only be called once.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
        }
        this.previous = i_Previous;
        if (this.previous == null) {
            this.setTreeID(null, $TreeID.getMinIndexNo());
        } else {
            int v_IndexNo = 1;
            if (this.previous.getNexts() != null) {
                v_IndexNo = this.previous.getNexts().size() + 1;
            }
            this.setTreeID(this.previous.getTreeID(), v_IndexNo);
        }
        return this;
    }

    public List<ExecuteResult> getNexts() {
        return this.nexts;
    }

    public synchronized ExecuteResult addNext(ExecuteResult i_Next) {
        if (this.nexts == null) {
            this.nexts = new ArrayList<ExecuteResult>();
        }
        this.nexts.add(i_Next);
        return this;
    }

    @Override
    public String getTreeID() {
        return this.treeID;
    }

    private ExecuteResult setTreeID(String i_SuperTreeID, int i_IndexNo) {
        return this.setTreeID($TreeID.getTreeID(i_SuperTreeID, i_IndexNo));
    }

    private ExecuteResult setTreeID(String i_TreeID) {
        if (Help.isNull((String)i_TreeID)) {
            this.treeID = null;
            this.treeLevel = null;
            this.treeNo = null;
        } else {
            this.treeLevel = $TreeID.getLevel(i_TreeID);
            this.treeNo = $TreeID.getIndexNo(i_TreeID);
            this.treeID = i_TreeID;
        }
        return this;
    }

    @Override
    public Integer getTreeLevel() {
        return this.treeLevel;
    }

    @Override
    public Integer getTreeNo() {
        return this.treeNo;
    }

    public Integer getNestingLevel() {
        return this.nestingLevel;
    }

    public String getExecuteTreeID() {
        return this.executeTreeID;
    }

    public ExecuteResult setExecuteTreeID(String i_ExecuteTreeID) {
        this.executeTreeID = i_ExecuteTreeID;
        return this;
    }

    public String getExecuteXID() {
        return this.executeXID;
    }

    public ExecuteResult setExecuteXID(String i_ExecuteXID) {
        this.executeXID = i_ExecuteXID;
        return this;
    }

    public String getExecuteLogic() {
        return this.executeLogic;
    }

    public ExecuteResult setExecuteLogic(String i_ExecuteLogic) {
        this.executeLogic = i_ExecuteLogic;
        return this;
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String i_ElementType) {
        this.elementType = i_ElementType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String i_Comment) {
        this.comment = i_Comment;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Long getBeginTime() {
        return this.beginTime;
    }

    public Date getBeginDate() {
        return Date.nanoToDate((long)this.beginTime);
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Date getEndDate() {
        return Date.nanoToDate((long)this.endTime);
    }

    public ExecuteStatus getStatus() {
        return this.status;
    }
}

