/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.cache.CacheGetConfig;
import org.hy.common.callflow.cache.CacheSetConfig;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.JobIntervalType;
import org.hy.common.callflow.event.JOBConfig;
import org.hy.common.callflow.event.PublishConfig;
import org.hy.common.callflow.event.SubscribeConfig;
import org.hy.common.callflow.event.WSPullConfig;
import org.hy.common.callflow.event.WSPushConfig;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.forloop.ForConfig;
import org.hy.common.callflow.ifelse.ConditionConfig;
import org.hy.common.callflow.ifelse.ConditionItem;
import org.hy.common.callflow.ifelse.IfElse;
import org.hy.common.callflow.nesting.MTConfig;
import org.hy.common.callflow.nesting.MTItem;
import org.hy.common.callflow.nesting.NestingConfig;
import org.hy.common.callflow.node.APIConfig;
import org.hy.common.callflow.node.CalculateConfig;
import org.hy.common.callflow.node.CommandConfig;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.callflow.node.UnzipConfig;
import org.hy.common.callflow.node.WaitConfig;
import org.hy.common.callflow.node.XSQLConfig;
import org.hy.common.callflow.node.ZipConfig;
import org.hy.common.callflow.python.PythonConfig;
import org.hy.common.callflow.returns.ReturnConfig;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;
import org.hy.common.callflow.safe.DecryptFileConfig;
import org.hy.common.callflow.safe.EncryptFileConfig;
import org.hy.common.xml.XJava;

public class ExecuteElementCheckHelp {
    private static ExecuteElementCheckHelp $Instance = new ExecuteElementCheckHelp();

    public static ExecuteElementCheckHelp getInstance() {
        return $Instance;
    }

    public Return<Object> check(IExecute i_ExecObject) {
        Return v_Ret = new Return(true);
        if (i_ExecObject == null) {
            return v_Ret.set(false).setParamStr("CFlowCheck\uff1aExecObject is null.");
        }
        HashMap<String, Integer> v_XIDs = new HashMap<String, Integer>();
        HashMap<String, Integer> v_ForXIDs = new HashMap<String, Integer>();
        HashMap<String, String> v_RefNulls = new HashMap<String, String>();
        if (this.check((Return<Object>)v_Ret, i_ExecObject, v_XIDs, v_ForXIDs, v_RefNulls) && !Help.isNull(v_ForXIDs)) {
            for (Map.Entry v_Item : v_ForXIDs.entrySet()) {
                if ((Integer)v_Item.getValue() > 0) continue;
                v_Ret.set(false).setParamStr("CFlowCheck\uff1aFor.xid[" + (String)v_Item.getKey() + "] refXID count is 0.");
                break;
            }
        }
        if (v_Ret.get() && !Help.isNull(v_RefNulls)) {
            for (Map.Entry v_Item : v_RefNulls.entrySet()) {
                String v_RefXID = ((String)v_Item.getKey()).split(" ")[0];
                String v_RefOwnerXID = (String)v_Item.getValue();
                Integer v_RefCount = (Integer)v_XIDs.get(v_RefXID);
                if (v_RefCount == null) {
                    v_Ret.set(false).setParamStr("CFlowCheck\uff1aXID[" + v_RefOwnerXID + "]'s SelfLoop.RefXID[" + v_RefXID + "] is not exists or not valid.");
                    break;
                }
                ExecuteElement v_Ref = (ExecuteElement)XJava.getObject((String)v_RefXID);
                ExecuteElement v_RefOwner = (ExecuteElement)XJava.getObject((String)v_RefOwnerXID);
                boolean v_IsOK = false;
                for (String v_RefTreeID : v_Ref.getTreeIDs()) {
                    for (String v_OwnerTreeID : v_RefOwner.getTreeIDs()) {
                        if (!v_OwnerTreeID.startsWith(v_RefTreeID)) continue;
                        v_IsOK = true;
                        break;
                    }
                    if (!v_IsOK) continue;
                    break;
                }
                if (v_IsOK) continue;
                v_Ret.set(false).setParamStr("CFlowCheck\uff1aXID[" + v_RefOwnerXID + "]'s SelfLoop.RefXID[" + v_RefXID + "], it must be a forward reference, not a backward reference.");
                break;
            }
        }
        if (v_Ret.get()) {
            ((ExecuteElement)i_ExecObject).checkOK();
        }
        v_XIDs.clear();
        v_ForXIDs.clear();
        v_RefNulls.clear();
        return v_Ret;
    }

    private boolean check(Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs, Map<String, String> io_RefNulls) {
        if (!Help.isNull((String)i_ExecObject.getXJavaID())) {
            Integer v_RefCount = io_XIDs.get(i_ExecObject.getXJavaID());
            if (v_RefCount != null) {
                if (i_ExecObject.gatPrevious() != null && v_RefCount < i_ExecObject.gatPrevious().size() - 1) {
                    io_XIDs.put(i_ExecObject.getXJavaID(), v_RefCount + 1);
                    return true;
                }
                io_Result.set(false).setParamStr("CFlowCheck\uff1aXID[" + i_ExecObject.getXJavaID() + "] cannot be repeated.");
                return false;
            }
            io_XIDs.put(i_ExecObject.getXJavaID(), 0);
        }
        if (i_ExecObject instanceof ForConfig) {
            ForConfig v_For = (ForConfig)i_ExecObject;
            if (Help.isNull((String)v_For.getXid())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aForConfig.xid is null.");
                return false;
            }
            if (Help.isNull((String)v_For.getEnd())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aForConfig[" + Help.NVL((String)v_For.getXid()) + "].end is null.");
                return false;
            }
            if (Help.isNull(v_For.getRoute().getSucceeds())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aForConfig[" + Help.NVL((String)v_For.getXid()) + "].Succeed route is null.");
                return false;
            }
            io_ForXIDs.put(i_ExecObject.getXJavaID(), 0);
        } else if (i_ExecObject instanceof MTConfig) {
            MTConfig v_MT = (MTConfig)i_ExecObject;
            if (Help.isNull(v_MT.getMtitems())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].Mtitems is null.");
                return false;
            }
            int x = 0;
            for (MTItem v_MTItem : v_MT.getMtitems()) {
                if (Help.isNull((String)v_MTItem.getCallFlowXID())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].callFlowXID is null.");
                    return false;
                }
                if (v_MTItem.getCallFlowXID().equals(v_MT.getXJavaID())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].callFlowXID[" + v_MTItem.getCallFlowXID() + "] cannot nest itself.");
                    return false;
                }
                if (!Help.isNull((String)v_MTItem.getValueXIDA())) {
                    if (v_MTItem.getComparer() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].comparer is null.");
                        return false;
                    }
                    if (!ValueHelp.isRefID(v_MTItem.getValueXIDA()) && Help.isNull((String)v_MTItem.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].valueXIDA is Normal type ,but valueClass is null.");
                        return false;
                    }
                }
                if (!Help.isNull((String)v_MTItem.getValueXIDB())) {
                    if (Help.isNull((String)v_MTItem.getValueXIDA())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].valueXIDA is null.");
                        return false;
                    }
                    if (v_MTItem.getComparer() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].comparer is null.");
                        return false;
                    }
                    if (!ValueHelp.isRefID(v_MTItem.getValueXIDB()) && Help.isNull((String)v_MTItem.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].valueXIDB is Normal type ,but valueClass is null.");
                        return false;
                    }
                }
                ++x;
            }
        } else if (i_ExecObject instanceof NestingConfig) {
            NestingConfig v_Nesting = (NestingConfig)i_ExecObject;
            if (Help.isNull((String)v_Nesting.getCallFlowXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNestingConfig[" + Help.NVL((String)v_Nesting.getXid()) + "].callFlowXID is null.");
                return false;
            }
            if (v_Nesting.getCallFlowXID().equals(i_ExecObject.getXJavaID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNestingConfig.callFlowXID[" + v_Nesting.getCallFlowXID() + "] cannot nest itself.");
                return false;
            }
        } else if (i_ExecObject instanceof CalculateConfig) {
            CalculateConfig v_Calculate = (CalculateConfig)i_ExecObject;
            if (Help.isNull((String)v_Calculate.getCalc())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCalculateConfig[" + Help.NVL((String)v_Calculate.getXid()) + "].calc is null.");
                return false;
            }
        } else if (i_ExecObject instanceof WaitConfig) {
            WaitConfig v_Wait = (WaitConfig)i_ExecObject;
            if ("0".equals(v_Wait.getWaitTime())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aWaitConfig[" + Help.NVL((String)v_Wait.getXid()) + "].waitTime is 0.");
                return false;
            }
        } else if (i_ExecObject instanceof ReturnConfig) {
            ReturnConfig v_Return = (ReturnConfig)i_ExecObject;
            if (Help.isNull((String)v_Return.getRetValue())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aReturnConfig[" + Help.NVL((String)v_Return.getXid()) + "].retValue is null.");
                return false;
            }
            if (!ValueHelp.isRefID(v_Return.getRetValue()) && Help.isNull((String)v_Return.getRetClass())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aReturnConfig[" + Help.NVL((String)v_Return.getXid()) + "] retValue is Normal type ,but retClass is null.");
                return false;
            }
            if (!Help.isNull((String)v_Return.getRetDefault()) && !ValueHelp.isRefID(v_Return.getRetDefault()) && Help.isNull((String)v_Return.getRetClass())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aReturnConfig[" + Help.NVL((String)v_Return.getXid()) + "] retDefault is Normal type ,but retClass is null.");
                return false;
            }
        } else if (i_ExecObject instanceof ConditionConfig) {
            ConditionConfig v_Condition = (ConditionConfig)i_ExecObject;
            if (v_Condition.getLogical() == null) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)v_Condition.getXid()) + "].logical is null.");
                return false;
            }
            if (Help.isNull(v_Condition.getItems())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)v_Condition.getXid()) + "] has no condition items.");
                return false;
            }
            this.check_Condition(v_Condition, io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls);
        } else if (i_ExecObject instanceof CacheGetConfig) {
            CacheGetConfig v_CacheGet = (CacheGetConfig)i_ExecObject;
            if (!Help.isNull((String)v_CacheGet.getTable()) && Help.isNull((String)v_CacheGet.getDataBase())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCacheGetConfig[" + Help.NVL((String)v_CacheGet.getDataBase()) + "].database is null ,but table is not null.");
                return false;
            }
            if (!Help.isNull((String)v_CacheGet.getPkID()) && !Help.isNull((String)v_CacheGet.getDataBase()) && Help.isNull((String)v_CacheGet.getTable())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCacheGetConfig[" + Help.NVL((String)v_CacheGet.getTable()) + "].table is null ,but database and pkID are not null.");
                return false;
            }
        } else if (i_ExecObject instanceof CacheSetConfig) {
            CacheSetConfig v_CacheSet = (CacheSetConfig)i_ExecObject;
            if (!Help.isNull((String)v_CacheSet.getTable()) && Help.isNull((String)v_CacheSet.getDataBase())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCacheSetConfig[" + Help.NVL((String)v_CacheSet.getDataBase()) + "].database is null ,but table is not null.");
                return false;
            }
            if (!Help.isNull((String)v_CacheSet.getPkID()) && !Help.isNull((String)v_CacheSet.getDataBase()) && Help.isNull((String)v_CacheSet.getTable())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCacheSetConfig[" + Help.NVL((String)v_CacheSet.getTable()) + "].table is null ,but database and pkID are not null.");
                return false;
            }
        } else if (i_ExecObject instanceof WSPushConfig) {
            WSPushConfig v_WSPush = (WSPushConfig)i_ExecObject;
            if (Help.isNull((String)v_WSPush.getName())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aWSPushConfig[" + Help.NVL((String)v_WSPush.getXid()) + "].name is null.");
                return false;
            }
            if (Help.isNull((String)v_WSPush.getNewMessage())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aWSPushConfig[" + Help.NVL((String)v_WSPush.getXid()) + "].newMessage is null.");
                return false;
            }
        } else if (i_ExecObject instanceof WSPullConfig) {
            WSPullConfig v_WSPull = (WSPullConfig)i_ExecObject;
            if (Help.isNull((String)v_WSPull.getWsURL())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aWSPullConfig[" + Help.NVL((String)v_WSPull.getXid()) + "].wsURL is null.");
                return false;
            }
            if (Help.isNull((String)v_WSPull.getCallFlowXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aWSPullConfig[" + Help.NVL((String)v_WSPull.getXid()) + "].callFlowXID is null.");
                return false;
            }
        } else if (i_ExecObject instanceof PublishConfig) {
            PublishConfig v_Publish = (PublishConfig)i_ExecObject;
            if (Help.isNull((String)v_Publish.getPublishXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aPublishConfig[" + Help.NVL((String)v_Publish.getXid()) + "].publishXID is null.");
                return false;
            }
            if (Help.isNull((String)v_Publish.getMessage())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aPublishConfig[" + Help.NVL((String)v_Publish.getXid()) + "].message is null.");
                return false;
            }
            if (Help.isNull((String)v_Publish.getUserID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aPublishConfig[" + Help.NVL((String)v_Publish.getXid()) + "].userID is null.");
                return false;
            }
            if (!(Help.isNull((Integer)v_Publish.getQoS()) || v_Publish.getQoS() >= 0 && v_Publish.getQoS() <= 2)) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aPublishConfig[" + Help.NVL((String)v_Publish.getXid()) + "].qoS is invalid.");
                return false;
            }
        } else if (i_ExecObject instanceof SubscribeConfig) {
            SubscribeConfig v_Subscribe = (SubscribeConfig)i_ExecObject;
            if (Help.isNull((String)v_Subscribe.getSubscribeXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aSubscribeConfig[" + Help.NVL((String)v_Subscribe.getXid()) + "].subscribeXID is null.");
                return false;
            }
            if (Help.isNull((String)v_Subscribe.getUserID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aSubscribeConfig[" + Help.NVL((String)v_Subscribe.getXid()) + "].userID is null.");
                return false;
            }
            if (Help.isNull((String)v_Subscribe.getCallFlowXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aSubscribeConfig[" + Help.NVL((String)v_Subscribe.getXid()) + "].callFlowXID is null.");
                return false;
            }
        } else if (i_ExecObject instanceof APIConfig) {
            v_API = (APIConfig)i_ExecObject;
            if (Help.isNull((String)((APIConfig)v_API).getUrl())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aAPIConfig[" + Help.NVL((String)v_API.getXid()) + "].url is null.");
                return false;
            }
        } else if (i_ExecObject instanceof XSQLConfig) {
            v_API = (XSQLConfig)i_ExecObject;
            if (Help.isNull((String)((NodeConfig)v_API).getCallXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aXSQLConfig[" + Help.NVL((String)v_API.getXid()) + "].callXID is null.");
                return false;
            }
            if (!Help.isNull(((NodeConfig)v_API).getCallParams())) {
                int x = 0;
                for (NodeParam v_NodeParam : ((NodeConfig)v_API).getCallParams()) {
                    ++x;
                    if (v_NodeParam.getValue() == null && v_NodeParam.getValueDefault() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aXSQLConfig[" + Help.NVL((String)v_API.getXid()) + "].callParams[" + x + "] value and valueDefault is null.");
                        return false;
                    }
                    if (!Help.isNull((String)v_NodeParam.getValue()) && !ValueHelp.isRefID(v_NodeParam.getValue()) && Help.isNull((String)v_NodeParam.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aXSQLConfig[" + Help.NVL((String)v_API.getXid()) + "].callParams[" + x + "] value is Normal type ,but valueClass is null.");
                        return false;
                    }
                    if (Help.isNull((String)v_NodeParam.getValueDefault()) || ValueHelp.isRefID(v_NodeParam.getValueDefault()) || !Help.isNull((String)v_NodeParam.getValueClass())) continue;
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aXSQLConfig[" + Help.NVL((String)v_API.getXid()) + "].callParams[" + x + "] valueDefault is Normal type ,but valueClass is null.");
                    return false;
                }
            }
        } else if (i_ExecObject instanceof JOBConfig) {
            v_API = (JOBConfig)i_ExecObject;
            if (Help.isNull((String)((JOBConfig)v_API).getCallFlowXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aJOBConfig[" + Help.NVL((String)v_API.getXid()) + "].callFlowXID is null.");
                return false;
            }
            if (Help.isNull((String)((JOBConfig)v_API).getIntervalType())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aJOBConfig[" + Help.NVL((String)v_API.getXid()) + "].intervalType is null.");
                return false;
            }
            if (!((JOBConfig)v_API).getIntervalType().startsWith(":") && JobIntervalType.get(((JOBConfig)v_API).getIntervalType()) == null) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aJOBConfig[" + Help.NVL((String)v_API.getXid()) + "].intervalType is invalid.");
                return false;
            }
            if (Help.isNull((String)((JOBConfig)v_API).getIntervalLen())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aJOBConfig[" + Help.NVL((String)v_API.getXid()) + "].intervalLen is null.");
                return false;
            }
            if (!((JOBConfig)v_API).getIntervalLen().startsWith(":")) {
                if (!Help.isNumber((String)((JOBConfig)v_API).getIntervalLen())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aJOBConfig[" + Help.NVL((String)v_API.getXid()) + "].intervalLen is invalid.");
                    return false;
                }
                int v_IntervalLen = Integer.parseInt(((JOBConfig)v_API).getIntervalLen());
                if (v_IntervalLen <= 0) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aJOBConfig[" + Help.NVL((String)v_API.getXid()) + "].intervalLen <= 0.");
                    return false;
                }
            }
        } else if (i_ExecObject instanceof CommandConfig) {
            CommandConfig v_Command = (CommandConfig)i_ExecObject;
            if (Help.isNull((String)v_Command.getCommand())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCommandConfig[" + Help.NVL((String)v_Command.getXid()) + "].command is null.");
                return false;
            }
        } else if (i_ExecObject instanceof PythonConfig) {
            PythonConfig v_Python = (PythonConfig)i_ExecObject;
            if (Help.isNull((String)v_Python.getPython()) && Help.isNull((String)v_Python.getScript())) {
                io_Result.set(false).setParamStr("PythonConfig\uff1aPythonConfig[" + Help.NVL((String)v_Python.getXid()) + "].script and python is null.");
                return false;
            }
        } else if (i_ExecObject instanceof ZipConfig) {
            ZipConfig v_Zip = (ZipConfig)i_ExecObject;
            if (Help.isNull((String)v_Zip.getFile())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aZipConfig[" + Help.NVL((String)v_Zip.getXid()) + "].file is null.");
                return false;
            }
            if (Help.isNull((String)v_Zip.getDir())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aZipConfig[" + Help.NVL((String)v_Zip.getXid()) + "].dir is null.");
                return false;
            }
        } else if (i_ExecObject instanceof UnzipConfig) {
            UnzipConfig v_Unzip = (UnzipConfig)i_ExecObject;
            if (Help.isNull((String)v_Unzip.getFile())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aUnzipConfig[" + Help.NVL((String)v_Unzip.getXid()) + "].file is null.");
                return false;
            }
        } else if (i_ExecObject instanceof EncryptFileConfig) {
            v_EncryptFile = (EncryptFileConfig)i_ExecObject;
            if (Help.isNull((String)((ZipConfig)v_EncryptFile).getFile())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aEncryptFileConfig[" + Help.NVL((String)v_EncryptFile.getXid()) + "].file is null.");
                return false;
            }
            if (Help.isNull((String)((ZipConfig)v_EncryptFile).getDir())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aEncryptFileConfig[" + Help.NVL((String)v_EncryptFile.getXid()) + "].dir is null.");
                return false;
            }
        } else if (i_ExecObject instanceof DecryptFileConfig) {
            v_EncryptFile = (DecryptFileConfig)i_ExecObject;
            if (Help.isNull((String)((UnzipConfig)v_EncryptFile).getFile())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aDecryptFileConfig[" + Help.NVL((String)v_EncryptFile.getXid()) + "].file is null.");
                return false;
            }
            if (Help.isNull((String)((UnzipConfig)v_EncryptFile).getPassword())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aDecryptFileConfig[" + Help.NVL((String)v_EncryptFile.getXid()) + "].password is null.");
                return false;
            }
        } else if (i_ExecObject instanceof NodeConfig) {
            NodeConfig v_Node = (NodeConfig)i_ExecObject;
            if (Help.isNull((String)v_Node.getCallXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callXID is null.");
                return false;
            }
            if (Help.isNull((String)v_Node.getCallMethod())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callMethod is null.");
                return false;
            }
            if (!Help.isNull(v_Node.getCallParams())) {
                int x = 0;
                for (NodeParam v_NodeParam : v_Node.getCallParams()) {
                    ++x;
                    if (v_NodeParam.getValue() == null && v_NodeParam.getValueDefault() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callParams[" + x + "] value and valueDefault is null.");
                        return false;
                    }
                    if (!Help.isNull((String)v_NodeParam.getValue()) && !ValueHelp.isRefID(v_NodeParam.getValue()) && Help.isNull((String)v_NodeParam.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callParams[" + x + "] value is Normal type ,but valueClass is null.");
                        return false;
                    }
                    if (Help.isNull((String)v_NodeParam.getValueDefault()) || ValueHelp.isRefID(v_NodeParam.getValueDefault()) || !Help.isNull((String)v_NodeParam.getValueClass())) continue;
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callParams[" + x + "] valueDefault is Normal type ,but valueClass is null.");
                    return false;
                }
            }
        }
        if (this.check_SelfLoop(i_ExecObject.getRoute().getSucceeds(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls)) {
            if (this.check_SelfLoop(i_ExecObject.getRoute().getFaileds(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls)) {
                return this.check_SelfLoop(i_ExecObject.getRoute().getExceptions(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls);
            }
            return false;
        }
        return false;
    }

    private boolean check_Condition(ConditionConfig i_Condition, Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs, Map<String, String> io_RefNulls) {
        if (i_Condition.getLogical() == null) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].logical is null.");
            return false;
        }
        if (Help.isNull(i_Condition.getItems())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] has no condition items.");
            return false;
        }
        for (IfElse v_Item : i_Condition.getItems()) {
            if (v_Item instanceof ConditionConfig) {
                if (this.check_Condition((ConditionConfig)v_Item, io_Result, i_ExecObject, io_XIDs, io_ForXIDs, io_RefNulls)) continue;
                return false;
            }
            if (v_Item instanceof ConditionItem) {
                ConditionItem v_CItem = (ConditionItem)v_Item;
                if (v_CItem.getComparer() == null) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].comparer is null.");
                    return false;
                }
                if (Help.isNull((String)v_CItem.getValueXIDA())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].valueXIDA is null.");
                    return false;
                }
                if (!ValueHelp.isRefID(v_CItem.getValueXIDA()) && Help.isNull((String)v_CItem.getValueClass())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] valueXIDA is Normal type ,but valueClass is null.");
                    return false;
                }
                if (Help.isNull((String)v_CItem.getValueXIDB()) || ValueHelp.isRefID(v_CItem.getValueXIDB()) || !Help.isNull((String)v_CItem.getValueClass())) continue;
                io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] valueXIDB is Normal type ,but valueClass is null.");
                return false;
            }
            io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].item is unknown type.");
            return false;
        }
        return true;
    }

    private boolean check_SelfLoop(List<RouteItem> i_Childs, Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs, Map<String, String> io_RefNulls) {
        if (!Help.isNull(i_Childs)) {
            for (RouteItem v_RouteItem : i_Childs) {
                ExecuteElement v_Child = v_RouteItem.gatNext();
                if (v_Child == null) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aRouteItem.next is null.");
                    return false;
                }
                if (v_Child instanceof SelfLoop) {
                    SelfLoop v_SelfLoop = (SelfLoop)v_Child;
                    ExecuteElement v_Owner = v_SelfLoop.gatOwner().gatOwner().gatOwner();
                    String v_RefXID = v_SelfLoop.gatRefXID();
                    Integer v_RefCount = io_XIDs.get(v_RefXID);
                    if (v_Owner instanceof ForConfig && v_Owner.getXid().equals(v_SelfLoop.getRefXID())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aSelfLoop.RefXID[" + v_SelfLoop.getRefXID() + "] ref ForConfig[" + v_Owner.getXid() + "] myself.");
                        return false;
                    }
                    if (v_RefCount == null) {
                        io_RefNulls.put(v_RefXID + " " + v_Owner.getXJavaID(), v_Owner.getXJavaID());
                        continue;
                    }
                    v_RefCount = io_ForXIDs.get(v_RefXID);
                    if (v_RefCount == null) continue;
                    io_ForXIDs.put(v_RefXID, v_RefCount + 1);
                    continue;
                }
                if (v_Child == v_RouteItem.gatOwner().gatOwner()) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aRouteItem.next cannot be itself[" + Help.NVL((String)v_RouteItem.gatOwner().gatOwner().getXid()) + "].");
                    return false;
                }
                if (this.check(io_Result, v_Child, io_XIDs, io_ForXIDs, io_RefNulls)) continue;
                return false;
            }
        }
        return true;
    }

    private ExecuteElementCheckHelp() {
    }
}

