/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.KVKLinkMap;
import org.hy.common.PartitionMap;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.TotalNano;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.TreeIDHelp;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ExecuteStatus;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.route.RouteConfig;
import org.hy.common.callflow.route.RouteItem;

public abstract class ExecuteElement
extends TotalNano
implements IExecute,
Cloneable {
    public static final TreeIDHelp $TreeID = new TreeIDHelp("-", 1, 1);
    private boolean keyChange = false;
    protected String id;
    protected String xid;
    protected KVKLinkMap<String, String> treeIDs = new KVKLinkMap();
    protected Map<String, Integer> treeLevels = new LinkedHashMap<String, Integer>();
    protected Map<String, Integer> treeNos = new LinkedHashMap<String, Integer>();
    protected String comment;
    protected String styleName;
    protected Double x;
    protected Double y;
    protected Double z;
    protected Double height;
    protected Double width;
    protected String iconURL;
    protected Double opacity;
    protected String backgroudColor;
    protected String lineStyle;
    protected String lineColor;
    protected Double lineSize;
    protected String fontColor;
    protected String fontFamily;
    protected String fontWeight;
    protected Double fontSize;
    protected String fontAlign;
    protected String createUserID;
    protected String updateUserID;
    protected Date createTime;
    protected Date updateTime;
    protected String returnID;
    protected String statusID;
    protected List<IExecute> previous;
    protected RouteConfig route = new RouteConfig(this);
    protected String context;
    protected PartitionMap<String, Integer> contextPlaceholders;

    public ExecuteElement(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    protected void keyChange() {
        this.keyChange = true;
        if (!Help.isNull(this.previous)) {
            for (IExecute v_Item : this.previous) {
                ((ExecuteElement)v_Item).keyChange();
            }
        }
    }

    protected void checkOK() {
        this.keyChange = false;
    }

    public boolean isKeyChange() {
        return this.keyChange;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String i_Xid) {
        if (CallFlow.isSystemXID(i_Xid)) {
            throw new IllegalArgumentException("ExecuteElement's XID[" + i_Xid + "] is SystemXID.");
        }
        this.xid = i_Xid;
        this.keyChange();
    }

    public void setXJavaID(String i_XJavaID) {
        if (CallFlow.isSystemXID(i_XJavaID)) {
            throw new IllegalArgumentException("ExecuteElement's XJavaID[" + i_XJavaID + "] is SystemXID.");
        }
        this.xid = i_XJavaID;
        this.keyChange();
    }

    public String getXJavaID() {
        return this.xid;
    }

    public synchronized String getContext() {
        return this.context;
    }

    public synchronized void setContext(String i_Context) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_Context)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_Context, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.contextPlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.contextPlaceholders = new TablePartitionLink();
        }
        this.context = i_Context;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    protected boolean handleContext(Map<String, Object> io_Context, ExecuteResult io_Result) {
        if (!Help.isNull((String)this.context)) {
            try {
                String v_Context = ValueHelp.replaceByContext(this.context, this.contextPlaceholders, io_Context);
                Map v_ContextMap = (Map)ValueHelp.getValue(v_Context, Map.class, null, io_Context);
                io_Context.putAll(v_ContextMap);
                v_ContextMap.clear();
                v_ContextMap = null;
            }
            catch (Exception exce) {
                io_Result.setException(exce);
                this.refreshStatus(io_Context, io_Result.getStatus());
                return false;
            }
        }
        return true;
    }

    public void setComment(String i_Comment) {
        this.comment = i_Comment;
    }

    public String getComment() {
        return this.comment;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String i_Id) {
        this.id = i_Id;
    }

    @Override
    public String setTreeID(String i_SuperTreeID, int i_IndexNo) {
        String v_TreeID = $TreeID.getTreeID(i_SuperTreeID, i_IndexNo);
        this.setTreeID(v_TreeID);
        return v_TreeID;
    }

    public void setTreeID(String i_TreeID) {
        if (Help.isNull((String)i_TreeID)) {
            this.treeIDs.clear();
            this.treeLevels.clear();
            this.treeNos.clear();
        } else {
            String v_SuperTreeID = $TreeID.getSuperTreeID(i_TreeID);
            if (this.treeIDs.getReverse((Object)v_SuperTreeID) != null) {
                throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s SuperTreeID[" + v_SuperTreeID + "] is exists for TreeID[" + i_TreeID + "].");
            }
            this.treeIDs.put((Object)i_TreeID, (Object)v_SuperTreeID);
            this.treeLevels.put(i_TreeID, $TreeID.getLevel(i_TreeID));
            this.treeNos.put(i_TreeID, $TreeID.getIndexNo(i_TreeID));
        }
    }

    @Override
    public Collection<String> getTreeIDs() {
        return this.treeIDs.keySet();
    }

    @Override
    public String getTreeID(String i_SuperTreeID) {
        return Help.NVL((String)((String)this.treeIDs.getReverse((Object)Help.NVL((String)i_SuperTreeID))));
    }

    @Override
    public String getTreeSuperID(String i_TreeID) {
        return Help.NVL((String)((String)this.treeIDs.get((Object)Help.NVL((String)i_TreeID))));
    }

    @Override
    public Integer getTreeLevel(String i_TreeID) {
        return this.treeLevels.get(Help.NVL((String)i_TreeID));
    }

    @Override
    public Integer getTreeNo(String i_TreeID) {
        return this.treeNos.get(Help.NVL((String)i_TreeID));
    }

    @Override
    public String getMaxTreeID() {
        if (this.treeIDs.size() <= 0) {
            return "";
        }
        if (this.treeIDs.size() == 1) {
            return (String)this.treeIDs.keySet().iterator().next();
        }
        String[] v_TreeIDs = this.treeIDs.keySet().toArray(new String[0]);
        Arrays.sort(v_TreeIDs, $TreeID);
        return v_TreeIDs[v_TreeIDs.length - 1];
    }

    @Override
    public String getMinTreeID() {
        if (this.treeIDs.size() <= 0) {
            return "";
        }
        if (this.treeIDs.size() == 1) {
            return (String)this.treeIDs.keySet().iterator().next();
        }
        String[] v_TreeIDs = this.treeIDs.keySet().toArray(new String[0]);
        Arrays.sort(v_TreeIDs, $TreeID);
        return v_TreeIDs[0];
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String i_StyleName) {
        this.styleName = i_StyleName;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double i_X) {
        this.x = i_X;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double i_Y) {
        this.y = i_Y;
    }

    public Double getZ() {
        return this.z;
    }

    public void setZ(Double i_Z) {
        this.z = i_Z;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double i_Height) {
        this.height = i_Height;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double i_Width) {
        this.width = i_Width;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public void setIconURL(String i_IconURL) {
        this.iconURL = i_IconURL;
    }

    public Double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Double i_Opacity) {
        this.opacity = i_Opacity;
    }

    public String getBackgroudColor() {
        return this.backgroudColor;
    }

    public void setBackgroudColor(String i_BackgroudColor) {
        this.backgroudColor = i_BackgroudColor;
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String i_LineStyle) {
        this.lineStyle = i_LineStyle;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(String i_LineColor) {
        this.lineColor = i_LineColor;
    }

    public Double getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(Double i_LineSize) {
        this.lineSize = i_LineSize;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String i_FontColor) {
        this.fontColor = i_FontColor;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String i_FontFamily) {
        this.fontFamily = i_FontFamily;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String i_FontWeight) {
        this.fontWeight = i_FontWeight;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double i_FontSize) {
        this.fontSize = i_FontSize;
    }

    public String getFontAlign() {
        return this.fontAlign;
    }

    public void setFontAlign(String i_FontAlign) {
        this.fontAlign = i_FontAlign;
    }

    public String getCreateUserID() {
        return this.createUserID;
    }

    public void setCreateUserID(String i_CreateUserID) {
        this.createUserID = i_CreateUserID;
    }

    public String getUpdateUserID() {
        return this.updateUserID;
    }

    public void setUpdateUserID(String i_UpdateUserID) {
        this.updateUserID = i_UpdateUserID;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date i_CreateTime) {
        this.createTime = i_CreateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date i_UpdateTime) {
        this.updateTime = i_UpdateTime;
    }

    public String getReturnID() {
        return this.returnID;
    }

    public void setReturnID(String i_ReturnID) {
        if (CallFlow.isSystemXID(i_ReturnID)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s returnID[" + i_ReturnID + "] is SystemXID.");
        }
        this.returnID = ValueHelp.standardValueID(i_ReturnID);
        this.keyChange();
    }

    public String getStatusID() {
        return this.statusID;
    }

    public void setStatusID(String i_StatusID) {
        if (CallFlow.isSystemXID(i_StatusID)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s statusID[" + i_StatusID + "] is SystemXID.");
        }
        this.statusID = ValueHelp.standardValueID(i_StatusID);
        this.keyChange();
    }

    @Override
    public List<IExecute> gatPrevious() {
        return this.previous;
    }

    public synchronized void setPrevious(ExecuteElement i_Previous) {
        if (Help.isNull(this.previous)) {
            this.previous = new ArrayList<IExecute>();
        }
        this.previous.add(i_Previous);
        this.keyChange();
    }

    @Override
    public RouteConfig getRoute() {
        return this.route;
    }

    public void setRoute(RouteConfig i_Route) {
        this.route = i_Route;
        this.keyChange();
        if (this.route != null) {
            this.route.setOwner(this);
        }
    }

    protected void refreshReturn(Map<String, Object> io_Context, Object i_Return) {
        if (!Help.isNull((String)this.returnID) && io_Context != null) {
            io_Context.put(this.returnID, i_Return);
        }
    }

    protected void refreshStatus(Map<String, Object> io_Context, ExecuteStatus i_Status) {
        if (!Help.isNull((String)this.statusID) && io_Context != null) {
            io_Context.put(this.statusID, i_Status.getValue());
        }
    }

    public String toXml(int i_Level, ExportType i_ExportType) {
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.comment)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("comment", this.comment));
            }
            if (!Help.isNull((String)this.id)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("id", this.id));
            }
            if (!Help.isNull(this.treeIDs)) {
                for (String v_TreeID : this.treeIDs.keySet()) {
                    v_Xml.append(v_NewSpace).append(IToXml.toValue("treeID", v_TreeID));
                }
            }
            if (!Help.isNull((String)this.context)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("context", this.context, v_NewSpace));
            }
        } else if (!Help.isNull((String)this.comment)) {
            v_Xml.append(v_NewSpace).append(IToXml.toComment(this.comment));
        }
        if (ExportType.UI.equals((Object)i_ExportType) || ExportType.All.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.styleName)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("styleName", this.styleName));
            }
            if (this.x != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("x", this.x));
            }
            if (this.y != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("y", this.y));
            }
            if (this.z != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("z", this.z));
            }
            if (this.height != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("height", this.height));
            }
            if (this.width != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("width", this.width));
            }
            if (!Help.isNull((String)this.iconURL)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("iconURL", this.iconURL));
            }
            if (this.opacity != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("opacity", this.opacity));
            }
            if (!Help.isNull((String)this.backgroudColor)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("backgroudColor", this.backgroudColor));
            }
            if (!Help.isNull((String)this.lineStyle)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("lineStyle", this.lineStyle));
            }
            if (!Help.isNull((String)this.lineColor)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("lineColor", this.lineColor));
            }
            if (!Help.isNull((Double)this.lineSize)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("lineSize", this.lineSize));
            }
            if (!Help.isNull((String)this.fontColor)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontColor", this.fontColor));
            }
            if (!Help.isNull((String)this.fontFamily)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontFamily", this.fontFamily));
            }
            if (!Help.isNull((String)this.fontWeight)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontWeight", this.fontWeight));
            }
            if (!Help.isNull((Double)this.fontSize)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontSize", this.fontSize));
            }
            if (!Help.isNull((String)this.fontAlign)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("fontAlign", this.fontAlign));
            }
            if (!Help.isNull((String)this.createUserID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("createUserID", this.createUserID));
            }
            if (!Help.isNull((String)this.updateUserID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("updateUserID", this.updateUserID));
            }
            if (this.createTime != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("createTime", this.createTime.getFull()));
            }
            if (this.updateTime != null) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("updateTime", this.updateTime.getFull()));
            }
        }
        return v_Xml.toString();
    }

    protected void toXmlRouteItems(StringBuilder io_Xml, List<RouteItem> i_RouteItems, String i_XmlName, int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        if (!Help.isNull(i_RouteItems)) {
            String v_Level1 = "    ";
            String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
            String v_NewSpace = "\n" + v_LevelN + v_Level1;
            for (RouteItem v_RouteItem : i_RouteItems) {
                if (ExportType.UI.equals((Object)i_ExportType)) {
                    io_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toBeginThis(i_XmlName, v_RouteItem.getXJavaID()));
                } else {
                    io_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toBeginID(i_XmlName, v_RouteItem.getXJavaID()));
                }
                io_Xml.append(v_RouteItem.toXml(i_Level + 1, i_SuperTreeID, i_ExportType));
                io_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toEnd(i_XmlName));
            }
        }
    }

    protected void cloneMyOnly(ExecuteElement io_Clone) {
        ExecuteElement v_Clone = io_Clone;
        v_Clone.id = this.id;
        v_Clone.treeIDs.putAll(this.treeIDs);
        v_Clone.treeLevels.putAll(this.treeLevels);
        v_Clone.treeNos.putAll(this.treeNos);
        v_Clone.comment = this.comment;
        v_Clone.styleName = this.styleName;
        v_Clone.x = this.x;
        v_Clone.y = this.y;
        v_Clone.z = this.z;
        v_Clone.height = this.height;
        v_Clone.width = this.width;
        v_Clone.iconURL = this.iconURL;
        v_Clone.opacity = this.opacity;
        v_Clone.backgroudColor = this.backgroudColor;
        v_Clone.lineStyle = this.lineStyle;
        v_Clone.lineColor = this.lineColor;
        v_Clone.lineSize = this.lineSize;
        v_Clone.fontColor = this.fontColor;
        v_Clone.fontFamily = this.fontFamily;
        v_Clone.fontWeight = this.fontWeight;
        v_Clone.fontSize = this.fontSize;
        v_Clone.fontAlign = this.fontAlign;
        v_Clone.createUserID = this.createUserID;
        v_Clone.updateUserID = this.updateUserID;
        v_Clone.createTime = this.createTime == null ? null : new Date(this.createTime.getTime());
        v_Clone.updateTime = this.updateTime == null ? null : new Date(this.updateTime.getTime());
        v_Clone.returnID = this.returnID;
        v_Clone.statusID = this.statusID;
        v_Clone.context = this.context;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        RouteItem v_CloneRouteItem;
        ExecuteElement v_Clone = (ExecuteElement)io_Clone;
        v_Clone.reset(this.getRequestTotal(), this.getSuccessTotal());
        v_Clone.xid = this.cloneXID(this.xid, i_ReplaceXID, i_ReplaceByXID, i_AppendXID);
        io_XIDObjects.put(v_Clone.xid, v_Clone);
        this.cloneMyOnly(v_Clone);
        if (!Help.isNull(this.previous)) {
            v_Clone.previous = new ArrayList<IExecute>();
            for (IExecute v_Item : this.previous) {
                String v_CloneItemXID = this.cloneXID(v_Item.getXJavaID(), i_ReplaceXID, i_ReplaceByXID, i_AppendXID);
                ExecuteElement v_CloneItem = io_XIDObjects.get(v_CloneItemXID);
                if (v_CloneItem == null) {
                    throw new RuntimeException("Clone XID[" + v_CloneItemXID + "] object is not exist.");
                }
                v_Clone.previous.add(v_CloneItem);
            }
        }
        if (!Help.isNull(this.route.getSucceeds())) {
            for (RouteItem v_RouteItem : this.route.getSucceeds()) {
                v_CloneRouteItem = new RouteItem(v_Clone.getRoute(), v_RouteItem.getRouteType());
                v_RouteItem.clone(v_CloneRouteItem, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.getRoute().setSucceed(v_CloneRouteItem);
            }
        }
        if (!Help.isNull(this.route.getFaileds())) {
            for (RouteItem v_RouteItem : this.route.getFaileds()) {
                v_CloneRouteItem = new RouteItem(v_Clone.getRoute(), v_RouteItem.getRouteType());
                v_RouteItem.clone(v_CloneRouteItem, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.getRoute().setFailed(v_CloneRouteItem);
            }
        }
        if (!Help.isNull(this.route.getExceptions())) {
            for (RouteItem v_RouteItem : this.route.getExceptions()) {
                v_CloneRouteItem = new RouteItem(v_Clone.getRoute(), v_RouteItem.getRouteType());
                v_RouteItem.clone(v_CloneRouteItem, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.getRoute().setException(v_CloneRouteItem);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new RuntimeException("Not allowed to call ExecuteElement.clone().");
    }
}

