/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event.websocket;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.enums.WSContentType;
import org.hy.common.callflow.event.websocket.WSPullData;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public interface WSPullExecuter {
    public static final Logger $Logger = new Logger(WSPullExecuter.class);

    public boolean init(WSPullData var1);

    default public boolean onMessage(WSPullData i_WSPullData, String i_Message) {
        ExecuteResult v_FirstResult;
        ExecuteResult v_Result;
        Object v_CallFlowObject = XJava.getObject((String)i_WSPullData.getCallFlowXID());
        if (v_CallFlowObject == null) {
            $Logger.error("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] is not find.");
            return false;
        }
        if (!(v_CallFlowObject instanceof ExecuteElement)) {
            $Logger.error("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] is not ExecuteElement type.");
            return false;
        }
        ExecuteElement v_CallFlow = (ExecuteElement)v_CallFlowObject;
        Map<String, Object> v_Context = i_WSPullData.getExecuteContext();
        if (!Help.isNull((String)i_WSPullData.getReturnID())) {
            if (i_WSPullData.getContentType() == null || WSContentType.Text.equals((Object)i_WSPullData.getContentType())) {
                v_Context.put(i_WSPullData.getReturnID(), i_Message);
            } else if (WSContentType.Json.equals((Object)i_WSPullData.getContentType())) {
                XJSON v_XJson = new XJSON();
                Object v_MsgObject = v_XJson.toJava(i_Message, i_WSPullData.getReturnClass() == null ? HashMap.class : i_WSPullData.getReturnClass());
                v_Context.put(i_WSPullData.getReturnID(), v_MsgObject);
            }
        }
        if (!(v_Result = CallFlow.execute(v_CallFlow, v_Context)).isSuccess()) {
            $Logger.error("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] Error XID = " + v_Result.getExecuteXID());
            $Logger.error("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] Error Msg = " + v_Result.getException().getMessage());
            $Logger.error("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] Error.", (Throwable)v_Result.getException());
        }
        if ((v_FirstResult = CallFlow.getFirstResult(v_Context)) != null) {
            $Logger.info("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] \u65e5\u5fd7\u8f68\u8ff9\n" + CallFlow.getHelpLog().logs(v_FirstResult));
            $Logger.info("CallFlowXID[:" + i_WSPullData.getCallFlowXID() + "] \u6574\u4f53\u7528\u65f6\uff1a" + Date.toTimeLenNano((long)(v_Result.getEndTime() - v_Result.getBeginTime())) + "\n");
        }
        return v_Result.isSuccess();
    }
}

