/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event.websocket;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.WSContentType;
import org.hy.common.callflow.event.WSPullConfig;

public class WSPullData {
    private String xid;
    private String wsURL;
    private String callFlowXID;
    private Map<String, Object> executeContext;
    private WSContentType contentType;
    private String returnID;
    private Class<?> returnClass;

    public WSPullData(WSPullConfig i_Config, Map<String, Object> i_Context, PartitionMap<String, Integer> i_WSURLPlaceholders) throws Exception {
        if (i_Config == null) {
            throw new NullPointerException("WSPullConfig is null.");
        }
        if (Help.isNull(i_Context)) {
            throw new NullPointerException("Context is null.");
        }
        this.setExecuteContext(new HashMap<String, Object>());
        this.executeContext.putAll(i_Context);
        if (!Help.isNull((String)i_Config.getContext())) {
            String v_ContextValue = ValueHelp.replaceByContext(i_Config.getContext(), this.executeContext);
            Map v_ContextMap = (Map)ValueHelp.getValue(v_ContextValue, Map.class, null, this.executeContext);
            this.executeContext.putAll(v_ContextMap);
            v_ContextMap.clear();
            v_ContextMap = null;
        }
        this.setContentType(WSContentType.get(i_Config.getContentType()));
        this.setWsURL(ValueHelp.replaceByContext(i_Config.getWsURL(), i_WSURLPlaceholders, this.executeContext));
        this.setXid(i_Config.getXid());
        this.setCallFlowXID(i_Config.gatCallFlowXID());
        this.setReturnID(i_Config.getReturnID());
        this.setReturnClass(i_Config.gatReturnClass());
    }

    public String getXid() {
        return this.xid;
    }

    private void setXid(String i_Xid) {
        this.xid = i_Xid;
    }

    public String getWsURL() {
        return this.wsURL;
    }

    private void setWsURL(String i_WsURL) {
        this.wsURL = i_WsURL;
    }

    public String getCallFlowXID() {
        return this.callFlowXID;
    }

    private void setCallFlowXID(String i_CallFlowXID) {
        this.callFlowXID = i_CallFlowXID;
    }

    public Map<String, Object> getExecuteContext() {
        HashMap<String, Object> v_Context = new HashMap<String, Object>();
        v_Context.putAll(this.executeContext);
        return v_Context;
    }

    private void setExecuteContext(Map<String, Object> i_ExecuteContext) {
        this.executeContext = i_ExecuteContext;
    }

    public WSContentType getContentType() {
        return this.contentType;
    }

    private void setContentType(WSContentType i_ContentType) {
        this.contentType = i_ContentType;
    }

    public String getReturnID() {
        return this.returnID;
    }

    private void setReturnID(String i_ReturnID) {
        this.returnID = i_ReturnID;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    private void setReturnClass(Class<?> i_ReturnClass) {
        this.returnClass = i_ReturnClass;
    }
}

